/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Foundation.UnmatchedRuleException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Terms.Goals.jPredicateGoal;
import ubc.cs.JLog.Terms.iNameArity;
import ubc.cs.JLog.Terms.jBuiltinRule;
import ubc.cs.JLog.Terms.jCompoundTerm;

public class jRuleDefinitions
implements iNameArity {
    protected Vector rules = null;
    protected String rule_name = null;
    protected int rule_arity = -1;
    protected String library = null;
    protected boolean builtin = false;

    protected jRuleDefinitions() {
    }

    public jRuleDefinitions(String name, int arity) {
        this.rules = new Vector();
        this.rule_name = name;
        this.rule_arity = arity;
    }

    public String getName() {
        return this.rule_name;
    }

    public int getArity() {
        return this.rule_arity;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setLibrary(String lib) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = lib;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String lib) {
        if (this.library == null && lib == null) {
            return true;
        }
        if (this.library == null || lib == null) {
            return false;
        }
        return this.library.equals(lib);
    }

    public int size() {
        return this.rules.size();
    }

    public jRule getRuleAt(int n) {
        return (jRule)this.rules.elementAt(n);
    }

    public final boolean match(iNameArity fn) {
        return fn.getName().equals(this.rule_name) && fn.getArity() == this.rule_arity;
    }

    public void addRule(jRule fn) {
        if (!this.match(fn)) {
            throw new UnmatchedRuleException();
        }
        this.rules.addElement(fn);
    }

    public void addRuleFirst(jRule fn) {
        if (!this.match(fn)) {
            throw new UnmatchedRuleException();
        }
        this.rules.insertElementAt(fn, 0);
    }

    public void addRuleLast(jRule fn) {
        if (!this.match(fn)) {
            throw new UnmatchedRuleException();
        }
        this.rules.insertElementAt(fn, this.rules.size());
    }

    public void removeRule(jRule fn) {
        this.rules.removeElement(fn);
    }

    public void clearRules() {
        this.rules = new Vector();
    }

    public Enumeration enumRules() {
        return this.rules.elements();
    }

    public jPredicateGoal createGoal(jCompoundTerm t) {
        return new jPredicateGoal(this, t);
    }

    public void consult(jKnowledgeBase kb) {
        Enumeration e = this.enumRules();
        while (e.hasMoreElements()) {
            jRule r = (jRule)e.nextElement();
            if (r instanceof jBuiltinRule) {
                this.builtin = true;
            }
            r.consult(kb);
        }
    }

    public final boolean prove(jPredicateGoal pg, iGoalStack goals) {
        int next_rule;
        while ((next_rule = pg.getNextRuleNumber()) < this.rules.size()) {
            if (!((jRule)this.rules.elementAt(next_rule)).unify(pg, goals)) continue;
            return true;
        }
        return false;
    }

    public boolean retry(jPredicateGoal pg) {
        return pg.getRuleNumber() < this.rules.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "/" + Integer.toString(this.getArity()));
        String lib = this.getLibrary();
        if (lib != null) {
            sb.append(" library:" + lib);
        }
        return sb.toString();
    }
}

