/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ubc.cs.JLog.Foundation.LoadLibraryException;
import ubc.cs.JLog.Foundation.iPrologFileServices;
import ubc.cs.JLog.Foundation.jAPIConsultThread;
import ubc.cs.JLog.Foundation.jAPIQueryThread;
import ubc.cs.JLog.Foundation.jConsultAndQueryThread;
import ubc.cs.JLog.Foundation.jConsultSourceThread;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jResetDatabaseThread;
import ubc.cs.JLog.Foundation.jUserQueryThread;
import ubc.cs.JLog.Parser.pGenericOperatorEntry;
import ubc.cs.JLog.Parser.pGenericPredicateEntry;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPredicateEntry;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Terms.jPredefined;
import ubc.cs.JLog.Terms.jPredefinedTerms;

public class jPrologServices {
    static final String LIB_INIT_TOC_PREFIX = "INIT_";
    static final String LIB_INIT_TOC_POSTFIX = "LIB.TOC";
    static final String LIB_POSTFIX_STR = "Lib.jar";
    static final String BUILTINS_LIB = "builtins";
    protected jPrologServiceThread thread = null;
    protected jKnowledgeBase database;
    protected pPredicateRegistry predicates;
    protected pOperatorRegistry operators;
    protected Random rand;
    protected jPrologServiceBroadcaster beginQuery;
    protected jPrologServiceBroadcaster retryQuery;
    protected jPrologServiceBroadcaster endQuery;
    protected jPrologServiceBroadcaster beginConsult;
    protected jPrologServiceBroadcaster endConsult;
    protected jPrologServiceBroadcaster threadStopped;
    protected jPrologServiceBroadcaster debugMessages;
    protected jPrologServiceBroadcaster stateChanged;
    protected PrintWriter default_output = null;
    protected PrintWriter current_output = null;
    protected BufferedReader default_input = null;
    protected BufferedReader current_input = null;
    protected iPrologFileServices fileservices = null;
    protected Object animation = null;
    protected boolean debugging = false;
    protected boolean fail_unknown_predicate = false;

    public static String getRequiredCreditInfo() {
        return "JLog v1.3.5  Prolog in Java.\n\nCreated by Glendon Holst\n for Alan Mackworth and \"Computational Intelligence: A Logical Approach\" text.\n\nCopyright 1998, 2000, 2002, 2004, 2005 by University of British Columbia\n\nReleased under the GNU GPL (General Public License):\n JLog is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;\n without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n See the GNU General Public License for more details: <http://www.fsf.org> or <http://www.gnu.org>.\n\n Source code available from: <http://jlogic.sourceforge.net/> or <http://sourceforge.net/projects/jlogic>\n\nThis information string must remain, in its entirety, in all distributions of this work (derivative or otherwise).\n Authors of derivative works may note their involvement by appending their information below:\n\n---------------------------------------------\n\n";
    }

    public jPrologServices(jKnowledgeBase kb, pPredicateRegistry pr, pOperatorRegistry or) {
        this.database = kb;
        this.predicates = pr;
        this.operators = or;
        this.beginQuery = new jPrologServiceBroadcaster();
        this.retryQuery = new jPrologServiceBroadcaster();
        this.endQuery = new jPrologServiceBroadcaster();
        this.beginConsult = new jPrologServiceBroadcaster();
        this.endConsult = new jPrologServiceBroadcaster();
        this.threadStopped = new jPrologServiceBroadcaster();
        this.debugMessages = new jPrologServiceBroadcaster();
        this.stateChanged = new jPrologServiceBroadcaster();
        this.rand = new Random();
        jPredefinedTerms pd = new jPredefinedTerms(this);
        ((jPredefined)pd).register();
    }

    public synchronized void addBeginQueryListener(jPrologServiceListener l) {
        this.beginQuery.addListener(l);
    }

    public synchronized void addRetryQueryListener(jPrologServiceListener l) {
        this.retryQuery.addListener(l);
    }

    public synchronized void addEndQueryListener(jPrologServiceListener l) {
        this.endQuery.addListener(l);
    }

    public synchronized void addBeginConsultListener(jPrologServiceListener l) {
        this.beginConsult.addListener(l);
    }

    public synchronized void addEndConsultListener(jPrologServiceListener l) {
        this.endConsult.addListener(l);
    }

    public synchronized void removeBeginQueryListener(jPrologServiceListener l) {
        this.beginQuery.removeListener(l);
    }

    public synchronized void removeRetryQueryListener(jPrologServiceListener l) {
        this.retryQuery.removeListener(l);
    }

    public synchronized void removeEndQueryListener(jPrologServiceListener l) {
        this.endQuery.removeListener(l);
    }

    public synchronized void removeBeginConsultListener(jPrologServiceListener l) {
        this.beginConsult.removeListener(l);
    }

    public synchronized void removeEndConsultListener(jPrologServiceListener l) {
        this.endConsult.removeListener(l);
    }

    public synchronized void addThreadStoppedListener(jPrologServiceListener l) {
        this.threadStopped.addListener(l);
    }

    public synchronized void removeThreadStoppedListener(jPrologServiceListener l) {
        this.threadStopped.removeListener(l);
    }

    public synchronized void addDebugMessagesListener(jPrologServiceListener l) {
        this.debugMessages.addListener(l);
    }

    public synchronized void removeDebugMessagesListener(jPrologServiceListener l) {
        this.debugMessages.removeListener(l);
    }

    public synchronized void addStateChangedListener(jPrologServiceListener l) {
        this.stateChanged.addListener(l);
    }

    public synchronized void removeStateChangedListener(jPrologServiceListener l) {
        this.stateChanged.removeListener(l);
    }

    public synchronized boolean isAvailable() {
        return this.thread == null || !this.thread.isAlive();
    }

    public synchronized boolean start(jPrologServiceThread t) {
        if (this.isAvailable()) {
            this.resetOutput();
            this.resetInput();
            this.thread = t;
            if (this.thread instanceof jUserQueryThread) {
                ((jUserQueryThread)this.thread).setListeners(this.beginQuery, this.retryQuery, this.endQuery, this.threadStopped, this.debugMessages);
            } else if (this.thread instanceof jAPIQueryThread) {
                ((jAPIQueryThread)this.thread).setListeners(this.beginQuery, this.retryQuery, this.endQuery, this.threadStopped, this.debugMessages);
            } else if (this.thread instanceof jAPIConsultThread) {
                ((jAPIConsultThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jConsultSourceThread) {
                ((jConsultSourceThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jResetDatabaseThread) {
                ((jResetDatabaseThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.threadStopped);
            } else if (this.thread instanceof jConsultAndQueryThread) {
                ((jConsultAndQueryThread)this.thread).setListeners(this.beginConsult, this.endConsult, this.beginQuery, this.retryQuery, this.endQuery, this.debugMessages, this.threadStopped);
            }
            this.thread.start();
            return true;
        }
        return false;
    }

    public synchronized void start() {
        this.resetKnowledgeBase();
        this.resetOutput();
        this.resetInput();
    }

    public synchronized void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
        } else {
            this.thread = null;
        }
    }

    public synchronized void release() {
        this.thread = null;
    }

    public synchronized void suspend() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.suspend();
        } else {
            this.thread = null;
        }
    }

    public synchronized void resume() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.resume();
        } else {
            this.thread = null;
        }
    }

    public void resetKnowledgeBase() {
        this.database.clearRules();
        this.predicates.clearPredicates();
        this.operators.clearOperators();
        jPredefinedTerms pd = new jPredefinedTerms(this);
        ((jPredefined)pd).register();
        try {
            this.loadLibrary(BUILTINS_LIB);
        }
        catch (IOException e) {
            throw new LoadLibraryException("IO Error loading builtins library");
        }
    }

    public jKnowledgeBase getKnowledgeBase() {
        return this.database;
    }

    public pPredicateRegistry getPredicateRegistry() {
        return this.predicates;
    }

    public pOperatorRegistry getOperatorRegistry() {
        return this.operators;
    }

    public void setAnimationEnvironment(Object ae) {
        this.animation = ae;
    }

    public Object getAnimationEnvironment() {
        return this.animation;
    }

    public void loadLibrary(String lib) throws IOException {
        iPrologFileServices pfs = this.getFileServices();
        if (pfs == null) {
            throw new LoadLibraryException("Missing FileServices");
        }
        String tocname = LIB_INIT_TOC_PREFIX + lib.toUpperCase() + LIB_INIT_TOC_POSTFIX;
        try {
            InputStream toc_is = pfs.getResourceInputStreamFromFilename(tocname);
            this.loadLibraryFromTOC(lib, toc_is);
            return;
        }
        catch (IOException e) {
            ZipEntry zentry;
            String libname = lib + LIB_POSTFIX_STR;
            ZipInputStream lib_is = new ZipInputStream(pfs.getInputStreamFromFilename(libname));
            while ((zentry = lib_is.getNextEntry()) != null) {
                if (!zentry.getName().equals(tocname)) continue;
                this.loadLibraryFromTOC(lib, lib_is);
                break;
            }
            return;
        }
    }

    protected void loadLibraryFromTOC(String lib, InputStream toc_is) throws IOException {
        int token;
        BufferedReader toc_read = new BufferedReader(new InputStreamReader(toc_is));
        StreamTokenizer tokenizer = new StreamTokenizer(toc_read);
        tokenizer.commentChar(35);
        tokenizer.quoteChar(34);
        tokenizer.ordinaryChar(58);
        tokenizer.wordChars(95, 95);
        tokenizer.lowerCaseMode(false);
        tokenizer.eolIsSignificant(true);
        while ((token = tokenizer.nextToken()) != -1) {
            if (token == -3 && tokenizer.sval.equalsIgnoreCase("LoadClass")) {
                this.loadLibraryTOCParseLoadClass(lib, tokenizer);
            } else if (token == -3 && tokenizer.sval.equalsIgnoreCase("RegisterGenericPredicateEntry")) {
                this.loadLibraryTOCParseGenericPredicate(lib, tokenizer);
            } else if (token == -3 && tokenizer.sval.equalsIgnoreCase("RegisterGenericOperatorEntry")) {
                this.loadLibraryTOCParseGenericOperator(lib, tokenizer);
            } else if (token == 10) {
                tokenizer.pushBack();
            }
            do {
                if ((token = tokenizer.nextToken()) != -1) continue;
                tokenizer.pushBack();
            } while (token != -1 && token != 10);
        }
    }

    protected void loadLibraryTOCParseLoadClass(String lib, StreamTokenizer tokenizer) throws IOException {
        int token = tokenizer.nextToken();
        if (token != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        token = tokenizer.nextToken();
        if (token != -3) {
            throw new LoadLibraryException("Expected Class Name in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        this.loadClass(lib, tokenizer.sval);
    }

    protected void loadLibraryTOCParseGenericPredicate(String lib, StreamTokenizer tokenizer) throws IOException {
        String name;
        int token = tokenizer.nextToken();
        if (token != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        token = tokenizer.nextToken();
        if (token == 34) {
            name = tokenizer.sval;
        } else if (token == -3) {
            name = tokenizer.sval;
        } else {
            throw new LoadLibraryException("Expected Name string in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        token = tokenizer.nextToken();
        if (token != -2) {
            throw new LoadLibraryException("Expected Arity integer in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        int arity = (int)Math.round(tokenizer.nval);
        token = tokenizer.nextToken();
        if (token != -3) {
            throw new LoadLibraryException("Expected Class name in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        String classname = tokenizer.sval;
        pGenericPredicateEntry gpe = new pGenericPredicateEntry(name, arity, this.loadClass(lib, classname));
        this.registerPredicateOperatorEntryInstance(lib, gpe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadLibraryTOCParseGenericOperator(String lib, StreamTokenizer tokenizer) throws IOException {
        boolean atoms;
        int type;
        String name;
        int token = tokenizer.nextToken();
        if (token != 58) {
            throw new LoadLibraryException("Expected ':' separator in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        token = tokenizer.nextToken();
        if (token == 34) {
            name = tokenizer.sval;
        } else {
            if (token != -3) throw new LoadLibraryException("Expected Name string in TOC at line: " + Integer.toString(tokenizer.lineno()));
            name = tokenizer.sval;
        }
        token = tokenizer.nextToken();
        if (token != -3) throw new LoadLibraryException("Expected Type (FX,FY,XFX,XFY,YFX,XF,YF) in TOC at line: " + Integer.toString(tokenizer.lineno()));
        if (tokenizer.sval.equalsIgnoreCase("FX")) {
            type = 1;
        } else if (tokenizer.sval.equalsIgnoreCase("FY")) {
            type = 2;
        } else if (tokenizer.sval.equalsIgnoreCase("XFX")) {
            type = 17;
        } else if (tokenizer.sval.equalsIgnoreCase("XFY")) {
            type = 18;
        } else if (tokenizer.sval.equalsIgnoreCase("YFX")) {
            type = 33;
        } else if (tokenizer.sval.equalsIgnoreCase("XF")) {
            type = 16;
        } else {
            if (!tokenizer.sval.equalsIgnoreCase("YF")) throw new LoadLibraryException("Expected Type (FX,FY,XFX,XFY,YFX,XF,YF) in TOC at line: " + Integer.toString(tokenizer.lineno()));
            type = 32;
        }
        token = tokenizer.nextToken();
        if (token != -2) {
            throw new LoadLibraryException("Expected Priority integer in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        int priority = (int)Math.round(tokenizer.nval);
        token = tokenizer.nextToken();
        if (token != -3) throw new LoadLibraryException("Expected Allow Atoms boolean (TRUE,FALSE) in TOC at line: " + Integer.toString(tokenizer.lineno()));
        if (tokenizer.sval.equalsIgnoreCase("TRUE")) {
            atoms = true;
        } else {
            if (!tokenizer.sval.equalsIgnoreCase("FALSE")) throw new LoadLibraryException("Expected Allow Atoms boolean (TRUE,FALSE) in TOC at line: " + Integer.toString(tokenizer.lineno()));
            atoms = false;
        }
        token = tokenizer.nextToken();
        if (token != -3) {
            throw new LoadLibraryException("Expected Class name in TOC at line: " + Integer.toString(tokenizer.lineno()));
        }
        String classname = tokenizer.sval;
        pGenericOperatorEntry goe = new pGenericOperatorEntry(name, type, priority, atoms, this.loadClass(lib, classname));
        this.registerPredicateOperatorEntryInstance(lib, goe);
    }

    public Class loadClass(String lib, String classname) {
        iPrologFileServices pfs = this.getFileServices();
        Class<?> obj_class = null;
        Object obj_inst = null;
        try {
            obj_class = Class.forName(classname);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (obj_class == null) {
            try {
                URL curl = pfs.getURLFromFilename(lib + LIB_POSTFIX_STR);
                Class<?> cload_class = Class.forName("java.net.URLClassLoader");
                Constructor<?> cload_cons = null;
                ClassLoader cloader = null;
                cload_cons = cload_class.getConstructor(URL[].class);
                cloader = (ClassLoader)cload_cons.newInstance(new Object[]{new URL[]{curl}});
                obj_class = cloader.loadClass(classname);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (obj_class == null) {
            throw new LoadLibraryException("Failed to load class: " + classname);
        }
        try {
            if (pPredicateEntry.class.isAssignableFrom(obj_class) || pOperatorEntry.class.isAssignableFrom(obj_class)) {
                obj_inst = obj_class.newInstance();
                this.registerPredicateOperatorEntryInstance(lib, obj_inst);
            } else if (jPredefined.class.isAssignableFrom(obj_class)) {
                Constructor<?> obj_cons = obj_class.getConstructor(jPrologServices.class, String.class);
                obj_inst = obj_cons.newInstance(this, lib);
                this.registerPredefinedInstance(lib, obj_inst);
            }
        }
        catch (Exception e) {
            throw new LoadLibraryException("Failed to instantiate or register class instance");
        }
        return obj_class;
    }

    protected void registerPredicateOperatorEntryInstance(String lib, Object obj_inst) {
        if (obj_inst instanceof pPredicateEntry) {
            pPredicateEntry pentry = (pPredicateEntry)obj_inst;
            pPredicateRegistry preg = this.getPredicateRegistry();
            pPredicateEntry pmatch = preg.getPredicate(pentry.getName(), pentry.getArity());
            if (pmatch == null) {
                pentry.setLibrary(lib);
                preg.addPredicate(pentry);
            } else if (pmatch.getLibrary() != null && !pmatch.getLibrary().equals(lib)) {
                String err = "Predicate " + pmatch.getName() + "/" + pmatch.getArity() + " already exists in library " + pmatch.getLibrary();
                throw new LoadLibraryException(err);
            }
        } else if (obj_inst instanceof pOperatorEntry) {
            pOperatorEntry oentry = (pOperatorEntry)obj_inst;
            pOperatorRegistry oreg = this.getOperatorRegistry();
            pOperatorEntry omatch = oreg.getOperator(oentry.getName(), oentry.hasLHS());
            if (omatch == null) {
                oentry.setLibrary(lib);
                oreg.addOperator(oentry);
            } else if (omatch.getLibrary() != null && !omatch.getLibrary().equals(lib)) {
                String err = "Operator " + omatch.getName() + " already exists in library " + omatch.getLibrary();
                throw new LoadLibraryException(err);
            }
        }
    }

    protected void registerPredefinedInstance(String lib, Object obj_inst) {
        if (obj_inst instanceof jPredefined) {
            jPredefined predef = (jPredefined)obj_inst;
            predef.register();
        }
    }

    public void setDebugging(boolean dp) {
        boolean old_debug = this.debugging;
        this.debugging = dp;
        if (this.stateChanged != null && old_debug != this.debugging) {
            this.stateChanged.broadcastEvent(new jPrologServiceEvent());
        }
    }

    public boolean getDebugging() {
        return this.debugging;
    }

    public void setFailUnknownPredicate(boolean fp) {
        boolean old_fup = this.fail_unknown_predicate;
        this.fail_unknown_predicate = fp;
        if (this.stateChanged != null && old_fup != this.fail_unknown_predicate) {
            this.stateChanged.broadcastEvent(new jPrologServiceEvent());
        }
    }

    public boolean getFailUnknownPredicate() {
        return this.fail_unknown_predicate;
    }

    public Random getRandomGenerator() {
        return this.rand;
    }

    public void setDefaultOutput(PrintWriter o) {
        this.default_output = o;
        this.current_output = o;
    }

    public void setOutput(PrintWriter o) {
        this.current_output = o;
    }

    public PrintWriter getOutput() {
        return this.current_output;
    }

    public void resetOutput() {
        this.current_output = this.default_output;
    }

    public void printOutput(String s) {
        if (this.current_output != null) {
            this.current_output.print(s);
            this.current_output.flush();
        }
    }

    public void setDefaultInput(BufferedReader i) {
        this.default_input = i;
        this.current_input = i;
    }

    public void setInput(BufferedReader i) {
        this.current_input = i;
    }

    public BufferedReader getInput() {
        return this.current_input;
    }

    public void resetInput() {
        this.current_input = this.default_input;
    }

    public void setFileServices(iPrologFileServices fs) {
        this.fileservices = fs;
    }

    public iPrologFileServices getFileServices() {
        return this.fileservices;
    }
}

