/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import ubc.cs.JLog.Foundation.NoThreadAvailableException;
import ubc.cs.JLog.Foundation.iPrologFileServices;
import ubc.cs.JLog.Foundation.jAPIConsultThread;
import ubc.cs.JLog.Foundation.jAPIQueryThread;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologFileServices;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceListener;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTermTranslation;

public class jPrologAPI {
    protected static final int QUERY_STATE_WAITING = 0;
    protected static final int QUERY_STATE_SUCCEEDED = 1;
    protected static final int QUERY_STATE_FINISHED = 2;
    protected jPrologServices prolog = new jPrologServices(new jKnowledgeBase(), new pPredicateRegistry(), new pOperatorRegistry());
    protected jAPIQueryThread thread = null;
    protected Hashtable var_translation_keys = null;
    protected jTermTranslation translations = null;
    protected int query_state = 0;

    public jPrologAPI(String source) {
        this.prolog.setFileServices(new jPrologFileServices());
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(source);
    }

    public jPrologAPI(InputStream source) throws IOException {
        this.prolog.setFileServices(new jPrologFileServices());
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(this.prolog.getFileServices().getTextFromInputStream(source));
    }

    public jPrologAPI(String source, iPrologFileServices fs, PrintWriter output, BufferedReader input, Object ae) {
        if (fs != null) {
            this.prolog.setFileServices(fs);
        } else {
            this.prolog.setFileServices(new jPrologFileServices());
        }
        this.prolog.setDefaultOutput(output);
        this.prolog.setDefaultInput(input);
        this.prolog.setAnimationEnvironment(ae);
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(source);
    }

    public jPrologAPI(InputStream source, iPrologFileServices fs, PrintWriter output, BufferedReader input, Object ae) throws IOException {
        if (fs != null) {
            this.prolog.setFileServices(fs);
        } else {
            this.prolog.setFileServices(new jPrologFileServices());
        }
        this.prolog.setDefaultOutput(output);
        this.prolog.setDefaultInput(input);
        this.prolog.setAnimationEnvironment(ae);
        this.initTranslation();
        this.initPrologListeners();
        this.initConsultSource(this.prolog.getFileServices().getTextFromInputStream(source));
    }

    protected void initTranslation() {
        this.var_translation_keys = new Hashtable();
        this.translations = new jTermTranslation(this.prolog);
        this.translations.setDefaults();
    }

    protected void initPrologListeners() {
        this.prolog.addRetryQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent e) {
                jUserQueryEvent uqe;
                if (e instanceof jUserQueryEvent && (uqe = (jUserQueryEvent)e).getResult()) {
                    jPrologAPI.this.setQueryResultState(true);
                }
            }
        });
        this.prolog.addEndQueryListener(new jPrologServiceListener(){

            public void handleEvent(jPrologServiceEvent e) {
                if (jPrologAPI.this.query_state == 0) {
                    jPrologAPI.this.setQueryResultState(false);
                }
            }
        });
    }

    protected void initConsultSource(String source) {
        pParseStream parser = new pParseStream(source, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.prolog.start();
        this.consultSource(source);
    }

    public String getRequiredCreditInfo() {
        return jPrologServices.getRequiredCreditInfo();
    }

    public void setFailUnknownPredicate(boolean fp) {
        this.prolog.setFailUnknownPredicate(fp);
    }

    public boolean getFailUnknownPredicate() {
        return this.prolog.getFailUnknownPredicate();
    }

    public void setVariableTranslationKeys(String v, Object tkey, Object okey) {
        if (tkey == null && okey == null) {
            this.var_translation_keys.remove(v);
        } else {
            this.var_translation_keys.put(v, new KeyPairs(tkey, okey));
        }
    }

    public jTermTranslation getTranslation() {
        return this.translations;
    }

    public void setTranslation(jTermTranslation tt) {
        this.translations = tt;
    }

    public synchronized void consultSource(String source) {
        jAPIConsultThread cthread;
        pParseStream parser = new pParseStream(source, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.joinForcedQueryCompletion();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.prolog.start(cthread = new jAPIConsultThread(this.prolog, source))) {
            throw new NoThreadAvailableException("consult failed, other events pending.");
        }
        try {
            cthread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        RuntimeException ex = cthread.getResultException();
        if (ex != null) {
            throw ex;
        }
    }

    public Hashtable query(String query) {
        return this.query(query, null);
    }

    public synchronized Hashtable queryOnce(String query) {
        Hashtable result = this.query(query, null);
        this.stop();
        return result;
    }

    public synchronized Hashtable query(String query, Hashtable bindings) {
        Hashtable<String, jTerm> bind_terms = null;
        if (bindings != null) {
            Enumeration e = bindings.keys();
            bind_terms = new Hashtable<String, jTerm>();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = bindings.get(key);
                KeyPairs kpairs = (KeyPairs)this.var_translation_keys.get(key);
                jTerm term = kpairs != null && kpairs.termkey != null ? this.translations.createTermFromObject(value, kpairs.termkey) : this.translations.createTermFromObject(value);
                bind_terms.put(key, term);
            }
        }
        this.joinForcedQueryCompletion();
        this.thread = new jAPIQueryThread(this.prolog, bind_terms, query);
        if (!this.prolog.start(this.thread)) {
            throw new NoThreadAvailableException("query failed, other events pending.");
        }
        return this.waitForCompletion();
    }

    public synchronized Hashtable queryOnce(String query, Hashtable bindings) {
        Hashtable result = this.query(query, bindings);
        this.stop();
        return result;
    }

    public synchronized Hashtable retry() {
        this.query_state = 0;
        if (this.thread == null || !this.thread.isAlive()) {
            return null;
        }
        this.thread.retry();
        return this.waitForCompletion();
    }

    public synchronized void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.broadcasted_stop();
        }
        this.query_state = 2;
    }

    protected synchronized Hashtable waitForCompletion() {
        while (this.query_state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        RuntimeException ex = this.thread.getResultException();
        if (ex != null) {
            throw ex;
        }
        Hashtable ht = null;
        if (this.query_state == 1) {
            ht = this.thread.getResultHashtable();
        }
        this.query_state = 0;
        if (ht != null) {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                jTerm value = (jTerm)ht.get(key);
                KeyPairs kpairs = (KeyPairs)this.var_translation_keys.get(key);
                Object obj = kpairs != null && kpairs.objkey != null ? this.translations.createObjectFromTerm(value, kpairs.objkey) : this.translations.createObjectFromTerm(value);
                ht.put(key, obj);
            }
        }
        return ht;
    }

    protected synchronized void setQueryResultState(boolean result) {
        if (this.query_state == 0) {
            this.query_state = result ? 1 : 2;
            this.notify();
        }
    }

    protected synchronized void joinForcedQueryCompletion() {
        if (this.thread != null && this.thread.isAlive()) {
            this.query_state = 2;
            this.thread.broadcasted_stop();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.query_state = 0;
    }

    protected class KeyPairs {
        public Object termkey;
        public Object objkey;

        public KeyPairs(Object tkey, Object okey) {
            this.termkey = tkey;
            this.objkey = okey;
        }
    }
}

