/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.Hashtable;
import ubc.cs.JLog.Foundation.jDebugProver;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Foundation.jRetryQueryThread;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jAPIQueryThread
extends jRetryQueryThread {
    protected String qinput;
    protected jPrologServiceBroadcaster beginq = null;
    protected jPrologServiceBroadcaster retryq = null;
    protected jPrologServiceBroadcaster endq = null;
    protected jPrologServiceBroadcaster debugm = null;
    protected jProver prover = null;
    protected jPredicateTerms query = null;
    protected boolean result = false;
    protected int retry = 0;
    protected jVariableVector var_vector = null;
    protected Hashtable var_prebindings;
    protected RuntimeException result_exception = null;

    public jAPIQueryThread(jPrologServices ps, String qin) {
        super(ps);
        this.var_prebindings = null;
        this.qinput = qin;
    }

    public jAPIQueryThread(jPrologServices ps, Hashtable bindings, String qin) {
        super(ps);
        this.setName("APIQueryThread");
        this.var_prebindings = bindings;
        this.qinput = qin;
    }

    public void setListeners(jPrologServiceBroadcaster b, jPrologServiceBroadcaster r, jPrologServiceBroadcaster e, jPrologServiceBroadcaster s, jPrologServiceBroadcaster d) {
        this.setStoppedListeners(s);
        this.beginq = b;
        this.retryq = r;
        this.endq = e;
        this.debugm = d;
    }

    public synchronized void retry() {
        ++this.retry;
        this.notify();
    }

    protected synchronized boolean waitForRetry() {
        while (this.retry <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        --this.retry;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.result_exception = null;
        if (this.beginq != null) {
            this.beginq.broadcastEvent(new jPrologServiceEvent());
        }
        try {
            this.query();
            if (this.retryq != null) {
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
            while (this.result) {
                if (!this.waitForRetry()) continue;
                this.internal_retry();
                if (this.retryq == null) continue;
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
        }
        catch (RuntimeException e) {
            this.result_exception = e;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            this.var_vector = null;
            if (this.endq != null) {
                this.endq.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    protected void query() {
        pParseStream parser = new pParseStream(this.qinput, this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        this.result = false;
        this.query = parser.parseQuery(this.var_prebindings);
        if (this.query != null) {
            this.var_vector = new jVariableVector();
            this.query.registerVariables(this.var_vector);
            this.internal_prove();
        }
    }

    protected void internal_prove() {
        this.prover = this.prolog.getDebugging() ? new jDebugProver(this.prolog.getKnowledgeBase(), this.debugm) : new jProver(this.prolog.getKnowledgeBase());
        this.result = this.prover.prove(this.query);
    }

    protected void internal_retry() {
        if (this.result) {
            this.result = this.prover.retry();
        }
    }

    public Hashtable getResultHashtable() {
        if (this.query == null) {
            return null;
        }
        if (this.result) {
            Hashtable<String, jTerm> ht = new Hashtable<String, jTerm>();
            jVariable[] vars = this.var_vector.getVariables();
            int max = vars.length;
            for (int i = 0; i < max; ++i) {
                if (!vars[i].isNamedForDisplay()) continue;
                ht.put(vars[i].getName(), vars[i].getTerm());
            }
            return ht;
        }
        return null;
    }

    public RuntimeException getResultException() {
        return this.result_exception;
    }
}

