/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import ubc.cs.JLog.Builtins.Goals.jNameGoal;
import ubc.cs.JLog.Builtins.InvalidNameArgumentException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jBinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jList;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jName
extends jBinaryBuiltinPredicate {
    protected boolean prefer_atom;

    public jName(jTerm l, jTerm r) {
        this(l, r, false);
    }

    public jName(jTerm l, jTerm r, boolean pa) {
        super(l, r, 4);
        this.prefer_atom = pa;
    }

    public String getName() {
        return "name";
    }

    public boolean prove(jNameGoal ng) {
        jTerm l = ng.lhs.getTerm();
        jTerm r = ng.rhs.getTerm();
        if (l instanceof iPredicate && ((iPredicate)l).getArity() == 0 || l.type == 1 || l.type == 2) {
            if (l.type == 2) {
                String string = String.valueOf(((jReal)l).getRealValue());
            }
            String s = l.type == 1 ? String.valueOf(((jInteger)l).getIntegerValue()) : l.getName();
            jList il = this.convertStringToList(s);
            return r.unify(il, ng.unified);
        }
        if (r instanceof jList) {
            String s = this.convertListToString((jList)r);
            jTerm t = this.convertStringToTerm(s, ng.prefer_atom);
            return l.unify(t, ng.unified);
        }
        throw new InvalidNameArgumentException();
    }

    protected jTerm convertStringToTerm(String s, boolean pa) {
        if (pa) {
            return new jAtom(s);
        }
        try {
            return new jInteger(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            try {
                return new jReal(Float.parseFloat(s));
            }
            catch (NumberFormatException e2) {
                return new jAtom(s);
            }
        }
    }

    protected String convertListToString(jList i) {
        StringBuffer sb = new StringBuffer();
        jTerm t = i;
        while (t.type == 12) {
            jListPair l = (jListPair)t;
            jTerm it = l.getHead().getTerm();
            if (it.type != 1) {
                throw new InvalidNameArgumentException();
            }
            sb.append((char)((jInteger)it).getIntegerValue());
            t = l.getTail().getTerm();
        }
        return sb.toString();
    }

    protected jList convertStringToList(String s) {
        int max = s.length();
        jList head = null;
        jListPair prev = null;
        for (int i = 0; i < max; ++i) {
            jListPair next = new jListPair(new jInteger(s.charAt(i)), null);
            if (prev == null) {
                head = next;
            } else {
                prev.setTail(next);
            }
            prev = next;
        }
        if (prev == null) {
            head = jNullList.NULL_LIST;
        } else {
            prev.setTail(jNullList.NULL_LIST);
        }
        return head;
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jNameGoal(this, this.lhs.duplicate(vars), this.rhs.duplicate(vars), this.prefer_atom));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jNameGoal(this, this.lhs, this.rhs, this.prefer_atom));
    }

    protected jBinaryBuiltinPredicate duplicate(jTerm lhs, jTerm rhs) {
        return new jName(lhs, rhs, this.prefer_atom);
    }
}

