/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import java.io.IOException;
import ubc.cs.JLog.Builtins.Goals.jUnaryOperatorGoal;
import ubc.cs.JLog.Builtins.InvalidLoadLibraryException;
import ubc.cs.JLog.Builtins.jUnaryOperator;
import ubc.cs.JLog.Foundation.LoadLibraryException;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jUnaryBuiltinPredicate;

public class jLoadLibrary
extends jUnaryOperator {
    public jLoadLibrary(jTerm r) {
        super(r);
    }

    public String getName() {
        return "load_library";
    }

    protected jUnaryBuiltinPredicate duplicate(jTerm r) {
        return new jLoadLibrary(r);
    }

    public boolean prove(jUnaryOperatorGoal og) {
        String lib_name = null;
        jTerm r = og.rhs.getTerm();
        if (!(r instanceof jAtom)) {
            throw new InvalidLoadLibraryException("Expected library name");
        }
        lib_name = ((jAtom)r).getName();
        jPrologServiceThread pst = (jPrologServiceThread)Thread.currentThread();
        if (pst.isCurrentlyConsulting()) {
            jPrologServices prolog = pst.getPrologServices();
            try {
                prolog.loadLibrary(lib_name);
            }
            catch (IOException e) {
                throw new LoadLibraryException("IO Error in loadLibrary");
            }
        } else {
            throw new InvalidLoadLibraryException("load_library operator only works during consult.");
        }
        return true;
    }
}

