/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins.Goals;

import ubc.cs.JLog.Builtins.InvalidOpArgumentException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPredicateOperatorEntry;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jTerm;

public class jOpGoal
extends jGoal {
    protected jTerm priority;
    protected jTerm specifier;
    protected jTerm operation;

    public jOpGoal(jTerm t1, jTerm t2, jTerm t3) {
        this.priority = t1;
        this.specifier = t2;
        this.operation = t3;
    }

    public boolean prove(iGoalStack goals, iGoalStack proved) {
        int pri = this.getPriority(this.priority.getValue());
        int stype = this.getSpecifier(this.specifier.getTerm());
        Thread t = Thread.currentThread();
        if (t instanceof jPrologServiceThread) {
            jPrologServiceThread pst = (jPrologServiceThread)t;
            jPrologServices prolog = pst.getPrologServices();
            pOperatorRegistry registry = prolog.getOperatorRegistry();
            this.registerOperations(registry, pri, stype);
            proved.push(this);
            return true;
        }
        goals.push(this);
        return false;
    }

    public boolean retry(iGoalStack goals, iGoalStack proved) {
        goals.push(this);
        return false;
    }

    protected int getPriority(jTerm t) {
        if (t.type == 1) {
            int value = ((jInteger)t).getIntegerValue();
            if (value < 0 || value > 1200) {
                throw new InvalidOpArgumentException("Priority number in 0..1200 range required.");
            }
            return value;
        }
        throw new InvalidOpArgumentException("Priority number required.");
    }

    protected int getSpecifier(jTerm t) {
        if (t.type == 0) {
            String value = t.getName();
            if (value.equalsIgnoreCase("FX")) {
                return 1;
            }
            if (value.equalsIgnoreCase("FY")) {
                return 2;
            }
            if (value.equalsIgnoreCase("XFX")) {
                return 17;
            }
            if (value.equalsIgnoreCase("XFY")) {
                return 18;
            }
            if (value.equalsIgnoreCase("YFX")) {
                return 33;
            }
            if (value.equalsIgnoreCase("XF")) {
                return 16;
            }
            if (value.equalsIgnoreCase("YF")) {
                return 32;
            }
            throw new InvalidOpArgumentException("'fx','fy','xfx','xfy','yfx','xf' or 'yf' specifier required.");
        }
        throw new InvalidOpArgumentException("Specifier atom required.");
    }

    protected void registerOperations(pOperatorRegistry registry, int pri, int stype) {
        jTerm t = this.operation.getTerm();
        do {
            if (t.type == 0) {
                this.registerOperation(t, registry, pri, stype);
                break;
            }
            if (t.type != 12) {
                throw new InvalidOpArgumentException("Operator name atom required.");
            }
            jListPair tl = (jListPair)t;
            this.registerOperation(tl.getHead(), registry, pri, stype);
            t = tl.getTail();
        } while (!(t instanceof jNullList));
    }

    protected void registerOperation(jTerm t, pOperatorRegistry registry, int pri, int stype) {
        if (t.type != 0) {
            throw new InvalidOpArgumentException("Operator name atom required.");
        }
        registry.addOperator(new pPredicateOperatorEntry(t.getName(), stype, pri));
    }

    public String getName() {
        return "op";
    }

    public int getArity() {
        return 3;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "/" + String.valueOf(this.getArity()) + " goal: ");
        sb.append(this.getName() + "(" + this.priority.toString() + "," + this.specifier.toString() + "," + this.operation.toString() + ")");
        return sb.toString();
    }
}

