/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextStringUtil {
    private static final boolean DEBUG = false;

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement) {
        return RichTextStringUtil.replaceAll(richTextString, helper, target, replacement, false);
    }

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement, boolean firstOnly) {
        return RichTextStringUtil.replaceAll(richTextString, helper, target, replacement, firstOnly, 0);
    }

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement, boolean firstOnly, int startIdx) {
        if (target == null || target.length() == 0) {
            return richTextString;
        }
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        ArrayList<Integer> beginList = new ArrayList<Integer>();
        ArrayList<Integer> lengthList = new ArrayList<Integer>();
        ArrayList<Object> fontList = new ArrayList<Object>();
        RichTextStringUtil.determineFormattingRunStats(richTextString, beginList, lengthList, fontList);
        ArrayList<Integer> newLengthList = new ArrayList<Integer>(lengthList);
        int change = replacement.length() - target.length();
        int beginIdx = value.indexOf(target, startIdx);
        while (beginIdx != -1) {
            int j;
            value = value.substring(0, beginIdx) + replacement + value.substring(beginIdx + target.length());
            int fmtIndex = -1;
            for (j = 0; j < numFormattingRuns; ++j) {
                int currBeginIdx = beginList.get(j);
                int currLength = newLengthList.get(j);
                if (beginIdx < currBeginIdx || beginIdx >= currBeginIdx + currLength) continue;
                fmtIndex = j;
                break;
            }
            if (fmtIndex != -1) {
                newLengthList.set(fmtIndex, newLengthList.get(fmtIndex) + change);
                for (j = fmtIndex + 1; j < numFormattingRuns; ++j) {
                    beginList.set(j, beginList.get(j) + change);
                }
            } else {
                for (j = 0; j < numFormattingRuns; ++j) {
                    beginList.set(j, beginList.get(j) + change);
                }
            }
            if (firstOnly) break;
            beginIdx = value.indexOf(target, beginIdx + replacement.length());
        }
        return RichTextStringUtil.createFormattedString(numFormattingRuns, helper, value, beginList, newLengthList, fontList);
    }

    public static RichTextString replaceValues(RichTextString richTextString, CreationHelper helper, List<String> targets, List<String> replacements) {
        int beginIdx;
        if (targets == null || targets.size() == 0) {
            return richTextString;
        }
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        ArrayList<Integer> beginList = new ArrayList<Integer>();
        ArrayList<Integer> lengthList = new ArrayList<Integer>();
        ArrayList<Object> fontList = new ArrayList<Object>();
        RichTextStringUtil.determineFormattingRunStats(richTextString, beginList, lengthList, fontList);
        ArrayList<Integer> newLengthList = new ArrayList<Integer>(lengthList);
        for (int i = 0; i < targets.size() && (beginIdx = value.indexOf(targets.get(i))) != -1; ++i) {
            String replaceMe = targets.get(i);
            String replaceWith = replacements.get(i);
            value = value.replace(replaceMe, replaceWith);
            int fmtIndex = -1;
            for (int j = 0; j < numFormattingRuns; ++j) {
                int currBeginIdx = beginList.get(j);
                int currLength = newLengthList.get(j);
                if (beginIdx < currBeginIdx || beginIdx >= currBeginIdx + currLength) continue;
                fmtIndex = j;
                break;
            }
            if (fmtIndex == -1) continue;
            int change = replaceWith.length() - replaceMe.length();
            newLengthList.set(fmtIndex, newLengthList.get(fmtIndex) + change);
            for (int j = fmtIndex + 1; j < numFormattingRuns; ++j) {
                beginList.set(j, beginList.get(j) + change);
            }
        }
        return RichTextStringUtil.createFormattedString(numFormattingRuns, helper, value, beginList, newLengthList, fontList);
    }

    public static RichTextString substring(RichTextString richTextString, CreationHelper helper, int beginIndex, int endIndex) {
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        ArrayList<Integer> beginList = new ArrayList<Integer>();
        ArrayList<Integer> lengthList = new ArrayList<Integer>();
        ArrayList<Object> fontList = new ArrayList<Object>();
        RichTextStringUtil.determineFormattingRunStats(richTextString, beginList, lengthList, fontList);
        ArrayList<Integer> substrBeginList = new ArrayList<Integer>();
        ArrayList<Integer> substrLengthList = new ArrayList<Integer>();
        ArrayList<Object> substrFontList = new ArrayList<Object>();
        for (int i = 0; i < numFormattingRuns; ++i) {
            int begin = beginList.get(i);
            int end = begin + lengthList.get(i);
            if (begin < beginIndex && end < beginIndex || begin >= endIndex && end >= endIndex) continue;
            if (begin < beginIndex && end >= beginIndex) {
                begin = beginIndex;
            }
            if (begin < endIndex && end >= endIndex) {
                end = endIndex;
            }
            substrBeginList.add(begin - beginIndex);
            substrLengthList.add(end - begin);
            substrFontList.add(fontList.get(i));
        }
        return RichTextStringUtil.createFormattedString(substrBeginList.size(), helper, value.substring(beginIndex, endIndex), substrBeginList, substrLengthList, substrFontList);
    }

    public static void determineFormattingRunStats(RichTextString richTextString, ArrayList<Integer> beginList, ArrayList<Integer> lengthList, ArrayList<Object> fontList) {
        block5: {
            int numFormattingRuns;
            block4: {
                numFormattingRuns = richTextString.numFormattingRuns();
                if (!(richTextString instanceof HSSFRichTextString)) break block4;
                HSSFRichTextString hssfRichTextString = (HSSFRichTextString)richTextString;
                for (int fmtIdx = 0; fmtIdx < numFormattingRuns; ++fmtIdx) {
                    short currFontIndex;
                    int begin = richTextString.getIndexOfFormattingRun(fmtIdx);
                    short fontIndex = (Short)RichTextStringUtil.getFontOfFormattingRun((RichTextString)hssfRichTextString, fmtIdx);
                    int length = 0;
                    for (int j = begin; j < richTextString.length() && (currFontIndex = ((Short)RichTextStringUtil.getFontAtIndex((RichTextString)hssfRichTextString, j)).shortValue()) == fontIndex; ++j) {
                        ++length;
                    }
                    beginList.add(begin);
                    lengthList.add(length);
                    fontList.add(fontIndex);
                }
                break block5;
            }
            if (!(richTextString instanceof XSSFRichTextString)) break block5;
            XSSFRichTextString xssfRichTextString = (XSSFRichTextString)richTextString;
            for (int fmtIdx = 0; fmtIdx < numFormattingRuns; ++fmtIdx) {
                XSSFFont currFontIndex;
                int begin = richTextString.getIndexOfFormattingRun(fmtIdx);
                XSSFFont fontIndex = (XSSFFont)RichTextStringUtil.getFontOfFormattingRun((RichTextString)xssfRichTextString, fmtIdx);
                int length = 0;
                for (int j = begin; j < richTextString.length() && ((currFontIndex = (XSSFFont)RichTextStringUtil.getFontAtIndex((RichTextString)xssfRichTextString, j)) == null && fontIndex == null || currFontIndex != null && currFontIndex.equals((Object)fontIndex)); ++j) {
                    ++length;
                }
                beginList.add(begin);
                lengthList.add(length);
                fontList.add(fontIndex);
            }
        }
    }

    public static RichTextString createFormattedString(int numFormattingRuns, CreationHelper helper, String value, ArrayList<Integer> beginList, ArrayList<Integer> newLengthList, ArrayList<Object> fontList) {
        RichTextString newString = helper.createRichTextString(value);
        RichTextStringUtil.formatString(newString, numFormattingRuns, beginList, newLengthList, fontList);
        return newString;
    }

    public static void formatString(RichTextString string, int numFormattingRuns, ArrayList<Integer> beginList, ArrayList<Integer> newLengthList, ArrayList<Object> fontList) {
        for (int i = 0; i < numFormattingRuns; ++i) {
            int begin = beginList.get(i);
            int end = begin + newLengthList.get(i);
            Object font = fontList.get(i);
            if (string instanceof HSSFRichTextString) {
                string.applyFont(begin, end, ((Short)font).shortValue());
                continue;
            }
            if (string instanceof XSSFRichTextString) {
                if (font == null) continue;
                string.applyFont(begin, end, (Font)((XSSFFont)font));
                continue;
            }
            throw new IllegalArgumentException("Unexpected RichTextString type: " + string.getClass().getName() + ": " + string.getString());
        }
    }

    private static Object getFontOfFormattingRun(RichTextString richTextString, int fmtIndex) {
        if (richTextString instanceof HSSFRichTextString) {
            return ((HSSFRichTextString)richTextString).getFontOfFormattingRun(fmtIndex);
        }
        if (richTextString instanceof XSSFRichTextString) {
            try {
                return ((XSSFRichTextString)richTextString).getFontOfFormattingRun(fmtIndex);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
    }

    public static Object getFontAtIndex(RichTextString richTextString, int fmtIndex) {
        if (richTextString instanceof HSSFRichTextString) {
            return ((HSSFRichTextString)richTextString).getFontAtIndex(fmtIndex);
        }
        if (richTextString instanceof XSSFRichTextString) {
            try {
                return ((XSSFRichTextString)richTextString).getFontAtIndex(fmtIndex);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
    }

    public static void applyFont(RichTextString richTextString, Cell cell) {
        XSSFFont font;
        if (richTextString == null) {
            return;
        }
        if (richTextString instanceof HSSFRichTextString) {
            short fontIdx = ((HSSFRichTextString)richTextString).getFontAtIndex(0);
            font = cell.getSheet().getWorkbook().getFontAt(fontIdx);
        } else if (richTextString instanceof XSSFRichTextString) {
            try {
                font = ((XSSFRichTextString)richTextString).getFontAtIndex(0);
            }
            catch (NullPointerException e) {
                font = null;
            }
        } else {
            throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
        }
        if (font != null) {
            CellStyle cellStyle = cell.getCellStyle();
            Workbook workbook = cell.getSheet().getWorkbook();
            CellStyle newCellStyle = RichTextStringUtil.findCellStyle(workbook, cellStyle, (Font)font);
            if (newCellStyle == null) {
                newCellStyle = workbook.createCellStyle();
                newCellStyle.cloneStyleFrom(cellStyle);
                Font foundFont = RichTextStringUtil.findFont(workbook, (Font)font);
                newCellStyle.setFont(foundFont);
            }
            cell.setCellStyle(newCellStyle);
        }
    }

    private static CellStyle findCellStyle(Workbook workbook, CellStyle cellStyle, Font font) {
        short numCellStyles = workbook.getNumCellStyles();
        for (short i = 0; i < numCellStyles; i = (short)(i + 1)) {
            CellStyle cs = workbook.getCellStyleAt(i);
            Font f = workbook.getFontAt(cs.getFontIndex());
            if (cs.getFillForegroundColor() != cellStyle.getFillForegroundColor() || cs.getFillBackgroundColor() != cellStyle.getFillBackgroundColor() || cs.getDataFormat() != cellStyle.getDataFormat() || cs.getAlignment() != cellStyle.getAlignment() || cs.getBorderBottom() != cellStyle.getBorderBottom() || cs.getBorderLeft() != cellStyle.getBorderLeft() || cs.getBorderRight() != cellStyle.getBorderRight() || cs.getBorderTop() != cellStyle.getBorderTop() || cs.getFillPattern() != cellStyle.getFillPattern() || cs.getWrapText() != cellStyle.getWrapText() || cs.getRotation() != cellStyle.getRotation() || cs.getBottomBorderColor() != cellStyle.getBottomBorderColor() || cs.getTopBorderColor() != cellStyle.getTopBorderColor() || cs.getLeftBorderColor() != cellStyle.getLeftBorderColor() || cs.getRightBorderColor() != cellStyle.getRightBorderColor() || cs.getVerticalAlignment() != cellStyle.getVerticalAlignment() || cs.getIndention() != cellStyle.getIndention() || cs.getLocked() != cellStyle.getLocked() || cs.getHidden() != cellStyle.getHidden() || f.getBoldweight() != font.getBoldweight() || f.getItalic() != font.getItalic() || f.getColor() != font.getColor() || f.getFontHeight() != font.getFontHeight() || f.getUnderline() != font.getUnderline() || !f.getFontName().equals(font.getFontName()) || f.getTypeOffset() != font.getTypeOffset() || font instanceof XSSFFont && f instanceof XSSFFont && !((XSSFFont)font).getXSSFColor().getARGBHex().equals(((XSSFFont)f).getXSSFColor().getARGBHex())) continue;
            return cs;
        }
        return null;
    }

    private static Font findFont(Workbook workbook, Font font) {
        short numFonts = workbook.getNumberOfFonts();
        for (short i = 0; i < numFonts; i = (short)(i + 1)) {
            Font f = workbook.getFontAt(i);
            if (f.getBoldweight() != font.getBoldweight() || f.getItalic() != font.getItalic() || f.getColor() != font.getColor() || f.getFontHeight() != font.getFontHeight() || f.getUnderline() != font.getUnderline() || !f.getFontName().equals(font.getFontName()) || f.getTypeOffset() != font.getTypeOffset() || font instanceof XSSFFont && f instanceof XSSFFont && !((XSSFFont)font).getXSSFColor().getARGBHex().equals(((XSSFFont)f).getXSSFColor().getARGBHex())) continue;
            return f;
        }
        return null;
    }
}

