/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jagg.MethodCache;
import net.sf.jett.exception.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByComparator<T>
implements Comparator<T> {
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS = "NULLS";
    public static final String FIRST = "FIRST";
    public static final String LAST = "LAST";
    public static final int ORDER_ASC = 1;
    public static final int ORDER_DESC = -1;
    public static final int NULLS_LAST = 1;
    public static final int NULLS_FIRST = -1;
    private List<String> myProperties;
    private List<Integer> myOrderings;
    private List<Integer> myNullOrderings;
    private int mySize;

    public OrderByComparator(List<String> expressions) {
        this.setExpressions(expressions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setExpressions(List<String> expressions) {
        if (expressions == null || expressions.size() <= 0) {
            throw new ParseException("No order by expressions found.");
        }
        this.mySize = expressions.size();
        this.myProperties = new ArrayList<String>(this.mySize);
        this.myOrderings = new ArrayList<Integer>(this.mySize);
        this.myNullOrderings = new ArrayList<Integer>(this.mySize);
        for (String expr : expressions) {
            String[] parts = expr.split("\\s+");
            if (parts.length <= 0 || parts.length >= 5) throw new ParseException("Expected \"property\" [ASC|DESC] [NULLS ]FIRST|LAST: " + expr);
            String property = parts[0];
            int ordering = 1;
            int nullOrdering = 1;
            if (parts.length == 2 || parts.length == 4) {
                if (ASC.equalsIgnoreCase(parts[1])) {
                    ordering = 1;
                    nullOrdering = 1;
                } else {
                    if (!DESC.equalsIgnoreCase(parts[1])) throw new ParseException("Expected \"ASC\" or \"DESC: " + expr);
                    ordering = -1;
                    nullOrdering = -1;
                }
            }
            if (parts.length == 3 || parts.length == 4) {
                if (!NULLS.equalsIgnoreCase(parts[parts.length - 2])) {
                    throw new ParseException("Expected \"NULLS FIRST|LAST: " + expr);
                }
                if (LAST.equalsIgnoreCase(parts[parts.length - 1])) {
                    nullOrdering = 1;
                } else {
                    if (!FIRST.equalsIgnoreCase(parts[parts.length - 1])) throw new ParseException("Expected \"FIRST\" or \"LAST: " + expr);
                    nullOrdering = -1;
                }
            }
            this.myProperties.add(property);
            this.myOrderings.add(ordering);
            this.myNullOrderings.add(nullOrdering);
        }
    }

    @Override
    public int compare(T o1, T o2) throws UnsupportedOperationException {
        for (int i = 0; i < this.mySize; ++i) {
            Comparable value2;
            Comparable value1;
            String property = this.myProperties.get(i);
            int ordering = this.myOrderings.get(i);
            int nullOrdering = this.myNullOrderings.get(i);
            MethodCache cache = MethodCache.getMethodCache();
            try {
                value1 = (Comparable)cache.getValueFromProperty(o1, property);
                value2 = (Comparable)cache.getValueFromProperty(o2, property);
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("No matching method found for \"" + property + "\".", e);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("Illegal method access detected for property \"" + property + "\".", e);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("Exception detected getting property \"" + property + "\".", e);
            }
            try {
                int comp = value1 == null ? (value2 == null ? 0 : nullOrdering) : (value2 == null ? -nullOrdering : ordering * value1.compareTo(value2));
                if (comp == 0) continue;
                return comp;
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" needs to be Comparable.");
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderByComparator) {
            OrderByComparator otherComp = (OrderByComparator)obj;
            if (this.mySize != otherComp.mySize) {
                return false;
            }
            for (int i = 0; i < this.mySize; ++i) {
                if (!this.myProperties.get(i).equals(otherComp.myProperties.get(i))) {
                    return false;
                }
                if (this.myOrderings.get(i) != otherComp.myOrderings.get(i)) {
                    return false;
                }
                if (this.myNullOrderings.get(i) == otherComp.myNullOrderings.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<String> getProperties() {
        return this.myProperties;
    }

    public List<Integer> getOrderings() {
        return this.myOrderings;
    }

    public List<Integer> getNullOrderings() {
        return this.myNullOrderings;
    }
}

