/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.Comparator;
import java.util.List;
import net.sf.jett.exception.ParseException;
import net.sf.jett.model.Group;
import net.sf.jett.util.OrderByComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupOrderByComparator<T extends Group>
implements Comparator<T> {
    private OrderByComparator<Object> myOrderByComparator;
    private List<String> myGroupByProperties;

    public GroupOrderByComparator(OrderByComparator<Object> orderByComparator, List<String> groupByProperties) {
        this.myOrderByComparator = orderByComparator;
        this.myGroupByProperties = groupByProperties;
        this.ensureOrderByGroupByLegal();
    }

    private void ensureOrderByGroupByLegal() {
        boolean foundOrderByNotInGroupBy = false;
        List<String> orderByProperties = this.myOrderByComparator.getProperties();
        for (String orderBy : orderByProperties) {
            boolean orderByInGroupBy = this.myGroupByProperties.contains(orderBy);
            if (foundOrderByNotInGroupBy) {
                if (orderByInGroupBy) continue;
                throw new ParseException("The \"order by\" property \"" + orderBy + "\" is in the \"group by\" properties (" + this.myGroupByProperties.toString() + "), but it must not follow other \"order by\" properties (" + orderByProperties.toString() + ") that aren't \"group by\" properties.");
            }
            if (orderByInGroupBy) continue;
            foundOrderByNotInGroupBy = true;
        }
    }

    @Override
    public int compare(T g1, T g2) {
        return this.myOrderByComparator.compare(((Group)g1).getObj(), ((Group)g2).getObj());
    }

    public List<String> getGroupByProperties() {
        return this.myGroupByProperties;
    }
}

