/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jett.formula.CellRef;
import net.sf.jett.formula.CellRefRange;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.WorkbookContext;
import org.apache.poi.ss.formula.SheetNameFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaUtil {
    private static final boolean DEBUG = false;

    public static Map<String, List<CellRef>> createCellRefMap(Map<String, Formula> formulaMap) {
        HashMap<String, List<CellRef>> cellRefMap = new HashMap<String, List<CellRef>>();
        for (String key : formulaMap.keySet()) {
            Formula formula = formulaMap.get(key);
            String keySheetName = key.substring(0, key.indexOf("!"));
            for (CellRef cellRef : formula.getCellRefs()) {
                String sheetName = cellRef.getSheetName();
                String cellKey = sheetName == null || "".equals(sheetName) ? keySheetName + "!" + cellRef.formatAsString() : cellRef.formatAsString().replace("'", "");
                if (cellRefMap.containsKey(cellKey)) continue;
                ArrayList<CellRef> cellRefs = new ArrayList<CellRef>();
                CellRef mappedCellRef = new CellRef(cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                cellRefs.add(mappedCellRef);
                cellRefMap.put(cellKey, cellRefs);
            }
        }
        return cellRefMap;
    }

    public static String createExcelFormulaString(String formulaText, Formula formula, String sheetName, WorkbookContext context) {
        String suffix;
        String excelFormula;
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        List<CellRef> origCellRefs = formula.getCellRefs();
        StringBuffer buf = new StringBuffer();
        int idx = formulaText.indexOf("[", "$[".length());
        if (idx > -1) {
            excelFormula = formulaText.substring(0, idx);
            suffix = formulaText.substring(idx);
        } else {
            excelFormula = formulaText;
            suffix = "";
        }
        if (excelFormula.startsWith("$[") && excelFormula.endsWith("]")) {
            excelFormula = excelFormula.substring("$[".length(), excelFormula.length() - "]".length());
        }
        for (CellRef origCellRef : origCellRefs) {
            String cellRefs;
            String origCellRefSheetName = origCellRef.getSheetName();
            String cellKey = origCellRefSheetName != null ? origCellRef.formatAsString().replace("'", "") : sheetName + "!" + origCellRef.formatAsString();
            cellKey = cellKey + suffix;
            List<CellRef> transCellRefs = cellRefMap.get(cellKey);
            buf.delete(0, buf.length());
            int numCellRefs = transCellRefs.size();
            if (numCellRefs > 0) {
                for (int i = 0; i < numCellRefs; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    String cellRef = transCellRefs.get(i).formatAsString();
                    if (origCellRefSheetName != null) {
                        SheetNameFormatter.appendFormat((StringBuffer)buf, (String)origCellRefSheetName);
                        buf.append("!");
                    }
                    buf.append(cellRef);
                }
                cellRefs = buf.toString();
            } else {
                cellRefs = origCellRef.getDefaultValue();
                if (cellRefs == null) {
                    cellRefs = "0";
                }
            }
            excelFormula = excelFormula.replace(origCellRef.formatAsStringWithDef(), cellRefs);
        }
        return excelFormula;
    }

    public static void findAndReplaceCellRanges(Map<String, List<CellRef>> cellRefMap) {
        for (String key : cellRefMap.keySet()) {
            List<CellRef> cellRefs = cellRefMap.get(key);
            Collections.sort(cellRefs);
            boolean vertical = false;
            boolean horizontal = false;
            CellRef first = null;
            CellRef prev = null;
            int firstIdx = -1;
            int size = cellRefs.size();
            for (int i = 0; i < size; ++i) {
                int shrink;
                CellRef curr = cellRefs.get(i);
                if (first == null) {
                    vertical = false;
                    horizontal = false;
                    first = curr;
                    firstIdx = i;
                } else if (vertical) {
                    if (!FormulaUtil.isBelow(prev, curr)) {
                        FormulaUtil.replaceRange(cellRefs, firstIdx, i - 1);
                        shrink = size - cellRefs.size();
                        size -= shrink;
                        vertical = false;
                        first = curr;
                        firstIdx = i -= shrink;
                    }
                } else if (horizontal) {
                    if (!FormulaUtil.isRightOf(prev, curr)) {
                        FormulaUtil.replaceRange(cellRefs, firstIdx, i - 1);
                        shrink = size - cellRefs.size();
                        size -= shrink;
                        horizontal = false;
                        first = curr;
                        firstIdx = i -= shrink;
                    }
                } else if (FormulaUtil.isRightOf(prev, curr)) {
                    horizontal = true;
                } else if (FormulaUtil.isBelow(prev, curr)) {
                    vertical = true;
                } else {
                    first = curr;
                    firstIdx = i;
                }
                prev = curr;
            }
            if (!horizontal && !vertical) continue;
            FormulaUtil.replaceRange(cellRefs, firstIdx, size - 1);
        }
    }

    private static boolean isRightOf(CellRef prev, CellRef curr) {
        return curr.getRow() == prev.getRow() && curr.getCol() == prev.getCol() + 1 && (curr.getSheetName() == null && prev.getSheetName() == null || curr.getSheetName() != null && curr.getSheetName().equals(prev.getSheetName()));
    }

    private static boolean isBelow(CellRef prev, CellRef curr) {
        return curr.getCol() == prev.getCol() && curr.getRow() == prev.getRow() + 1 && (curr.getSheetName() == null && prev.getSheetName() == null || curr.getSheetName() != null && curr.getSheetName().equals(prev.getSheetName()));
    }

    private static void replaceRange(List<CellRef> cellRefs, int startIdx, int endIdx) {
        CellRef first = cellRefs.get(startIdx);
        CellRef prev = cellRefs.get(endIdx);
        CellRefRange range = new CellRefRange(first.getSheetName(), first.getRow(), first.getCol(), first.isRowAbsolute(), first.isColAbsolute());
        range.setRangeEndCellRef(prev);
        cellRefs.set(startIdx, range);
        cellRefs.subList(startIdx + 1, endIdx + 1).clear();
    }

    public static void shiftCellReferencesInRange(String sheetName, Map<String, List<CellRef>> cellRefMap, int left, int right, int top, int bottom, int numCols, int numRows, boolean remove, boolean add) {
        if (numCols == 0 && numRows == 0 && remove && add) {
            return;
        }
        for (String cellKey : cellRefMap.keySet()) {
            String keySheetName = cellKey.substring(0, cellKey.indexOf("!"));
            if (!keySheetName.equals(sheetName)) continue;
            List<CellRef> cellRefs = cellRefMap.get(cellKey);
            ArrayList<CellRef> delete = new ArrayList<CellRef>();
            ArrayList<CellRef> insert = new ArrayList<CellRef>();
            for (CellRef cellRef : cellRefs) {
                String cellRefSheetName = cellRef.getSheetName();
                int row = cellRef.getRow();
                short col = cellRef.getCol();
                if (cellRefSheetName != null && !keySheetName.equals(cellRefSheetName) || row < top || row > bottom || col < left || col > right) continue;
                if (remove) {
                    delete.add(cellRef);
                }
                if (!add) continue;
                CellRef adjCellRef = new CellRef(cellRefSheetName, row + numRows, col + numCols, cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                insert.add(adjCellRef);
            }
            if (remove) {
                cellRefs.removeAll(delete);
            }
            if (!add) continue;
            cellRefs.addAll(insert);
        }
    }

    public static void copyCellReferencesInRange(String sheetName, Map<String, List<CellRef>> cellRefMap, int left, int right, int top, int bottom, int numCols, int numRows, String currSuffix, String newSuffix) {
        HashMap newCellRefEntries = new HashMap();
        for (String cellKey : cellRefMap.keySet()) {
            String keySheetName = cellKey.substring(0, cellKey.indexOf("!"));
            String keySuffix = "";
            int idx = cellKey.indexOf("[");
            if (idx > -1) {
                keySuffix = cellKey.substring(idx);
            }
            if (!keySheetName.equals(sheetName) || !currSuffix.startsWith(keySuffix)) continue;
            List<CellRef> cellRefs = cellRefMap.get(cellKey);
            ArrayList<CellRef> insert = new ArrayList<CellRef>();
            for (CellRef cellRef : cellRefs) {
                String cellRefSheetName = cellRef.getSheetName();
                int row = cellRef.getRow();
                short col = cellRef.getCol();
                if (cellRefSheetName != null && !keySheetName.equals(cellRefSheetName) || row < top || row > bottom || col < left || col > right) continue;
                CellRef adjCellRef = new CellRef(cellRefSheetName, row + numRows, col + numCols, cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                if (numRows != 0 || numCols != 0) {
                    insert.add(adjCellRef);
                }
                if (idx != -1) continue;
                String newCellKey = cellKey + currSuffix + newSuffix;
                ArrayList<CellRef> newCellRefs = new ArrayList<CellRef>();
                newCellRefs.add(adjCellRef);
                newCellRefEntries.put(newCellKey, newCellRefs);
            }
            cellRefs.addAll(insert);
        }
        cellRefMap.putAll(newCellRefEntries);
    }
}

