/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.expression.Expression;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtil {
    public static final String SPEC_SEP = ";";
    public static final String SPEC_SEP_2 = ",";

    public static boolean evaluateBoolean(RichTextString text, Map<String, Object> beans, boolean def) {
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        boolean result = obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean(obj.toString());
        return result;
    }

    public static int evaluateInt(RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        if (obj instanceof Number) {
            result = ((Number)obj).intValue();
        } else {
            try {
                result = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new TagParseException("The \"" + attrName + "\" attribute must be an integer: " + text);
            }
        }
        return result;
    }

    public static int evaluateNonNegativeInt(RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(text, beans, attrName, def);
        if (result < 0) {
            throw new TagParseException("The \"" + attrName + "\" attribute must be non-negative: " + result);
        }
        return result;
    }

    public static int evaluatePositiveInt(RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(text, beans, attrName, def);
        if (result <= 0) {
            throw new TagParseException("The \"" + attrName + "\" attribute must be positive: " + result);
        }
        return result;
    }

    public static int evaluateNonZeroInt(RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(text, beans, attrName, def);
        if (result == 0) {
            throw new TagParseException("The \"" + attrName + "\" attribute must not be zero: " + result);
        }
        return result;
    }

    public static double evaluateDouble(RichTextString text, Map<String, Object> beans, String attrName, double def) {
        double result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        if (obj instanceof Number) {
            result = ((Number)obj).doubleValue();
        } else {
            try {
                result = Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new TagParseException("The \"" + attrName + "\" attribute must be a number: " + text);
            }
        }
        return result;
    }

    public static String evaluateString(RichTextString text, Map<String, Object> beans, String def) {
        if (text == null) {
            return def;
        }
        return Expression.evaluateString(text.toString(), beans).toString();
    }

    public static String evaluateStringNotNull(RichTextString text, Map<String, Object> beans, String attrName, String def) {
        String result = AttributeUtil.evaluateString(text, beans, def);
        if (result == null || result.length() == 0) {
            throw new TagParseException("Value for \"" + attrName + "\" must not be null or empty: " + text.toString());
        }
        return result;
    }

    public static String evaluateStringSpecificValues(RichTextString text, Map<String, Object> beans, String attrName, List<String> legalValues, String def) {
        String result = AttributeUtil.evaluateString(text, beans, def);
        for (String legalValue : legalValues) {
            if (!legalValue.equalsIgnoreCase(result)) continue;
            return result;
        }
        throw new TagParseException("Unknown value for \"" + attrName + "\": " + result + " (expected one of " + legalValues.toString() + ").");
    }

    public static Object evaluateRichTextString(RichTextString text, Map<String, Object> beans, CreationHelper helper, Object def) {
        if (text == null) {
            return def;
        }
        return Expression.evaluateString(text, helper, beans);
    }

    public static <T> T evaluateObject(RichTextString text, Map<String, Object> beans, String attrName, Class<T> expectedClass, T def) {
        if (text == null) {
            return def;
        }
        return AttributeUtil.evaluateObject(text.toString(), beans, attrName, expectedClass, def);
    }

    public static <T> T evaluateObject(String text, Map<String, Object> beans, String attrName, Class<T> expectedClass, T def) {
        Object result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text, beans);
        Class<?> objClass = obj.getClass();
        if (expectedClass.isAssignableFrom(objClass)) {
            result = expectedClass.cast(obj);
        } else if (obj instanceof String) {
            String className = (String)obj;
            try {
                Class<?> actualClass = Class.forName(className);
                result = actualClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new TagParseException("Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not find class \"" + className + "\": " + text, e);
            }
            catch (InstantiationException e) {
                throw new TagParseException("Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": " + text, e);
            }
            catch (IllegalAccessException e) {
                throw new TagParseException("Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": " + text, e);
            }
            catch (ClassCastException e) {
                throw new TagParseException("Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": " + text, e);
            }
        } else {
            throw new TagParseException("Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", got a \"" + obj.getClass().getName() + "\": " + text);
        }
        return result;
    }

    public static List<String> evaluateList(RichTextString text, Map<String, Object> beans, List<String> def) {
        List<String> result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        if (obj instanceof List) {
            List list = (List)obj;
            result = new ArrayList<String>(list.size());
            for (Object item : list) {
                result.add(item.toString());
            }
        } else {
            String[] items = obj.toString().split(SPEC_SEP);
            result = Arrays.asList(items);
        }
        return result;
    }

    public static List<Integer> evaluateIntegerArray(RichTextString text, Map<String, Object> beans, List<Integer> def) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        if (obj instanceof int[]) {
            int[] intArray;
            for (int i : intArray = (int[])obj) {
                result.add(i);
            }
        } else if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            for (Object o : c) {
                if (o instanceof Number) {
                    result.add(((Number)o).intValue());
                    continue;
                }
                try {
                    result.add(Integer.parseInt(o.toString()));
                }
                catch (NumberFormatException e) {
                    throw new TagParseException("Expected an integer, got " + o.toString(), e);
                }
            }
        } else {
            String[] items;
            for (String item : items = obj.toString().split(SPEC_SEP)) {
                try {
                    result.add(Integer.parseInt(item));
                }
                catch (NumberFormatException e) {
                    throw new TagParseException("Expected an integer, got " + item, e);
                }
            }
        }
        return result;
    }

    public static List<List<Integer>> evaluateIntegerArrayArray(RichTextString text, Map<String, Object> beans, List<List<Integer>> def) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), beans);
        if (obj instanceof int[][]) {
            int[][] intArray;
            for (int[] array : intArray = (int[][])obj) {
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                for (int i : array) {
                    innerList.add(i);
                }
                result.add(innerList);
            }
        } else if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            for (Object o : c) {
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                if (o instanceof Collection) {
                    Collection inner = (Collection)o;
                    for (Object innerObj : inner) {
                        if (innerObj instanceof Number) {
                            innerList.add(((Number)innerObj).intValue());
                            continue;
                        }
                        try {
                            innerList.add(Integer.parseInt(innerObj.toString()));
                        }
                        catch (NumberFormatException e) {
                            throw new TagParseException("Expected an integer, got " + o.toString(), e);
                        }
                    }
                }
                result.add(innerList);
            }
        } else {
            String[] items;
            for (String item : items = obj.toString().split(SPEC_SEP)) {
                String[] innerItems;
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                for (String innerItem : innerItems = item.split(SPEC_SEP_2)) {
                    try {
                        innerList.add(Integer.parseInt(innerItem));
                    }
                    catch (NumberFormatException e) {
                        throw new TagParseException("Expected an integer, got " + item, e);
                    }
                }
                result.add(innerList);
            }
        }
        return result;
    }

    public static void ensureExactlyOneExists(List<RichTextString> attrValues, List<String> attrNames) {
        int exists = 0;
        for (RichTextString text : attrValues) {
            if (text == null || ++exists <= 1) continue;
            throw new TagParseException("Exactly one attribute must be specified: " + attrNames.toString());
        }
        if (exists != 1) {
            throw new TagParseException("Exactly one attribute must be specified: " + attrNames.toString());
        }
    }

    public static void ensureAtMostOneExists(List<RichTextString> attrValues, List<String> attrNames) {
        int exists = 0;
        for (RichTextString text : attrValues) {
            if (text == null || ++exists <= 1) continue;
            throw new TagParseException("At most one attribute must be specified: " + attrNames.toString());
        }
        if (exists != 1 && exists != 0) {
            throw new TagParseException("At most one attribute must be specified: " + attrNames.toString());
        }
    }

    public static void ensureAtLeastOneExists(List<RichTextString> attrValues, List<String> attrNames) {
        for (RichTextString text : attrValues) {
            if (text == null) continue;
            return;
        }
        throw new TagParseException("At least one attribute must be specified: " + attrNames.toString());
    }
}

