/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.FormulaParser;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.FormulaUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetTransformer {
    private static final boolean DEBUG = false;

    public void transform(Sheet sheet, WorkbookContext context, Map<String, Object> beans) {
        this.exposeSheet(beans, sheet);
        Block block = new Block(null, 0, SheetUtil.getLastPopulatedColIndex(sheet), 0, sheet.getLastRowNum());
        block.setDirection(Block.Direction.NONE);
        TagContext tagContext = new TagContext();
        tagContext.setSheet(sheet);
        tagContext.setBlock(block);
        tagContext.setBeans(beans);
        tagContext.setProcessedCellsMap(new HashMap<String, Cell>());
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(tagContext, context);
    }

    public void gatherFormulas(Sheet sheet, Map<String, Formula> formulaMap) {
        int top = sheet.getFirstRowNum();
        int bottom = sheet.getLastRowNum();
        String sheetName = sheet.getSheetName();
        FormulaParser parser = new FormulaParser();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int left = row.getFirstCellNum();
            int right = row.getLastCellNum() - 1;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                int endIdx;
                int startIdx;
                String cellText;
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1 || (cellText = cell.getStringCellValue()) == null || (startIdx = cellText.indexOf("$[")) == -1 || (endIdx = cellText.indexOf("]", startIdx)) == -1) continue;
                cellText = cellText.substring(startIdx, endIdx + "]".length());
                String formulaText = cellText.substring("$[".length(), endIdx - startIdx);
                parser.setFormulaText(formulaText);
                parser.parse();
                Formula formula = new Formula(cellText, parser.getCellReferences());
                String key = sheetName + "!" + cellText;
                formulaMap.put(key, formula);
            }
        }
    }

    public void replaceFormulas(Sheet sheet, WorkbookContext context) {
        int top = sheet.getFirstRowNum();
        int bottom = sheet.getLastRowNum();
        String sheetName = sheet.getSheetName();
        Map<String, Formula> formulaMap = context.getFormulaMap();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int left = row.getFirstCellNum();
            int right = row.getLastCellNum() - 1;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                String cellText;
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1 || (cellText = cell.getStringCellValue()) == null || !cellText.startsWith("$[") || !cellText.endsWith("]")) continue;
                int idx = cellText.indexOf("]");
                String cellTextNoSfx = cellText.substring(0, idx + 1);
                String key = sheetName + "!" + cellTextNoSfx;
                Formula formula = formulaMap.get(key);
                if (formula == null) continue;
                String excelFormula = FormulaUtil.createExcelFormulaString(cellText, formula, sheetName, context);
                cell.setCellFormula(excelFormula);
            }
        }
    }

    private void exposeSheet(Map<String, Object> beans, Sheet sheet) {
        beans.put("sheet", sheet);
    }
}

