/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jett.event.CellListener;
import net.sf.jett.expression.Expression;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.formula.CellRef;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.CellStyleCache;
import net.sf.jett.model.FontCache;
import net.sf.jett.model.Style;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.StyleParser;
import net.sf.jett.tag.JtTagLibrary;
import net.sf.jett.tag.TagLibrary;
import net.sf.jett.tag.TagLibraryRegistry;
import net.sf.jett.transform.SheetTransformer;
import net.sf.jett.util.FormulaUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelTransformer {
    private static final boolean DEBUG = false;
    private TagLibraryRegistry myRegistry = new TagLibraryRegistry();
    private List<CellListener> myCellListeners;
    private List<String> myFixedSizeCollectionNames;
    private List<String> myNoImplicitProcessingCollectionNames;
    private Map<String, Style> myStyleMap;

    public ExcelTransformer() {
        this.registerTagLibrary("jt", JtTagLibrary.getJtTagLibrary());
        this.myCellListeners = new ArrayList<CellListener>();
        this.myFixedSizeCollectionNames = new ArrayList<String>();
        this.myNoImplicitProcessingCollectionNames = new ArrayList<String>();
        this.myStyleMap = new HashMap<String, Style>();
    }

    public void registerTagLibrary(String namespace, TagLibrary library) {
        this.myRegistry.registerTagLibrary(namespace, library);
    }

    public void addCellListener(CellListener listener) {
        if (listener != null) {
            this.myCellListeners.add(listener);
        }
    }

    public void addFixedSizeCollectionName(String collName) {
        if (collName != null) {
            this.myFixedSizeCollectionNames.add(collName);
        }
    }

    public void turnOffImplicitCollectionProcessing(String collName) {
        if (collName != null) {
            this.myNoImplicitProcessingCollectionNames.add(collName);
        }
    }

    public void setLenient(boolean lenient) {
        ExpressionFactory factory = ExpressionFactory.getExpressionFactory();
        factory.setLenient(lenient);
    }

    public void setSilent(boolean silent) {
        ExpressionFactory factory = ExpressionFactory.getExpressionFactory();
        factory.setSilent(silent);
    }

    public void setCache(int size) {
        ExpressionFactory factory = ExpressionFactory.getExpressionFactory();
        factory.setCache(size);
    }

    public void registerFuncs(String namespace, Object funcsObject) {
        ExpressionFactory factory = ExpressionFactory.getExpressionFactory();
        factory.registerFuncs(namespace, funcsObject);
    }

    public void addCssText(String cssText) {
        StyleParser parser = new StyleParser(cssText);
        parser.parse();
        this.myStyleMap.putAll(parser.getStyleMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCssFile(String filename) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
            this.addCssText(buf.toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inFilename, String outFilename, Map<String, Object> beans) throws IOException, InvalidFormatException {
        FileOutputStream fileOut = null;
        InputStream fileIn = null;
        try {
            fileOut = new FileOutputStream(outFilename);
            fileIn = new BufferedInputStream(new FileInputStream(inFilename));
            Workbook workbook = this.transform(fileIn, beans);
            workbook.write((OutputStream)fileOut);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ignored) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public Workbook transform(InputStream is, Map<String, Object> beans) throws IOException, InvalidFormatException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        Expression.clearExpressionToCollNamesMap();
        SheetTransformer sheetTransformer = new SheetTransformer();
        WorkbookContext context = this.createContext(workbook, sheetTransformer);
        this.exposeWorkbook(beans, workbook);
        for (int s = 0; s < workbook.getNumberOfSheets(); ++s) {
            Sheet sheet = workbook.getSheetAt(s);
            sheetTransformer.transform(sheet, context, beans);
        }
        if (!context.getFormulaMap().isEmpty()) {
            this.replaceFormulas(workbook, context, sheetTransformer);
        }
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inFilename, String outFilename, List<String> templateSheetNamesList, List<String> newSheetNamesList, List<Map<String, Object>> beansList) throws IOException, InvalidFormatException {
        FileOutputStream fileOut = null;
        InputStream fileIn = null;
        try {
            fileOut = new FileOutputStream(outFilename);
            fileIn = new BufferedInputStream(new FileInputStream(inFilename));
            Workbook workbook = this.transform(fileIn, templateSheetNamesList, newSheetNamesList, beansList);
            workbook.write((OutputStream)fileOut);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ignored) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public Workbook transform(InputStream is, List<String> templateSheetNamesList, List<String> newSheetNamesList, List<Map<String, Object>> beansList) throws IOException, InvalidFormatException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        String prevSheetName = "";
        for (int i = 0; i < templateSheetNamesList.size(); ++i) {
            String templateSheetName = templateSheetNamesList.get(i);
            String newSheetName = newSheetNamesList.get(i);
            if (prevSheetName.equals(templateSheetName)) {
                workbook.cloneSheet(i - 1);
                workbook.setSheetName(workbook.getNumberOfSheets() - 1, newSheetName);
                workbook.setSheetOrder(newSheetName, i);
            } else {
                workbook.setSheetName(i, newSheetName);
            }
            prevSheetName = templateSheetName;
        }
        SheetTransformer sheetTransformer = new SheetTransformer();
        WorkbookContext context = this.createContext(workbook, sheetTransformer);
        int numItemsProcessed = 0;
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            if (numItemsProcessed < beansList.size()) {
                Map<String, Object> beans = beansList.get(i);
                this.exposeWorkbook(beans, workbook);
                Sheet sheet = workbook.getSheetAt(i);
                Expression.clearExpressionToCollNamesMap();
                sheetTransformer.transform(sheet, context, beans);
            }
            ++numItemsProcessed;
        }
        if (!context.getFormulaMap().isEmpty()) {
            this.replaceFormulas(workbook, context, sheetTransformer);
        }
        return workbook;
    }

    private WorkbookContext createContext(Workbook workbook, SheetTransformer transformer) {
        WorkbookContext context = new WorkbookContext();
        context.setCellListeners(this.myCellListeners);
        context.setRegistry(this.myRegistry);
        context.setFixedSizeCollectionNames(this.myFixedSizeCollectionNames);
        context.setNoImplicitCollectionProcessingNames(this.myNoImplicitProcessingCollectionNames);
        Map<String, Formula> formulaMap = this.createFormulaMap(workbook, transformer);
        context.setFormulaMap(formulaMap);
        Map<String, List<CellRef>> cellRefMap = FormulaUtil.createCellRefMap(formulaMap);
        context.setCellRefMap(cellRefMap);
        CellStyleCache csCache = new CellStyleCache(workbook);
        context.setCellStyleCache(csCache);
        FontCache fCache = new FontCache(workbook);
        context.setFontCache(fCache);
        context.setStyleMap(this.myStyleMap);
        return context;
    }

    private Map<String, Formula> createFormulaMap(Workbook workbook, SheetTransformer transformer) {
        HashMap<String, Formula> formulaMap = new HashMap<String, Formula>();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            transformer.gatherFormulas(sheet, formulaMap);
        }
        return formulaMap;
    }

    private void replaceFormulas(Workbook workbook, WorkbookContext context, SheetTransformer transformer) {
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        FormulaUtil.findAndReplaceCellRanges(cellRefMap);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            transformer.replaceFormulas(sheet, context);
        }
    }

    private void exposeWorkbook(Map<String, Object> beans, Workbook workbook) {
        beans.put("workbook", workbook);
    }
}

