/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.TagParser;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.tag.TagLibrary;
import org.apache.poi.ss.usermodel.RichTextString;

public class TagLibraryRegistry {
    private Map<String, TagLibrary> myRegistry = new HashMap<String, TagLibrary>();

    public void registerTagLibrary(String namespace, TagLibrary library) {
        if (this.myRegistry.get(namespace) != null) {
            throw new IllegalArgumentException("A tag library with namespace \"" + namespace + "\" has already been registered.");
        }
        this.myRegistry.put(namespace, library);
    }

    public Tag createTag(TagParser parser, TagContext context, WorkbookContext workbookContext) {
        if (parser == null) {
            return null;
        }
        String namespace = parser.getNamespace();
        String tagName = parser.getTagName();
        Map<String, RichTextString> attributes = parser.getAttributes();
        if (namespace == null || tagName == null) {
            return null;
        }
        TagLibrary library = this.myRegistry.get(namespace);
        if (library == null) {
            return null;
        }
        Class<? extends Tag> tagClass = library.getTagMap().get(tagName);
        if (tagClass == null) {
            return null;
        }
        try {
            Tag tag = tagClass.newInstance();
            tag.setContext(context);
            tag.setWorkbookContext(workbookContext);
            tag.setAttributes(attributes);
            tag.setBodiless(parser.isBodiless());
            return tag;
        }
        catch (Exception e) {
            throw new TagParseException("Unable to create tag " + namespace + ":" + tagName, e);
        }
    }
}

