/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.expression.Expression;
import net.sf.jett.model.Block;
import net.sf.jett.model.PastEndValue;
import net.sf.jett.tag.BaseLoopTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiForEachTag
extends BaseLoopTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_COLLECTIONS = "collections";
    public static final String ATTR_VARS = "vars";
    public static final String ATTR_INDEXVAR = "indexVar";
    public static final String ATTR_LIMIT = "limit";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("collections", "vars"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("indexVar", "limit"));
    private List<Collection<Object>> myCollections = null;
    private List<String> myCollectionNames = null;
    private List<String> myVarNames = null;
    private String myIndexVarName = null;
    private int myLimit = 0;
    private int myMaxSize = 0;

    public void setCollections(List<Collection<Object>> collections) {
        this.myCollections = collections;
    }

    public void setCollectionNames(List<String> collExpressions) {
        for (String collExpression : collExpressions) {
            this.addCollectionName(collExpression);
        }
    }

    private void addCollectionName(String collExpression) {
        int beginExprIdx = collExpression.indexOf("${");
        int endExprIdx = collExpression.indexOf("}");
        if (beginExprIdx != -1 && endExprIdx != -1 && endExprIdx > beginExprIdx) {
            this.myCollectionNames.add(collExpression.substring(beginExprIdx + "${".length(), endExprIdx));
        }
    }

    public void setVarNames(List<String> varNames) {
        this.myVarNames = varNames;
    }

    public void setIndexVarName(String indexVarName) {
        this.myIndexVarName = indexVarName;
    }

    public void setLimit(int limit) {
        this.myLimit = limit;
    }

    private void setMaxSize() {
        this.myMaxSize = 0;
        for (Collection<Object> collection : this.myCollections) {
            int size = collection.size();
            if (size <= this.myMaxSize) continue;
            this.myMaxSize = size;
        }
    }

    @Override
    public String getName() {
        return "multiForEach";
    }

    @Override
    public List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    public List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("MultiForEach tags must have a body.");
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        String attrCollExpressions = attributes.get(ATTR_COLLECTIONS).getString();
        String[] collExpressions = attrCollExpressions.split(";");
        this.myCollections = new ArrayList<Collection<Object>>();
        this.myCollectionNames = new ArrayList<String>();
        for (String collExpression : collExpressions) {
            ArrayList items = Expression.evaluateString(collExpression.trim(), beans);
            if (items == null) {
                items = new ArrayList(0);
            }
            if (!(items instanceof Collection)) {
                throw new TagParseException("One of the items in the \"collections\" attribute is not a Collection: " + collExpression);
            }
            Collection collection = AttributeUtil.evaluateObject(collExpression.trim(), beans, ATTR_COLLECTIONS, Collection.class, null);
            this.myCollections.add(collection);
            this.addCollectionName(collExpression);
        }
        this.myVarNames = AttributeUtil.evaluateList(attributes.get(ATTR_VARS), beans, new ArrayList<String>(0));
        if (this.myCollections.size() < 1) {
            throw new TagParseException("Must specify at least one Collection.");
        }
        if (this.myCollections.size() != this.myVarNames.size()) {
            throw new TagParseException("The number of collections and the number of variable names must be the same.");
        }
        this.myIndexVarName = AttributeUtil.evaluateString(attributes.get(ATTR_INDEXVAR), beans, null);
        this.setMaxSize();
        this.myLimit = AttributeUtil.evaluateNonNegativeInt(attributes.get(ATTR_LIMIT), beans, ATTR_LIMIT, this.myMaxSize);
    }

    @Override
    protected List<String> getCollectionNames() {
        return this.myCollectionNames;
    }

    @Override
    protected int getNumIterations() {
        return this.myLimit;
    }

    @Override
    protected int getCollectionSize() {
        return this.myMaxSize;
    }

    protected Iterator<List<Object>> getLoopIterator() {
        return new MultiForEachTagIterator();
    }

    @Override
    protected void beforeBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        List listOfValues = (List)item;
        ArrayList<String> pastEndRefs = new ArrayList<String>();
        for (int i = 0; i < this.myCollections.size(); ++i) {
            String varName = this.myVarNames.get(i);
            Object value = listOfValues.get(i);
            if (value != null && value instanceof PastEndValue) {
                pastEndRefs.add(varName);
                continue;
            }
            beans.put(varName, value);
        }
        if (index < this.getCollectionSize()) {
            SheetUtil.takePastEndAction(context.getSheet(), currBlock, pastEndRefs, this.getPastEndAction());
        }
        if (this.myIndexVarName != null && this.myIndexVarName.length() > 0) {
            beans.put(this.myIndexVarName, index);
        }
    }

    @Override
    protected void afterBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        for (int i = 0; i < this.myCollections.size(); ++i) {
            beans.remove(this.myVarNames.get(i));
        }
        if (this.myIndexVarName != null && this.myIndexVarName.length() > 0) {
            beans.remove(this.myIndexVarName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiForEachTagIterator
    implements Iterator<List<Object>> {
        private int myIndex = 0;
        private List<Iterator<Object>> myIterators = new ArrayList<Iterator<Object>>();

        private MultiForEachTagIterator() {
            for (Collection collection : MultiForEachTag.this.myCollections) {
                this.myIterators.add(collection.iterator());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("MultiForEachTagIterator: Remove not supported!");
        }

        @Override
        public List<Object> next() {
            ArrayList<Object> next = new ArrayList<Object>();
            for (int i = 0; i < MultiForEachTag.this.myCollections.size(); ++i) {
                Object value = PastEndValue.PAST_END_VALUE;
                Iterator<Object> iterator = this.myIterators.get(i);
                if (iterator.hasNext()) {
                    value = iterator.next();
                }
                next.add(value);
            }
            ++this.myIndex;
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < MultiForEachTag.this.myLimit;
        }
    }
}

