/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkTag
extends BaseTag {
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_ADDRESS = "address";
    public static final String ATTR_VALUE = "value";
    public static final String TYPE_URL = "url";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_DOC = "doc";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("address", "value"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("type"));
    private int myLinkType;
    private String myAddress;
    private RichTextString myValue;

    @Override
    public String getName() {
        return "hyperlink";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Hyperlink tags must not have a body.");
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        String type = AttributeUtil.evaluateStringSpecificValues(attributes.get(ATTR_TYPE), beans, ATTR_TYPE, Arrays.asList(TYPE_URL, TYPE_EMAIL, TYPE_FILE, TYPE_DOC), TYPE_URL);
        if (TYPE_URL.equals(type)) {
            this.myLinkType = 1;
        } else if (TYPE_EMAIL.equals(type)) {
            this.myLinkType = 3;
        } else if (TYPE_FILE.equals(type)) {
            this.myLinkType = 4;
        } else if (TYPE_DOC.equals(type)) {
            this.myLinkType = 2;
        }
        this.myAddress = AttributeUtil.evaluateStringNotNull(attributes.get(ATTR_ADDRESS), beans, ATTR_ADDRESS, null);
        this.myValue = attributes.get(ATTR_VALUE);
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        int left = block.getLeftColNum();
        int top = block.getTopRowNum();
        Row row = sheet.getRow(top);
        Cell cell = row.getCell(left);
        SheetUtil.setCellValue(cell, this.myValue);
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        Hyperlink hyperlink = helper.createHyperlink(this.myLinkType);
        hyperlink.setAddress(this.myAddress);
        cell.setHyperlink(hyperlink);
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }
}

