/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupTag
extends BaseTag {
    public static final String ATTR_GROUP_DIR = "groupDir";
    public static final String ATTR_COLLAPSE = "collapse";
    public static final String GROUP_DIR_COLS = "cols";
    public static final String GROUP_DIR_ROWS = "rows";
    public static final String GROUP_DIR_NONE = "none";
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("groupDir", "collapse"));
    private Block.Direction myGroupDir;
    private boolean amICollapsed;

    @Override
    public String getName() {
        return "group";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        return super.getRequiredAttributes();
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("Group tags must have a body.");
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        String groupDir = AttributeUtil.evaluateStringSpecificValues(attributes.get(ATTR_GROUP_DIR), beans, ATTR_GROUP_DIR, Arrays.asList(GROUP_DIR_ROWS, GROUP_DIR_COLS, GROUP_DIR_NONE), GROUP_DIR_ROWS);
        if (GROUP_DIR_ROWS.equals(groupDir)) {
            this.myGroupDir = Block.Direction.VERTICAL;
        } else if (GROUP_DIR_COLS.equals(groupDir)) {
            this.myGroupDir = Block.Direction.HORIZONTAL;
        } else if (GROUP_DIR_NONE.equals(groupDir)) {
            this.myGroupDir = Block.Direction.NONE;
        }
        this.amICollapsed = AttributeUtil.evaluateBoolean(attributes.get(ATTR_COLLAPSE), beans, false);
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        switch (this.myGroupDir) {
            case VERTICAL: {
                int begin = block.getTopRowNum();
                int end = block.getBottomRowNum();
                SheetUtil.groupRows(sheet, begin, end, this.amICollapsed);
                break;
            }
            case HORIZONTAL: {
                int begin = block.getLeftColNum();
                int end = block.getRightColNum();
                SheetUtil.groupColumns(sheet, begin, end, this.amICollapsed);
            }
        }
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }
}

