/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseLoopTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForTag
extends BaseLoopTag {
    public static final String ATTR_VAR = "var";
    public static final String ATTR_START = "start";
    public static final String ATTR_END = "end";
    public static final String ATTR_STEP = "step";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("var", "start", "end"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("step"));
    private String myVarName;
    private int myStart;
    private int myEnd;
    private int myStep;

    @Override
    public String getName() {
        return "for";
    }

    @Override
    public List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    public List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("For tags must have a body.");
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myVarName = AttributeUtil.evaluateString(attributes.get(ATTR_VAR), beans, null);
        this.myStart = AttributeUtil.evaluateInt(attributes.get(ATTR_START), beans, ATTR_START, 0);
        this.myEnd = AttributeUtil.evaluateInt(attributes.get(ATTR_END), beans, ATTR_END, 0);
        this.myStep = AttributeUtil.evaluateNonZeroInt(attributes.get(ATTR_STEP), beans, ATTR_STEP, 1);
    }

    @Override
    protected List<String> getCollectionNames() {
        return null;
    }

    @Override
    protected int getNumIterations() {
        if (this.myStep > 0 && this.myStart <= this.myEnd || this.myStep < 0 && this.myStart >= this.myEnd) {
            return (this.myEnd - this.myStart) / this.myStep + 1;
        }
        return 0;
    }

    @Override
    protected int getCollectionSize() {
        return this.getNumIterations();
    }

    protected Iterator<Integer> getLoopIterator() {
        return new ForTagIterator();
    }

    @Override
    protected void beforeBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        beans.put(this.myVarName, item);
    }

    @Override
    protected void afterBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        beans.remove(this.myVarName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForTagIterator
    implements Iterator<Integer> {
        private int myValue;

        private ForTagIterator() {
            this.myValue = ForTag.this.myStart;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ForTagIterator: Remove not supported!");
        }

        @Override
        public Integer next() {
            int value = this.myValue;
            this.myValue += ForTag.this.myStep;
            return value;
        }

        @Override
        public boolean hasNext() {
            return ForTag.this.myStep > 0 && this.myValue <= ForTag.this.myEnd || ForTag.this.myStep < 0 && this.myValue >= ForTag.this.myEnd;
        }
    }
}

