/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jagg.AggregateValue;
import net.sf.jagg.Aggregations;
import net.sf.jagg.Aggregator;
import net.sf.jagg.CollectAggregator;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.Group;
import net.sf.jett.tag.BaseLoopTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.GroupOrderByComparator;
import net.sf.jett.util.OrderByComparator;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachTag
extends BaseLoopTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_VAR = "var";
    public static final String ATTR_INDEXVAR = "indexVar";
    public static final String ATTR_WHERE = "where";
    public static final String ATTR_LIMIT = "limit";
    public static final String ATTR_GROUP_BY = "groupBy";
    public static final String ATTR_ORDER_BY = "orderBy";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("items", "var"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("indexVar", "where", "limit", "groupBy", "orderBy"));
    private Collection<Object> myCollection = null;
    private String myCollectionName = null;
    private String myVarName = null;
    private String myIndexVarName = null;
    private int myLimit = 0;
    private List<String> myGroupByProperties;

    @Override
    public String getName() {
        return "forEach";
    }

    @Override
    public List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    public List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("ForEach tags must have a body.");
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myCollection = AttributeUtil.evaluateObject(attributes.get(ATTR_ITEMS), beans, ATTR_ITEMS, Collection.class, new ArrayList(0));
        String attrItems = attributes.get(ATTR_ITEMS).getString();
        int beginExprIdx = attrItems.indexOf("${");
        int endExprIdx = attrItems.indexOf("}");
        if (beginExprIdx != -1 && endExprIdx != -1 && endExprIdx > beginExprIdx) {
            this.myCollectionName = attrItems.substring(beginExprIdx + "${".length(), endExprIdx);
        }
        this.myVarName = AttributeUtil.evaluateString(attributes.get(ATTR_VAR), beans, null);
        this.myIndexVarName = AttributeUtil.evaluateString(attributes.get(ATTR_INDEXVAR), beans, null);
        RichTextString rtsCondition = attributes.get(ATTR_WHERE);
        if (rtsCondition != null) {
            ArrayList<Object> newCollection = new ArrayList<Object>();
            for (Object item : this.myCollection) {
                beans.put(this.myVarName, item);
                boolean condition = AttributeUtil.evaluateBoolean(rtsCondition, beans, true);
                if (!condition) continue;
                newCollection.add(item);
            }
            beans.remove(this.myVarName);
            this.myCollection = newCollection;
        }
        List<String> orderByProperties = AttributeUtil.evaluateList(attributes.get(ATTR_ORDER_BY), beans, new ArrayList<String>(0));
        OrderByComparator<Object> comp = null;
        if (!orderByProperties.isEmpty()) {
            comp = new OrderByComparator<Object>(orderByProperties);
            this.sortTheCollection(comp);
        }
        this.myGroupByProperties = AttributeUtil.evaluateList(attributes.get(ATTR_GROUP_BY), beans, new ArrayList<String>(0));
        if (!this.myGroupByProperties.isEmpty()) {
            List<Group> groups = this.groupTheCollection();
            if (!orderByProperties.isEmpty()) {
                this.sortTheGroups(groups, comp);
            }
            this.myCollection = new ArrayList<Group>(groups);
        }
        this.myLimit = AttributeUtil.evaluateNonNegativeInt(attributes.get(ATTR_LIMIT), beans, ATTR_LIMIT, this.myCollection.size());
    }

    @Override
    protected List<String> getCollectionNames() {
        return Arrays.asList(this.myCollectionName);
    }

    @Override
    protected int getNumIterations() {
        return this.myLimit;
    }

    @Override
    protected int getCollectionSize() {
        return this.myCollection.size();
    }

    protected Iterator<Object> getLoopIterator() {
        return new ForEachTagIterator();
    }

    @Override
    protected void beforeBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        beans.put(this.myVarName, item);
        if (this.myIndexVarName != null && this.myIndexVarName.length() > 0) {
            beans.put(this.myIndexVarName, index);
        }
    }

    @Override
    protected void afterBlockProcessed(TagContext context, Block currBlock, Object item, int index) {
        Map<String, Object> beans = context.getBeans();
        beans.remove(this.myVarName);
        if (this.myIndexVarName != null && this.myIndexVarName.length() > 0) {
            beans.remove(this.myIndexVarName);
        }
    }

    private void sortTheCollection(OrderByComparator<Object> comp) {
        if (this.myCollection instanceof List) {
            Collections.sort((List)this.myCollection, comp);
        } else {
            ArrayList<Object> temp = new ArrayList<Object>(this.myCollection);
            Collections.sort(temp, comp);
            this.myCollection = temp;
        }
    }

    private void sortTheGroups(List<Group> groups, OrderByComparator<Object> comp) {
        GroupOrderByComparator gComp = new GroupOrderByComparator(comp, this.myGroupByProperties);
        Collections.sort(groups, gComp);
    }

    private List<Group> groupTheCollection() {
        ArrayList<Object> items = new ArrayList<Object>(this.myCollection);
        List<Aggregator> aggregators = Arrays.asList(new CollectAggregator("."));
        List aggValues = Aggregations.groupBy(items, this.myGroupByProperties, aggregators);
        ArrayList<Group> groups = new ArrayList<Group>(aggValues.size());
        for (AggregateValue aggValue : aggValues) {
            Group g = new Group();
            g.setItems((List)aggValue.getAggregateValue(0));
            g.setObj(aggValue.getObject());
            groups.add(g);
        }
        return groups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForEachTagIterator
    implements Iterator<Object> {
        private int myIndex = 0;
        private Iterator<Object> myInternalIterator;

        private ForEachTagIterator() {
            this.myInternalIterator = ForEachTag.this.myCollection.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ForEachTagIterator: Remove not supported!");
        }

        @Override
        public Object next() {
            Object next = null;
            ++this.myIndex;
            if (this.myIndex <= ForEachTag.this.myCollection.size()) {
                next = this.myInternalIterator.next();
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < ForEachTag.this.myLimit;
        }
    }
}

