/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jett.event.TagEvent;
import net.sf.jett.event.TagListener;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTag
implements Tag {
    private static final boolean DEBUG = false;
    public static final String ATTR_ON_PROCESSED = "onProcessed";
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("onProcessed"));
    private Map<String, RichTextString> myAttributes;
    private TagContext myContext;
    private WorkbookContext myWorkbookContext;
    private boolean amIBodiless;
    private TagListener myTagListener;
    public static final String SPEC_SEP = ";";

    @Override
    public void setAttributes(Map<String, RichTextString> attributes) {
        this.myAttributes = attributes;
    }

    @Override
    public Map<String, RichTextString> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public void setContext(TagContext context) {
        this.myContext = context;
    }

    @Override
    public WorkbookContext getWorkbookContext() {
        return this.myWorkbookContext;
    }

    @Override
    public void setWorkbookContext(WorkbookContext context) {
        this.myWorkbookContext = context;
    }

    @Override
    public TagContext getContext() {
        return this.myContext;
    }

    @Override
    public void setBodiless(boolean bodiless) {
        this.amIBodiless = bodiless;
    }

    @Override
    public boolean isBodiless() {
        return this.amIBodiless;
    }

    public void checkAttributes() {
        Map<String, RichTextString> attributes = this.getAttributes();
        List<String> required = this.getRequiredAttributes();
        List<String> optional = this.getOptionalAttributes();
        if (required != null) {
            for (String reqName : required) {
                if (attributes.containsKey(reqName)) continue;
                throw new TagParseException("Required attribute \"" + reqName + "\" not found for tag \"" + this.getName() + "\".");
            }
        }
        Set<String> keys = attributes.keySet();
        for (String key : keys) {
            if (required != null && required.contains(key) || optional != null && optional.contains(key)) continue;
            throw new TagParseException("Unrecognized attribute \"" + key + "\" for tag \"" + this.getName() + "\".");
        }
        this.validateAttributes();
    }

    @Override
    public boolean processTag() {
        this.checkAttributes();
        boolean processed = this.process();
        this.fireTagEvent();
        return processed;
    }

    private void fireTagEvent() {
        if (this.myTagListener != null) {
            TagEvent tagEvent = new TagEvent();
            TagContext context = this.getContext();
            tagEvent.setBeans(context.getBeans());
            tagEvent.setBlock(context.getBlock());
            tagEvent.setSheet(context.getSheet());
            this.myTagListener.onTagProcessed(tagEvent);
        }
    }

    protected void removeBlock() {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        Sheet sheet = context.getSheet();
        SheetUtil.removeBlock(sheet, block, this.getWorkbookContext());
        block.collapse();
    }

    protected void deleteBlock() {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        Sheet sheet = context.getSheet();
        SheetUtil.deleteBlock(sheet, block, this.getWorkbookContext());
        block.collapse();
    }

    protected void clearBlock() {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        Sheet sheet = context.getSheet();
        SheetUtil.clearBlock(sheet, block, this.getWorkbookContext());
        block.collapse();
    }

    protected List<String> getRequiredAttributes() {
        return new ArrayList<String>();
    }

    protected List<String> getOptionalAttributes() {
        return new ArrayList<String>(OPT_ATTRS);
    }

    protected void validateAttributes() throws TagParseException {
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myTagListener = AttributeUtil.evaluateObject(attributes.get(ATTR_ON_PROCESSED), beans, ATTR_ON_PROCESSED, TagListener.class, null);
    }

    public abstract boolean process();
}

