/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.parser.TagScanner;
import net.sf.jett.util.RichTextStringUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagParser {
    public static final String BEGIN_START_TAG = "<";
    public static final String BEGIN_END_TAG = "</";
    public static final String END_TAG = ">";
    public static final String END_BODILESS_TAG = "/>";
    private Cell myCell;
    private String myCellText;
    private RichTextString myCellRichTextString;
    private int myStartIdx;
    private String myNamespace;
    private String myTagName;
    private boolean amIATag;
    private boolean amIEndTag;
    private boolean amIBodiless;
    private Map<String, RichTextString> myAttributes = new HashMap<String, RichTextString>();
    private int myTagStartIdx;
    private int myTagEndIdx;

    public TagParser(Cell cell) {
        this(cell, 0);
    }

    public TagParser(Cell cell, int startIdx) {
        this.myCell = cell;
        this.setCellText(cell.getStringCellValue().substring(startIdx));
        this.myStartIdx = startIdx;
        this.myCellRichTextString = cell.getRichStringCellValue();
    }

    public void setCellText(String tagText) {
        this.myCellText = tagText;
        this.reset();
    }

    private void reset() {
        this.myNamespace = null;
        this.myTagName = null;
        this.amIATag = false;
        this.amIEndTag = false;
        this.amIBodiless = false;
        this.myAttributes.clear();
        this.myTagStartIdx = -1;
        this.myTagEndIdx = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() {
        TagScanner scanner = new TagScanner(this.myCellText);
        TagScanner.Token token = scanner.getNextToken();
        while (token != TagScanner.Token.TOKEN_BEGIN_ANGLE_BRACKET && token != TagScanner.Token.TOKEN_BEGIN_ANGLE_BRACKET_SLASH && token != TagScanner.Token.TOKEN_EOI) {
            token = scanner.getNextToken();
        }
        int begPos = scanner.getNextPosition();
        switch (token) {
            case TOKEN_BEGIN_ANGLE_BRACKET: {
                this.myTagStartIdx = begPos - 1;
                this.amIEndTag = false;
                this.amIATag = true;
                break;
            }
            case TOKEN_BEGIN_ANGLE_BRACKET_SLASH: {
                this.myTagStartIdx = begPos - 2;
                this.amIEndTag = true;
                this.amIATag = true;
                break;
            }
            default: {
                this.myTagStartIdx = -1;
                this.myTagEndIdx = -1;
                this.amIATag = false;
                return;
            }
        }
        token = scanner.getNextToken();
        if (token == TagScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        if (token == TagScanner.Token.TOKEN_STRING) {
            String lexeme = scanner.getCurrLexeme();
            token = scanner.getNextToken();
            if (token == TagScanner.Token.TOKEN_COLON) {
                token = scanner.getNextToken();
                if (token != TagScanner.Token.TOKEN_STRING) throw new TagParseException("Cannot find tag name in tag text: " + this.myCellText);
                this.myNamespace = lexeme;
                this.myTagName = scanner.getCurrLexeme();
                token = scanner.getNextToken();
            } else {
                this.myNamespace = "";
                this.myTagName = lexeme;
            }
        } else if (token == TagScanner.Token.TOKEN_COLON) {
            throw new TagParseException("Cannot find namespace in tag text: " + this.myCellText);
        }
        String attrName = null;
        boolean insideDoubleQuotes = false;
        while (token.getCode() >= 0 && token != TagScanner.Token.TOKEN_END_ANGLE_BRACKET && token != TagScanner.Token.TOKEN_SLASH_END_ANGLE_BRACKET) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    break;
                }
                case TOKEN_STRING: {
                    if (insideDoubleQuotes) {
                        if (attrName == null) {
                            throw new TagParseException("Value found without attribute name: " + this.myCellText);
                        }
                        int pos = this.myStartIdx + scanner.getNextPosition();
                        RichTextString attrValue = RichTextStringUtil.substring(this.myCellRichTextString, this.myCell.getSheet().getWorkbook().getCreationHelper(), pos - scanner.getCurrLexeme().length(), pos);
                        this.myAttributes.put(attrName, attrValue);
                        attrName = null;
                        break;
                    }
                    attrName = scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_EQUALS: {
                    if (attrName != null) break;
                    throw new TagParseException("Attribute name missing before \"=\": " + this.myCellText);
                }
                case TOKEN_COLON: {
                    throw new TagParseException("Colon not allowed in attribute name: " + this.myCellText);
                }
                case TOKEN_DOUBLE_QUOTE: {
                    insideDoubleQuotes = !insideDoubleQuotes;
                    break;
                }
                case TOKEN_BEGIN_ANGLE_BRACKET: 
                case TOKEN_BEGIN_ANGLE_BRACKET_SLASH: {
                    throw new TagParseException("Cannot start a tag within another tag: " + this.myCellText);
                }
                case TOKEN_EOI: {
                    throw new TagParseException("Tags must start with \"<\" or \"</\" and end with \">\" or \"/>\": " + this.myCellText);
                }
                default: {
                    throw new TagParseException("Parse error occurred: " + this.myCellText);
                }
            }
            token = scanner.getNextToken();
        }
        if (attrName != null) {
            throw new TagParseException("Found end of tag before attribute value: " + this.myCellText);
        }
        if (token.getCode() < 0) {
            throw new TagParseException("Found end of input while scanning attribute value: " + this.myCellText);
        }
        this.amIBodiless = token == TagScanner.Token.TOKEN_SLASH_END_ANGLE_BRACKET;
        this.myTagEndIdx = scanner.getNextPosition();
    }

    public boolean isTag() {
        return this.amIATag;
    }

    public boolean isEndTag() {
        return this.amIEndTag;
    }

    public boolean isBodiless() {
        return this.amIBodiless;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getTagName() {
        return this.myTagName;
    }

    public String getNamespaceAndTagName() {
        if (this.myNamespace != null && this.myNamespace.length() > 0) {
            return this.myNamespace + ":" + this.myTagName;
        }
        return this.myTagName;
    }

    public Map<String, RichTextString> getAttributes() {
        return this.myAttributes;
    }

    public Cell getCell() {
        return this.myCell;
    }

    public String getTagText() {
        if (this.myTagStartIdx != -1 && this.myTagEndIdx != -1) {
            return this.myCellText.substring(this.myTagStartIdx, this.myTagEndIdx);
        }
        return null;
    }

    public int getAfterTagIdx() {
        return this.myTagEndIdx;
    }
}

