/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

public class StyleScanner {
    private static final String PUNCT_CHARS_NOT_AS_STRING = ":.{};/*";
    private String myCssText;
    private int myOffset;
    private String myCurrLexeme;

    public StyleScanner() {
        this("");
    }

    public StyleScanner(String cssText) {
        this.setCssText(cssText);
    }

    public Token getNextToken() {
        int iStartOfToken = this.myOffset;
        int iTokenLength = 0;
        Token tokenType = Token.TOKEN_UNKNOWN;
        if (iStartOfToken >= this.myCssText.length()) {
            return Token.TOKEN_EOI;
        }
        if (this.myCssText.charAt(iStartOfToken) == '/' && iStartOfToken + 1 < this.myCssText.length() && this.myCssText.charAt(iStartOfToken + 1) == '*') {
            iTokenLength += 2;
            boolean endOfCommentFound = false;
            while (iStartOfToken + iTokenLength < this.myCssText.length()) {
                if (this.myCssText.charAt(iStartOfToken + iTokenLength) == '*' && iStartOfToken + iTokenLength + 1 < this.myCssText.length() && this.myCssText.charAt(iStartOfToken + iTokenLength + 1) == '/') {
                    iTokenLength += 2;
                    endOfCommentFound = true;
                    break;
                }
                ++iTokenLength;
            }
            if (!endOfCommentFound) {
                this.myCurrLexeme = null;
                return Token.TOKEN_ERROR_EOI_IN_COMMENT;
            }
            this.myOffset += iTokenLength;
            iStartOfToken = this.myOffset;
            iTokenLength = 0;
        }
        if (iStartOfToken + iTokenLength < this.myCssText.length() && !Character.isWhitespace(this.myCssText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myCssText.charAt(iStartOfToken + iTokenLength)) == -1) {
            while (iStartOfToken + iTokenLength < this.myCssText.length() && !Character.isWhitespace(this.myCssText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myCssText.charAt(iStartOfToken + iTokenLength)) == -1) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_STRING;
        } else if (this.myCssText.charAt(iStartOfToken) == ':') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_COLON;
        } else if (this.myCssText.charAt(iStartOfToken) == '.') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_PERIOD;
        } else if (this.myCssText.charAt(iStartOfToken) == '}') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_END_BRACE;
        } else if (this.myCssText.charAt(iStartOfToken) == '{') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_BEGIN_BRACE;
        } else if (this.myCssText.charAt(iStartOfToken) == ';') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_SEMICOLON;
        } else if (Character.isWhitespace(this.myCssText.charAt(iStartOfToken))) {
            while (iStartOfToken + iTokenLength < this.myCssText.length() && Character.isWhitespace(this.myCssText.charAt(iStartOfToken + iTokenLength))) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_WHITESPACE;
        }
        this.myCurrLexeme = this.myCssText.substring(iStartOfToken, iStartOfToken + iTokenLength);
        this.myOffset += iTokenLength;
        return tokenType;
    }

    public String getCurrLexeme() {
        return this.myCurrLexeme;
    }

    public int getNextPosition() {
        return this.myOffset;
    }

    public void reset() {
        this.myOffset = 0;
        this.myCurrLexeme = null;
    }

    public void setCssText(String cssText) {
        this.myCssText = cssText;
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        TOKEN_ERROR_EOI_IN_COMMENT(-3),
        TOKEN_ERROR_BUF_NULL(-2),
        TOKEN_UNKNOWN(-1),
        TOKEN_WHITESPACE(0),
        TOKEN_STRING(1),
        TOKEN_COLON(11),
        TOKEN_PERIOD(12),
        TOKEN_BEGIN_BRACE(13),
        TOKEN_END_BRACE(14),
        TOKEN_SEMICOLON(15),
        TOKEN_COMMENT(98),
        TOKEN_EOI(99);

        private int myCode;

        private Token(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

