/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

public class FormulaScanner {
    private static final String PUNCT_CHARS_NOT_AS_STRING = "'!(),=<>&+*-/^%|";
    private String myFormulaText;
    private int myOffset;
    private boolean amIInsideSingleQuotes;
    private boolean amIInsideDoubleQuotes;
    private String myCurrLexeme;

    public FormulaScanner() {
        this("");
    }

    public FormulaScanner(String formulaText) {
        this.setFormulaText(formulaText);
    }

    public Token getNextToken() {
        int iStartOfToken = this.myOffset;
        int iTokenLength = 0;
        Token tokenType = Token.TOKEN_UNKNOWN;
        if (this.amIInsideSingleQuotes) {
            if (iStartOfToken >= this.myFormulaText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_SQUOTES;
            } else if (this.myFormulaText.charAt(iStartOfToken) == '\'') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_SINGLE_QUOTE;
                this.amIInsideSingleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myFormulaText.length() && this.myFormulaText.charAt(iStartOfToken + iTokenLength) != '\'') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (this.amIInsideDoubleQuotes) {
            if (iStartOfToken >= this.myFormulaText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_DQUOTES;
            } else if (this.myFormulaText.charAt(iStartOfToken) == '\"') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_DOUBLE_QUOTE;
                this.amIInsideDoubleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myFormulaText.length() && this.myFormulaText.charAt(iStartOfToken + iTokenLength) != '\"') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (iStartOfToken >= this.myFormulaText.length()) {
            iTokenLength = 0;
            tokenType = Token.TOKEN_EOI;
        } else if (iStartOfToken + iTokenLength < this.myFormulaText.length() && !Character.isWhitespace(this.myFormulaText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myFormulaText.charAt(iStartOfToken + iTokenLength)) == -1) {
            while (iStartOfToken + iTokenLength < this.myFormulaText.length() && !Character.isWhitespace(this.myFormulaText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myFormulaText.charAt(iStartOfToken + iTokenLength)) == -1) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_STRING;
        } else if (this.myFormulaText.charAt(iStartOfToken) == '!') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_EXCLAMATION;
        } else if (this.myFormulaText.charAt(iStartOfToken) == ',') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_COMMA;
        } else if (this.myFormulaText.charAt(iStartOfToken) == '\'') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_SINGLE_QUOTE;
            this.amIInsideSingleQuotes = true;
        } else if (this.myFormulaText.charAt(iStartOfToken) == '\"') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_DOUBLE_QUOTE;
            this.amIInsideDoubleQuotes = true;
        } else if (this.myFormulaText.charAt(iStartOfToken) == '(') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_LEFT_PAREN;
        } else if (this.myFormulaText.charAt(iStartOfToken) == ')') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_RIGHT_PAREN;
        } else if (this.myFormulaText.charAt(iStartOfToken) == '|') {
            if (iStartOfToken + 1 < this.myFormulaText.length() && this.myFormulaText.charAt(iStartOfToken + 1) == '|') {
                iTokenLength = 2;
                tokenType = Token.TOKEN_DOUBLE_PIPE;
            } else {
                iTokenLength = 1;
                tokenType = Token.TOKEN_OPERATOR;
            }
        } else if (this.myFormulaText.charAt(iStartOfToken) == '=' || this.myFormulaText.charAt(iStartOfToken) == '<' || this.myFormulaText.charAt(iStartOfToken) == '>' || this.myFormulaText.charAt(iStartOfToken) == '&' || this.myFormulaText.charAt(iStartOfToken) == '+' || this.myFormulaText.charAt(iStartOfToken) == '*' || this.myFormulaText.charAt(iStartOfToken) == '-' || this.myFormulaText.charAt(iStartOfToken) == '/' || this.myFormulaText.charAt(iStartOfToken) == '^' || this.myFormulaText.charAt(iStartOfToken) == '%') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_OPERATOR;
        } else if (Character.isWhitespace(this.myFormulaText.charAt(iStartOfToken))) {
            while (iStartOfToken + iTokenLength < this.myFormulaText.length() && Character.isWhitespace(this.myFormulaText.charAt(iStartOfToken + iTokenLength))) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_WHITESPACE;
        }
        this.myCurrLexeme = this.myFormulaText.substring(iStartOfToken, iStartOfToken + iTokenLength);
        this.myOffset += iTokenLength;
        return tokenType;
    }

    public String getCurrLexeme() {
        return this.myCurrLexeme;
    }

    public void reset() {
        this.myOffset = 0;
        this.amIInsideSingleQuotes = false;
        this.amIInsideDoubleQuotes = false;
        this.myCurrLexeme = null;
    }

    public void setFormulaText(String formulaText) {
        this.myFormulaText = formulaText;
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        TOKEN_ERROR_EOI_IN_SQUOTES(-4),
        TOKEN_ERROR_EOI_IN_DQUOTES(-3),
        TOKEN_ERROR_BUF_NULL(-2),
        TOKEN_UNKNOWN(-1),
        TOKEN_WHITESPACE(0),
        TOKEN_STRING(1),
        TOKEN_SINGLE_QUOTE(11),
        TOKEN_DOUBLE_QUOTE(12),
        TOKEN_EXCLAMATION(13),
        TOKEN_LEFT_PAREN(14),
        TOKEN_RIGHT_PAREN(15),
        TOKEN_COMMA(16),
        TOKEN_DOUBLE_PIPE(17),
        TOKEN_OPERATOR(18),
        TOKEN_EOI(99);

        private int myCode;

        private Token(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

