/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.expression;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.expression.JaggFuncs;
import net.sf.jett.expression.JettFuncs;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;

public class ExpressionFactory {
    private static final ExpressionFactory theFactory = new ExpressionFactory();
    private JexlEngine myEngine;
    private Map<String, Object> myFuncs = new HashMap<String, Object>();

    private ExpressionFactory() {
        this.myEngine = new JexlEngine();
        this.myEngine.setLenient(true);
        this.myEngine.setSilent(false);
        this.myFuncs = new HashMap<String, Object>();
        this.myEngine.setFunctions(this.myFuncs);
        this.myFuncs.put("jagg", JaggFuncs.class);
        this.myFuncs.put("jett", JettFuncs.class);
    }

    public void setLenient(boolean lenient) {
        this.myEngine.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.myEngine.isLenient();
    }

    public void setSilent(boolean silent) {
        this.myEngine.setSilent(silent);
    }

    public boolean isSilent() {
        return this.myEngine.isSilent();
    }

    public void setCache(int size) {
        this.myEngine.setCache(size);
    }

    public void registerFuncs(String namespace, Object funcsObject) {
        if (this.myFuncs.get(namespace) != null) {
            throw new IllegalArgumentException("A functions object with namespace \"" + namespace + "\" has already been registered.");
        }
        this.myFuncs.put(namespace, funcsObject);
    }

    public static ExpressionFactory getExpressionFactory() {
        return theFactory;
    }

    public Expression createExpression(String expression) {
        return this.myEngine.createExpression(expression);
    }
}

