package net.sf.javaprinciples.sample.client;

import com.google.gwt.activity.shared.AbstractActivity;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.RootPanel;

import net.sf.javaprinciples.presentation.activity.ClientContext;
import net.sf.javaprinciples.presentation.view.model.MenuView;

public class SampleActivity extends AbstractActivity
{
	private ClientContext clientContext;
	private SamplePlace place;
	private boolean started;

	public SampleActivity(final ClientContext clientContext)
	{
		this.clientContext = clientContext;
	}

	public void setPlace(SamplePlace place)
	{
		this.place = place;
	}

	@Override
	public void onStop() 
	{
		started = false;
	}
	
	@Override
	public void start(AcceptsOneWidget root, EventBus eventBus)
	{
		started = true;
		RootPanel.get("loading").setVisible(true);

		MenuView view = new MenuView(clientContext);
        view.layout();
		root.setWidget(view);

        RootPanel.get("loading").setVisible(false);
    }
}
