/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.javascript;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JasperReportsContextAware;
import net.sf.jasperreports.functions.FunctionsUtil;
import net.sf.jasperreports.javascript.JavaScriptClassLoader;
import net.sf.jasperreports.javascript.JavaScriptCompiledData;
import net.sf.jasperreports.javascript.JavaScriptEvaluatorScope;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Script;

public class JavaScriptCompiledEvaluator
extends JREvaluator
implements JasperReportsContextAware {
    private static final Log log = LogFactory.getLog(JavaScriptCompiledEvaluator.class);
    protected static final String EXPRESSION_ID_VAR = "_jreid";
    private static final ReferenceMap<String, JavaScriptClassLoader> scriptClassLoaders = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
    private final JasperReportsContext jasperReportsContext;
    private final String unitName;
    private final JavaScriptCompiledData compiledData;
    private FunctionsUtil functionsUtil;
    private JavaScriptEvaluatorScope evaluatorScope;
    private final Map<Integer, Script> scripts = new HashMap<Integer, Script>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JavaScriptClassLoader getScriptClassLoader(String unitName) {
        JavaScriptClassLoader loader;
        boolean created = false;
        ReferenceMap<String, JavaScriptClassLoader> referenceMap = scriptClassLoaders;
        synchronized (referenceMap) {
            loader = (JavaScriptClassLoader)((Object)scriptClassLoaders.get((Object)unitName));
            if (loader == null) {
                loader = new JavaScriptClassLoader();
                scriptClassLoaders.put((Object)unitName, (Object)loader);
                created = true;
            }
        }
        if (created && log.isDebugEnabled()) {
            log.debug((Object)("created script class loader " + (Object)((Object)loader) + " for " + unitName));
        }
        return loader;
    }

    public JavaScriptCompiledEvaluator(JasperReportsContext jasperReportsContext, String unitName, JavaScriptCompiledData compiledData) {
        this.jasperReportsContext = jasperReportsContext;
        this.unitName = unitName;
        this.compiledData = compiledData;
    }

    public void setJasperReportsContext(JasperReportsContext context) {
        this.functionsUtil = FunctionsUtil.getInstance((JasperReportsContext)context);
    }

    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        this.evaluatorScope = new JavaScriptEvaluatorScope(this.jasperReportsContext, this, this.functionsUtil);
        this.evaluatorScope.init(parametersMap, fieldsMap, variablesMap);
    }

    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpressionIndex());
    }

    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpressionIndex());
    }

    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompiledData.ExpressionIndexes expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpressionIndex());
    }

    protected JavaScriptCompiledData.ExpressionIndexes getExpression(int id) {
        return this.compiledData.getExpression(id);
    }

    protected Object evaluateExpression(int expressionIndex) {
        int scriptIndex = JavaScriptCompiledData.scriptIndex(expressionIndex);
        Script script = this.scripts.get(scriptIndex);
        if (script == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("creating script for expression index " + expressionIndex + ", script index " + scriptIndex));
            }
            JavaScriptClassLoader scriptClassLoader = JavaScriptCompiledEvaluator.getScriptClassLoader(this.unitName);
            script = scriptClassLoader.createScript(scriptIndex, this.compiledData);
            this.scripts.put(scriptIndex, script);
        }
        int expressionId = JavaScriptCompiledData.expressionId(expressionIndex);
        this.evaluatorScope.setScopeVariable(EXPRESSION_ID_VAR, expressionId);
        Object value = this.evaluatorScope.evaluateExpression(script);
        if (log.isTraceEnabled()) {
            log.trace((Object)("expression with index " + expressionIndex + ", id " + expressionId + " evaluated to " + value));
        }
        return value;
    }
}

