/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.LogicalCategory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@FunctionCategories(value={LogicalCategory.class})
public final class LogicalFunctions {
    private static final Log log = LogFactory.getLog(LogicalFunctions.class);

    @Function(value="AND")
    @FunctionParameters(value={@FunctionParameter(value="arguments")})
    public static Boolean AND(Boolean ... arguments) {
        if (arguments.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No arguments were specified.");
            }
            return null;
        }
        boolean result = true;
        for (Boolean arg : arguments) {
            boolean bl = result = result && arg != false;
            if (result) continue;
            return false;
        }
        return result;
    }

    @Function(value="FALSE")
    public static Boolean FALSE() {
        return Boolean.FALSE;
    }

    @Function(value="TRUE")
    public static Boolean TRUE() {
        return Boolean.TRUE;
    }

    @Function(value="NOT")
    @FunctionParameters(value={@FunctionParameter(value="boolValue")})
    public static Boolean NOT(Boolean boolValue) {
        if (boolValue == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Argument can not be null.");
            }
            return null;
        }
        return boolValue == false;
    }

    @Function(value="OR")
    @FunctionParameters(value={@FunctionParameter(value="arguments")})
    public static Boolean OR(Boolean ... arguments) {
        if (arguments.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No arguments were specified.");
            }
            return null;
        }
        boolean result = false;
        for (Boolean arg : arguments) {
            boolean bl = result = result || arg != false;
            if (!result) continue;
            return true;
        }
        return result;
    }

    @Function(value="IF")
    @FunctionParameters(value={@FunctionParameter(value="test"), @FunctionParameter(value="value1"), @FunctionParameter(value="value2")})
    public static Object IF(Boolean test, Object value1, Object value2) {
        if (test == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Test condition can not be null.");
            }
            return null;
        }
        return test != false ? value1 : value2;
    }

    @Function(value="EQUALS")
    @FunctionParameters(value={@FunctionParameter(value="obj1"), @FunctionParameter(value="obj2")})
    public static Boolean EQUALS(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        if (obj2 != null) {
            return obj2.equals(obj1);
        }
        return true;
    }
}

