/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Color;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartVisitor;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRApiWriter;
import net.sf.jasperreports.engine.util.JRApiWriterVisitor;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class ChartsApiWriter
implements ChartVisitor {
    private final JRApiWriter parent;
    private final String name;

    public ChartsApiWriter(JRApiWriterVisitor visitor) {
        this.parent = visitor.getApiWriter();
        this.name = visitor.getName();
    }

    @Override
    public void visitChart(JRChart chart) {
        this.writeChartTag(chart, this.name);
    }

    private void writeChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write(chartName + ".setShowLegend({0});\n", (Object)this.parent.getBooleanText(chart.getShowLegend()));
            this.parent.write(chartName + ".setEvaluationTime({0});\n", (Enum)chart.getEvaluationTime(), (Enum)EvaluationTimeEnum.NOW);
            this.parent.write(chartName + ".setEvaluationGroup(\"{0}\");\n", (Object)chart.getEvaluationGroup());
            if (chart.getLinkType() != null) {
                this.parent.write(chartName + ".setLinkType(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)chart.getLinkType()), (Object)HyperlinkTypeEnum.NONE.getName());
            }
            if (chart.getLinkTarget() != null) {
                this.parent.write(chartName + ".setLinkTarget(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)chart.getLinkTarget()), (Object)HyperlinkTargetEnum.SELF.getName());
            }
            this.parent.write(chartName + ".setBookmarkLevel({0, number, #});\n", chart.getBookmarkLevel(), 0);
            if (chart.getCustomizerClass() != null) {
                this.parent.write(chartName + ".setCustomizerClass(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)chart.getCustomizerClass()));
            }
            this.parent.write(chartName + ".setRenderType(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)chart.getRenderType()));
            this.parent.write(chartName + ".setTheme(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)chart.getTheme()));
            this.parent.writeReportElement((JRElement)chart, chartName);
            this.parent.writeBox(chart.getLineBox(), chartName + ".getLineBox()");
            this.parent.write(chartName + ".setTitlePosition({0});\n", (Enum)chart.getTitlePosition());
            this.parent.write(chartName + ".setTitleColor({0});\n", chart.getOwnTitleColor());
            if (chart.getTitleFont() != null) {
                this.parent.write(chartName + ".setTitleFont(new JRBaseFont());\n");
                this.parent.writeFont(chart.getTitleFont(), chartName + ".getTitleFont()");
            }
            this.parent.writeExpression(chart.getTitleExpression(), chartName, "TitleExpression");
            this.parent.write(chartName + ".setSubtitleColor({0});\n", chart.getOwnSubtitleColor());
            if (chart.getSubtitleFont() != null) {
                this.parent.write(chartName + ".setSubtitleFont(new JRBaseFont());\n");
                this.parent.writeFont(chart.getSubtitleFont(), chartName + ".getSubtitleFont()");
            }
            this.parent.writeExpression(chart.getSubtitleExpression(), chartName, "SubtitleExpression");
            this.parent.write(chartName + ".setLegendColor({0});\n", chart.getOwnLegendColor());
            this.parent.write(chartName + ".setLegendBackgroundColor({0});\n", chart.getOwnLegendBackgroundColor());
            this.parent.write(chartName + ".setLegendPosition({0});\n", (Enum)chart.getLegendPosition());
            if (chart.getLegendFont() != null) {
                this.parent.write(chartName + ".setLegendFont(new JRBaseFont());\n");
                this.parent.writeFont(chart.getLegendFont(), chartName + ".getLegendFont()");
            }
            this.parent.writeExpression(chart.getBookmarkLevelExpression(), chartName, "BookmarkLevelExpression");
            this.parent.writeExpression(chart.getAnchorNameExpression(), chartName, "AnchorNameExpression");
            this.parent.writeExpression(chart.getHyperlinkReferenceExpression(), chartName, "HyperlinkReferenceExpression");
            this.parent.writeExpression(chart.getHyperlinkWhenExpression(), chartName, "HyperlinkWhenExpression");
            this.parent.writeExpression(chart.getHyperlinkAnchorExpression(), chartName, "HyperlinkAnchorExpression");
            this.parent.writeExpression(chart.getHyperlinkPageExpression(), chartName, "HyperlinkPageExpression");
            this.parent.writeExpression(chart.getHyperlinkTooltipExpression(), chartName, "HyperlinkTooltipExpression");
            this.parent.writeHyperlinkParameters(chart.getHyperlinkParameters(), chartName);
            this.parent.flush();
        }
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignCategoryDataset " + datasetName + " = new JRDesignCategoryDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRCategorySeries[] categorySeries = dataset.getSeries();
            if (categorySeries != null && categorySeries.length > 0) {
                for (int i = 0; i < categorySeries.length; ++i) {
                    this.writeCategorySeries(categorySeries[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignTimeSeriesDataset " + datasetName + " =  new JRDesignTimeSeriesDataset(" + parentName + ".getDataset());\n");
            if (dataset.getTimePeriod() != null && dataset.getTimePeriod() != TimePeriodEnum.DAY) {
                this.parent.write(datasetName + ".setTimePeriod({0});\n", (Enum)dataset.getTimePeriod());
            }
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRTimeSeries[] timeSeries = dataset.getSeries();
            if (timeSeries != null && timeSeries.length > 0) {
                for (int i = 0; i < timeSeries.length; ++i) {
                    this.writeTimeSeries(timeSeries[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writeGanttDataset(JRGanttDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignGanttDataset " + datasetName + " = new JRDesignGanttDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRGanttSeries[] ganttSeries = dataset.getSeries();
            if (ganttSeries != null && ganttSeries.length > 0) {
                for (int i = 0; i < ganttSeries.length; ++i) {
                    this.writeGanttSeries(ganttSeries[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignTimePeriodDataset " + datasetName + " = new JRDesignTimePeriodDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
            if (timePeriodSeries != null && timePeriodSeries.length > 0) {
                for (int i = 0; i < timePeriodSeries.length; ++i) {
                    this.writeTimePeriodSeries(timePeriodSeries[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writePieSeries(JRPieSeries pieSeries, String parentName, int index) {
        if (pieSeries != null) {
            String pieSeriesName = parentName + "PieSeries" + index;
            this.parent.write("JRDesignPieSeries " + pieSeriesName + " = new JRDesignPieSeries();\n");
            this.parent.writeExpression(pieSeries.getKeyExpression(), pieSeriesName, "KeyExpression");
            this.parent.writeExpression(pieSeries.getValueExpression(), pieSeriesName, "ValueExpression");
            this.parent.writeExpression(pieSeries.getLabelExpression(), pieSeriesName, "LabelExpression");
            this.parent.writeHyperlink(pieSeries.getSectionHyperlink(), pieSeriesName, "SectionHyperlink");
            this.parent.write(parentName + ".addPieSeries(" + pieSeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeCategorySeries(JRCategorySeries categorySeries, String parentName, int index) {
        if (categorySeries != null) {
            String categorySeriesName = parentName + "CategorySeries" + index;
            this.parent.write("JRDesignCategorySeries " + categorySeriesName + " = new JRDesignCategorySeries();\n");
            this.parent.writeExpression(categorySeries.getSeriesExpression(), categorySeriesName, "SeriesExpression");
            this.parent.writeExpression(categorySeries.getCategoryExpression(), categorySeriesName, "CategoryExpression");
            this.parent.writeExpression(categorySeries.getValueExpression(), categorySeriesName, "ValueExpression");
            this.parent.writeExpression(categorySeries.getLabelExpression(), categorySeriesName, "LabelExpression");
            this.parent.writeHyperlink(categorySeries.getItemHyperlink(), categorySeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addCategorySeries(" + categorySeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeXyzDataset(JRXyzDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignXyzDataset " + datasetName + " = new JRDesignXyzDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRXyzSeries[] series = dataset.getSeries();
            if (series != null && series.length > 0) {
                for (int i = 0; i < series.length; ++i) {
                    this.writeXyzSeries(series[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writeXyzSeries(JRXyzSeries series, String parentName, int index) {
        if (series != null) {
            String xyzSeriesName = parentName + "XyzSeries" + index;
            this.parent.write("JRDesignXyzSeries " + xyzSeriesName + " = new JRDesignXyzSeries();\n");
            this.parent.writeExpression(series.getSeriesExpression(), xyzSeriesName, "SeriesExpression");
            this.parent.writeExpression(series.getXValueExpression(), xyzSeriesName, "XValueExpression");
            this.parent.writeExpression(series.getYValueExpression(), xyzSeriesName, "YValueExpression");
            this.parent.writeExpression(series.getZValueExpression(), xyzSeriesName, "ZValueExpression");
            this.parent.writeHyperlink(series.getItemHyperlink(), xyzSeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addXyzSeries(" + xyzSeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeXySeries(JRXySeries xySeries, String parentName, int index) {
        if (xySeries != null) {
            String xySeriesName = parentName + "XySeries" + index;
            this.parent.write("JRDesignXySeries " + xySeriesName + " = new JRDesignXySeries();\n");
            if (xySeries.getAutoSort() != null) {
                this.parent.write(xySeriesName + ".setAutoSort({0});\n", (Object)xySeries.getAutoSort());
            }
            this.parent.writeExpression(xySeries.getSeriesExpression(), xySeriesName, "SeriesExpression");
            this.parent.writeExpression(xySeries.getXValueExpression(), xySeriesName, "XValueExpression");
            this.parent.writeExpression(xySeries.getYValueExpression(), xySeriesName, "YValueExpression");
            this.parent.writeExpression(xySeries.getLabelExpression(), xySeriesName, "LabelExpression");
            this.parent.writeHyperlink(xySeries.getItemHyperlink(), xySeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addXySeries(" + xySeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeXyDataset(JRXyDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignXyDataset " + datasetName + " = new JRDesignXyDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRXySeries[] xySeries = dataset.getSeries();
            if (xySeries != null && xySeries.length > 0) {
                for (int i = 0; i < xySeries.length; ++i) {
                    this.writeXySeries(xySeries[i], datasetName, i);
                }
            }
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    private void writeTimeSeries(JRTimeSeries timeSeries, String parentName, int index) {
        if (timeSeries != null) {
            String timeSeriesName = parentName + "TimeSeries" + index;
            this.parent.write("JRDesignTimeSeries " + timeSeriesName + " = new JRDesignTimeSeries();\n");
            this.parent.writeExpression(timeSeries.getSeriesExpression(), timeSeriesName, "SeriesExpression");
            this.parent.writeExpression(timeSeries.getTimePeriodExpression(), timeSeriesName, "TimePeriodExpression");
            this.parent.writeExpression(timeSeries.getValueExpression(), timeSeriesName, "ValueExpression");
            this.parent.writeExpression(timeSeries.getLabelExpression(), timeSeriesName, "LabelExpression");
            this.parent.writeHyperlink(timeSeries.getItemHyperlink(), timeSeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addTimeSeries(" + timeSeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeGanttSeries(JRGanttSeries ganttSeries, String parentName, int index) {
        if (ganttSeries != null) {
            String ganttSeriesName = parentName + "GanttSeries" + index;
            this.parent.write("JRDesignGanttSeries " + ganttSeriesName + " = new JRDesignGanttSeries();\n");
            this.parent.writeExpression(ganttSeries.getSeriesExpression(), ganttSeriesName, "SeriesExpression");
            this.parent.writeExpression(ganttSeries.getTaskExpression(), ganttSeriesName, "TaskExpression");
            this.parent.writeExpression(ganttSeries.getSubtaskExpression(), ganttSeriesName, "SubtaskExpression");
            this.parent.writeExpression(ganttSeries.getStartDateExpression(), ganttSeriesName, "StartDateExpression");
            this.parent.writeExpression(ganttSeries.getEndDateExpression(), ganttSeriesName, "EndDateExpression");
            this.parent.writeExpression(ganttSeries.getPercentExpression(), ganttSeriesName, "PercentExpression");
            this.parent.writeExpression(ganttSeries.getLabelExpression(), ganttSeriesName, "LabelExpression");
            this.parent.writeHyperlink(ganttSeries.getItemHyperlink(), ganttSeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addGanttSeries(" + ganttSeriesName + ");\n");
            this.parent.flush();
        }
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries, String parentName, int index) {
        if (timePeriodSeries != null) {
            String timePeriodSeriesName = parentName + "TimePeriodSeries" + index;
            this.parent.write("JRDesignTimePeriodSeries " + timePeriodSeriesName + " = new JRDesignTimePeriodSeries();\n");
            this.parent.writeExpression(timePeriodSeries.getSeriesExpression(), timePeriodSeriesName, "SeriesExpression");
            this.parent.writeExpression(timePeriodSeries.getStartDateExpression(), timePeriodSeriesName, "StartDateExpression");
            this.parent.writeExpression(timePeriodSeries.getEndDateExpression(), timePeriodSeriesName, "EndDateExpression");
            this.parent.writeExpression(timePeriodSeries.getValueExpression(), timePeriodSeriesName, "ValueExpression");
            this.parent.writeExpression(timePeriodSeries.getLabelExpression(), timePeriodSeriesName, "LabelExpression");
            this.parent.writeHyperlink(timePeriodSeries.getItemHyperlink(), timePeriodSeriesName, "ItemHyperlink");
            this.parent.write(parentName + ".addTimePeriodSeries(" + timePeriodSeriesName + ");\n");
            this.parent.flush();
        }
    }

    public void writePieDataset(JRPieDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignPieDataset " + datasetName + " = new JRDesignPieDataset(" + parentName + ".getDataset());\n");
            this.parent.write(datasetName + ".setMaxCount({0, number, #});\n", (Object)dataset.getMaxCount());
            this.parent.write(datasetName + ".setMinPercentage({0});\n", dataset.getMinPercentage());
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            JRPieSeries[] pieSeries = dataset.getSeries();
            if (pieSeries != null) {
                if (pieSeries.length > 1) {
                    for (int i = 0; i < pieSeries.length; ++i) {
                        this.writePieSeries(pieSeries[i], datasetName, i);
                    }
                } else {
                    this.writePieSeries(pieSeries[0], datasetName, 0);
                }
            }
            this.parent.writeExpression(dataset.getOtherKeyExpression(), datasetName, "OtherKeyExpression");
            this.parent.writeExpression(dataset.getOtherLabelExpression(), datasetName, "OtherLabelExpression");
            this.parent.writeHyperlink(dataset.getOtherSectionHyperlink(), datasetName, "OtherSectionHyperlink");
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    public void writeValueDataset(JRValueDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignValueDataset " + datasetName + " = new JRDesignValueDataset(" + parentName + ".getDataset());\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            this.parent.writeExpression(dataset.getValueExpression(), datasetName, "ValueExpression");
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    public void writeValueDisplay(JRValueDisplay valueDisplay, String parentName) {
        if (valueDisplay != null) {
            String valueDisplayName = parentName + "ValueDisplay";
            this.parent.write("JRDesignValueDisplay " + valueDisplayName + " = new JRDesignValueDisplay(" + parentName + ".getValueDisplay(), " + parentName + ".getChart());\n");
            this.parent.write(valueDisplayName + ".setColor({0});\n", valueDisplay.getColor());
            this.parent.write(valueDisplayName + ".setMask(\"{0}\");\n", (Object)valueDisplay.getMask());
            this.parent.write(valueDisplayName + ".setFont(new JRBaseFont());\n");
            if (valueDisplay.getFont() != null) {
                this.parent.write(valueDisplayName + ".setFont(new JRBaseFont());\n");
                this.parent.writeFont(valueDisplay.getFont(), valueDisplayName + ".getFont()");
            }
            this.parent.write(parentName + ".setValueDisplay(" + valueDisplayName + ");\n");
            this.parent.flush();
        }
    }

    public void writeItemLabel(JRItemLabel itemLabel, String parentName, String itemLabelSuffix) {
        if (itemLabel != null) {
            String itemLabelName = parentName + itemLabelSuffix;
            this.parent.write("JRDesignItemLabel " + itemLabelName + " = new JRDesignItemLabel(" + parentName + ".getItemLabel(), " + parentName + ".getChart());\n");
            this.parent.write(itemLabelName + ".setColor({0});\n", itemLabel.getColor());
            this.parent.write(itemLabelName + ".setBackgroundColor({0});\n", itemLabel.getBackgroundColor());
            if (itemLabel.getFont() != null) {
                this.parent.write(itemLabelName + ".setFont(new JRBaseFont());\n");
                this.parent.writeFont(itemLabel.getFont(), itemLabelName + ".getFont()");
            }
            this.parent.write(parentName + ".set" + itemLabelSuffix + "(" + itemLabelName + ");\n");
            this.parent.flush();
        }
    }

    public void writeDataRange(JRDataRange dataRange, String parentName, String dataRangeSuffix) {
        if (dataRange != null) {
            String dataRangeName = parentName + dataRangeSuffix;
            this.parent.write("JRDesignDataRange " + dataRangeName + " = new JRDesignDataRange(" + parentName + ".get" + dataRangeSuffix + "());\n");
            this.parent.writeExpression(dataRange.getLowExpression(), dataRangeName, "LowExpression");
            this.parent.writeExpression(dataRange.getHighExpression(), dataRangeName, "HighExpression");
            this.parent.write(parentName + ".set" + dataRangeSuffix + "(" + dataRangeName + ");\n");
            this.parent.flush();
        }
    }

    private void writeMeterInterval(JRMeterInterval interval, String parentName, String meterIntervalName) {
        if (interval != null) {
            this.parent.write("JRMeterInterval " + meterIntervalName + " = new JRMeterInterval();\n");
            this.parent.write(meterIntervalName + ".setLabel(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)interval.getLabel()));
            this.parent.write(meterIntervalName + ".setBackgroundColor({0});\n", interval.getBackgroundColor());
            this.parent.write(meterIntervalName + ".setAlpha({0});\n", interval.getAlpha());
            this.writeDataRange(interval.getDataRange(), meterIntervalName, "DataRange");
            this.parent.write(parentName + ".addInterval(" + meterIntervalName + ");\n");
            this.parent.flush();
        }
    }

    private void writeSeriesColors(SortedSet<JRChartPlot.JRSeriesColor> seriesColors, String parentName) {
        if (seriesColors == null || seriesColors.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] colors = seriesColors.toArray(new JRChartPlot.JRSeriesColor[seriesColors.size()]);
        for (int i = 0; i < colors.length; ++i) {
            String seriesColorName = parentName + "SeriesColor" + i;
            this.parent.write("JRBaseSeriesColor " + seriesColorName + " = new JRBaseSeriesColor(" + colors[i].getSeriesOrder() + ", {0});\n", colors[i].getColor());
            this.parent.write(parentName + ".addSeriesColor(" + seriesColorName + ");\n");
            this.parent.flush();
        }
    }

    private void writeChartAxis(JRChartAxis chartAxis, String parentName, String axisName, String chartName) {
        if (chartAxis != null) {
            this.writeChartTag(chartAxis.getChart(), axisName + "Chart");
            this.parent.write("JRDesignChartAxis " + axisName + " = new JRDesignChartAxis(" + parentName + ");\n");
            this.parent.write(axisName + ".setPosition({0});\n", (Enum)chartAxis.getPosition());
            this.parent.write(axisName + ".setChart(" + axisName + "Chart);\n");
            this.parent.write(parentName + ".addAxis(" + axisName + ");\n");
            this.parent.flush();
        }
    }

    private void writePlot(JRChartPlot plot, String plotName) {
        if (plot != null) {
            this.parent.write(plotName + ".setBackcolor({0});\n", plot.getOwnBackcolor());
            if (plot.getOrientation() != null && plot.getOrientation() != PlotOrientationEnum.VERTICAL) {
                this.parent.write(plotName + ".setOrientation({0});\n", (Enum)plot.getOrientation());
            }
            this.parent.write(plotName + ".setBackgroundAlpha({0});\n", plot.getBackgroundAlpha());
            this.parent.write(plotName + ".setForegroundAlpha({0});\n", plot.getForegroundAlpha());
            this.writeSeriesColors(plot.getSeriesColors(), plotName);
            this.parent.flush();
        }
    }

    public void writePieChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.PIE);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPiePlot plot = (JRPiePlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "PiePlot";
                this.parent.write("JRDesignPiePlot " + plotName + " = (JRDesignPiePlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setShowLabels({0});\n", (Object)this.parent.getBooleanText(plot.getShowLabels()));
                this.parent.write(plotName + ".setCircular({0});\n", (Object)this.parent.getBooleanText(plot.getCircular()));
                this.parent.write(plotName + ".setLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)plot.getLabelFormat()));
                this.parent.write(plotName + ".setLegendLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)plot.getLegendLabelFormat()));
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    public void writePie3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.PIE3D);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "Pie3DPlot";
                this.parent.write("JRDesignPie3DPlot " + plotName + " = (JRDesignPie3DPlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setShowLabels({0});\n", (Object)this.parent.getBooleanText(plot.getShowLabels()));
                this.parent.write(plotName + ".setCircular({0});\n", (Object)this.parent.getBooleanText(plot.getCircular()));
                this.parent.write(plotName + ".setLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)plot.getLabelFormat()));
                this.parent.write(plotName + ".setLegendLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)plot.getLegendLabelFormat()));
                this.parent.write(plotName + ".setDepthFactor({0});\n", plot.getDepthFactor());
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    public void writeCategoryAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Double labelRotation, Color axisLineColor, String parentName) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        this.parent.write(parentName + ".setCategoryAxisTickLabelRotation({0});\n", labelRotation);
        this.parent.write(parentName + ".setCategoryAxisLabelColor({0});\n", axisLabelColor);
        this.parent.write(parentName + ".setCategoryAxisTickLabelColor({0});\n", axisTickLabelColor);
        this.parent.write(parentName + ".setCategoryAxisLineColor({0});\n", axisLineColor);
        this.parent.write(parentName + ".setCategoryAxisTickLabelMask(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)axisTickLabelMask));
        this.parent.write(parentName + ".setCategoryAxisVerticalTickLabels({0});\n", (Object)this.parent.getBooleanText(axisVerticalTickLabels));
        if (axisLabelFont != null) {
            this.parent.write(parentName + ".setCategoryAxisLabelFont(new JRBaseFont());\n");
            this.parent.writeFont(axisLabelFont, parentName + ".getCategoryAxisLabelFont()");
        }
        if (axisTickLabelFont != null) {
            this.parent.write(parentName + ".setCategoryAxisTickLabelFont(new JRBaseFont());\n");
            this.parent.writeFont(axisTickLabelFont, parentName + ".getCategoryAxisTickLabelFont()");
        }
        this.parent.flush();
    }

    public void writeAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Color axisLineColor, String parentName, String axisNameSuffix, boolean isToSet) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        String axisName = parentName + axisNameSuffix;
        if (isToSet) {
            this.parent.write("JRAxisFormat " + axisName + " = new JRAxisFormat();\n");
        }
        this.parent.write(axisName + ".setLabelColor({0});\n", axisLabelColor);
        this.parent.write(axisName + ".setTickLabelColor({0});\n", axisTickLabelColor);
        this.parent.write(axisName + ".setLineColor({0});\n", axisLineColor);
        this.parent.write(axisName + ".setTickLabelMask(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)axisTickLabelMask));
        this.parent.write(axisName + ".setVerticalTickLabel({0});\n", (Object)this.parent.getBooleanText(axisVerticalTickLabels));
        if (axisLabelFont != null) {
            this.parent.write(axisName + ".setLabelFont(new JRBaseFont());\n");
            this.parent.writeFont(axisLabelFont, axisName + ".getLabelFont()");
        }
        if (axisTickLabelFont != null) {
            this.parent.write(axisName + ".setTickLabelFont(new JRBaseFont());\n");
            this.parent.writeFont(axisTickLabelFont, axisName + ".getTickLabelFont()");
        }
        if (isToSet) {
            this.parent.write(parentName + ".set" + axisNameSuffix + "(" + axisName + ");\n");
        }
        this.parent.flush();
    }

    private void writeBarPlot(JRBarPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BarPlot";
            this.parent.write("JRDesignBarPlot " + plotName + " = (JRDesignBarPlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setShowLabels({0});\n", (Object)this.parent.getBooleanText(plot.getShowLabels()));
            this.parent.write(plotName + ".setShowTickLabels({0});\n", (Object)this.parent.getBooleanText(plot.getShowTickLabels()));
            this.parent.write(plotName + ".setShowTickMarks({0});\n", (Object)this.parent.getBooleanText(plot.getShowTickMarks()));
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.parent.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.parent.getIndent(), plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName);
            this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    private void writeBubblePlot(JRBubblePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BubblePlot";
            this.parent.write("JRDesignBubblePlot " + plotName + " = (JRDesignBubblePlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setScaleType({0});\n", (Enum)plot.getScaleType());
            this.writePlot(plot, plotName);
            this.parent.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.parent.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    private void writeLinePlot(JRLinePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "LinePlot";
            this.parent.write("JRDesignLinePlot " + plotName + " = (JRDesignLinePlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setShowLines({0});\n", (Object)this.parent.getBooleanText(plot.getShowLines()));
            this.parent.write(plotName + ".setShowShapes({0});\n", (Object)this.parent.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.parent.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.parent.getIndent(), plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName);
            this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "TimeSeriesPlot";
            this.parent.write("JRDesignTimeSeriesPlot " + plotName + " = (JRDesignTimeSeriesPlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setShowLines({0});\n", (Object)this.parent.getBooleanText(plot.getShowLines()));
            this.parent.write(plotName + ".setShowShapes({0});\n", (Object)this.parent.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.parent.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
            this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    public void writeBar3DPlot(JRBar3DPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "Bar3DPlot";
            this.parent.write("JRDesignBar3DPlot " + plotName + " = (JRDesignBar3DPlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setShowLabels({0});\n", (Object)this.parent.getBooleanText(plot.getShowLabels()));
            this.parent.write(plotName + ".setXOffset({0});\n", plot.getXOffset());
            this.parent.write(plotName + ".setYOffset({0});\n", plot.getYOffset());
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.parent.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.parent.getIndent(), plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName);
            this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    public void writeBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.BAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.BAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeBubbleChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.BUBBLE);\n");
            this.writeChart(chart, chartName);
            this.writeXyzDataset((JRXyzDataset)chart.getDataset(), chartName, "XyzDataset");
            this.writeBubblePlot((JRBubblePlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeStackedBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.STACKEDBAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeStackedBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.STACKEDBAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.LINE);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeTimeSeriesChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.TIMESERIES);\n");
            this.writeChart(chart, chartName);
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset(), chartName, "TimeSeriesDataset");
            this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeHighLowDataset(JRHighLowDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.parent.write("JRDesignHighLowDataset " + datasetName + " = (JRDesignHighLowDataset)" + parentName + ".getDataset();\n");
            this.parent.writeElementDataset((JRElementDataset)dataset, datasetName);
            this.parent.writeExpression(dataset.getSeriesExpression(), datasetName, "SeriesExpression");
            this.parent.writeExpression(dataset.getDateExpression(), datasetName, "DateExpression");
            this.parent.writeExpression(dataset.getHighExpression(), datasetName, "HighExpression");
            this.parent.writeExpression(dataset.getLowExpression(), datasetName, "LowExpression");
            this.parent.writeExpression(dataset.getOpenExpression(), datasetName, "OpenExpression");
            this.parent.writeExpression(dataset.getCloseExpression(), datasetName, "CloseExpression");
            this.parent.writeExpression(dataset.getVolumeExpression(), datasetName, "VolumeExpression");
            this.parent.writeHyperlink(dataset.getItemHyperlink(), datasetName, "ItemHyperlink");
            this.parent.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.parent.flush();
        }
    }

    public void writeHighLowChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.HIGHLOW);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "HighLowPlot";
                this.parent.write("JRDesignHighLowPlot " + plotName + " = (JRDesignHighLowPlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setShowOpenTicks({0});\n", (Object)this.parent.getBooleanText(plot.getShowOpenTicks()));
                this.parent.write(plotName + ".setShowCloseTicks({0});\n", (Object)this.parent.getBooleanText(plot.getShowCloseTicks()));
                this.writePlot(plot, plotName);
                this.parent.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.parent.getIndent(), plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    public void writeGanttChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.GANTT);\n");
            this.writeChart(chart, chartName);
            this.writeGanttDataset((JRGanttDataset)chart.getDataset(), chartName, "GanttDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeCandlestickChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.CANDLESTICK);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "CandlestickPlot";
                this.parent.write("JRDesignCandlestickPlot " + plotName + " = (JRDesignCandlestickPlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setShowVolume({0});\n", (Object)this.parent.getBooleanText(plot.getShowVolume()));
                this.writePlot(plot, plotName);
                this.parent.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.parent.getIndent(), plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    private void writeAreaPlot(JRAreaPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "AreaPlot";
            this.parent.write("JRDesignAreaPlot " + plotName + " = (JRDesignAreaPlot)" + chartName + ".getPlot();\n");
            this.writePlot(plot, plotName);
            this.parent.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.parent.getIndent(), plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName);
            this.parent.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    public void writeAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.AREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    private void writeScatterPlot(JRScatterPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "ScatterPlot";
            this.parent.write("JRDesignScatterPlot " + plotName + " = (JRDesignScatterPlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setShowLines({0});\n", (Object)this.parent.getBooleanText(plot.getShowLines()));
            this.parent.write(plotName + ".setShowShapes({0});\n", (Object)this.parent.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.parent.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.parent.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.parent.getIndent(), plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.parent.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.parent.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.parent.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.parent.flush();
        }
    }

    public void writeScatterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.SCATTER);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeScatterPlot((JRScatterPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeXyAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.XYAREA);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeXyBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.XYBAR);\n");
            this.writeChart(chart, chartName);
            JRChartDataset dataset = chart.getDataset();
            if (dataset.getDatasetType() == 6) {
                this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset, chartName, "TimeSeriesDataset");
            } else if (dataset.getDatasetType() == 5) {
                this.writeTimePeriodDataset((JRTimePeriodDataset)dataset, chartName, "XyDataset");
            } else if (dataset.getDatasetType() == 3) {
                this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            }
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeXyLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.XYLINE);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeMeterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.METER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRMeterPlot plot = (JRMeterPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "MeterPlot";
                this.parent.write("JRDesignMeterPlot " + plotName + " = (JRDesignMeterPlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setShape({0});\n", (Enum)plot.getShape());
                this.parent.write(plotName + ".setMeterAngle({0, number, #});\n", (Object)plot.getMeterAngle());
                this.parent.write(plotName + ".setUnits(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral((String)plot.getUnits()));
                this.parent.write(plotName + ".setTickInterval({0});\n", plot.getTickInterval());
                this.parent.write(plotName + ".setMeterBackgroundColor({0});\n", plot.getMeterBackgroundColor());
                this.parent.write(plotName + ".setNeedleColor({0});\n", plot.getNeedleColor());
                this.parent.write(plotName + ".setTickColor({0});\n", plot.getTickColor());
                this.parent.write(plotName + ".setTickCount({0});\n", (Object)plot.getTickCount());
                this.writePlot(plot, plotName);
                if (plot.getTickLabelFont() != null) {
                    this.parent.write(plotName + ".setTickLabelFont(new JRBaseFont());\n");
                    this.parent.writeFont(plot.getTickLabelFont(), plotName + ".getTickLabelFont()");
                    this.parent.flush();
                }
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                List<JRMeterInterval> intervals = plot.getIntervals();
                if (intervals != null && intervals.size() > 0) {
                    for (int i = 0; i < intervals.size(); ++i) {
                        JRMeterInterval meterInterval = intervals.get(i);
                        this.writeMeterInterval(meterInterval, plotName, plotName + "Interval" + i);
                    }
                }
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    public void writeThermometerChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.THERMOMETER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRThermometerPlot plot = (JRThermometerPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "ThermometerPlot";
                this.parent.write("JRDesignThermometerPlot " + plotName + " = (JRDesignThermometerPlot)" + chartName + ".getPlot();\n");
                this.parent.write(plotName + ".setValueLocation({0});\n", (Enum)plot.getValueLocation());
                this.parent.write(plotName + ".setMercuryColor({0});\n", plot.getMercuryColor());
                this.writePlot(plot, plotName);
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                if (plot.getLowRange() != null) {
                    this.writeDataRange(plot.getLowRange(), plotName, "LowRange");
                }
                if (plot.getMediumRange() != null) {
                    this.writeDataRange(plot.getMediumRange(), plotName, "MediumRange");
                }
                if (plot.getHighRange() != null) {
                    this.writeDataRange(plot.getHighRange(), plotName, "HighRange");
                }
                this.parent.flush();
            }
            this.parent.flush();
        }
    }

    public void writeMultiAxisChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.MULTI_AXIS);\n");
            this.writeChart(chart, chartName);
            JRMultiAxisPlot plot = (JRMultiAxisPlot)chart.getPlot();
            String plotName = chartName + "MultiAxisPlot";
            this.parent.write("JRDesignMultiAxisPlot " + plotName + " = (JRDesignMultiAxisPlot)" + chartName + ".getPlot();\n");
            this.parent.write(plotName + ".setChart(" + chartName + ");\n");
            this.writePlot(chart.getPlot(), plotName);
            List<JRChartAxis> axes = plot.getAxes();
            if (axes != null && axes.size() > 0) {
                for (int i = 0; i < axes.size(); ++i) {
                    JRChartAxis chartAxis = axes.get(i);
                    this.writeChartAxis(chartAxis, plotName, plotName + "Axis" + i, chartName);
                }
            }
            this.parent.flush();
        }
    }

    public void writeStackedAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.parent.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, ChartTypeEnum.STACKEDAREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.parent.flush();
        }
    }

    public void writeChartTag(JRChart chart, String chartName) {
        switch (chart.getChartType()) {
            case AREA: {
                this.writeAreaChart(chart, chartName);
                break;
            }
            case BAR: {
                this.writeBarChart(chart, chartName);
                break;
            }
            case BAR3D: {
                this.writeBar3DChart(chart, chartName);
                break;
            }
            case BUBBLE: {
                this.writeBubbleChart(chart, chartName);
                break;
            }
            case CANDLESTICK: {
                this.writeCandlestickChart(chart, chartName);
                break;
            }
            case HIGHLOW: {
                this.writeHighLowChart(chart, chartName);
                break;
            }
            case LINE: {
                this.writeLineChart(chart, chartName);
                break;
            }
            case METER: {
                this.writeMeterChart(chart, chartName);
                break;
            }
            case MULTI_AXIS: {
                this.writeMultiAxisChart(chart, chartName);
                break;
            }
            case PIE: {
                this.writePieChart(chart, chartName);
                break;
            }
            case PIE3D: {
                this.writePie3DChart(chart, chartName);
                break;
            }
            case SCATTER: {
                this.writeScatterChart(chart, chartName);
                break;
            }
            case STACKEDBAR: {
                this.writeStackedBarChart(chart, chartName);
                break;
            }
            case STACKEDBAR3D: {
                this.writeStackedBar3DChart(chart, chartName);
                break;
            }
            case THERMOMETER: {
                this.writeThermometerChart(chart, chartName);
                break;
            }
            case TIMESERIES: {
                this.writeTimeSeriesChart(chart, chartName);
                break;
            }
            case XYAREA: {
                this.writeXyAreaChart(chart, chartName);
                break;
            }
            case XYBAR: {
                this.writeXyBarChart(chart, chartName);
                break;
            }
            case XYLINE: {
                this.writeXyLineChart(chart, chartName);
                break;
            }
            case STACKEDAREA: {
                this.writeStackedAreaChart(chart, chartName);
                break;
            }
            case GANTT: {
                this.writeGanttChart(chart, chartName);
                break;
            }
            default: {
                throw new JRRuntimeException("charts.chart.type.unsupported", (Object[])null);
            }
        }
    }
}

