/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.fill.ChartsFillObjectFactory;
import net.sf.jasperreports.charts.fill.JRFillChartDataset;
import net.sf.jasperreports.charts.fill.JRFillPieSeries;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;

public class JRFillPieDataset
extends JRFillChartDataset
implements JRPieDataset {
    public static final String EXCEPTION_MESSAGE_KEY_DUPLICATED_KEY = "charts.pie.dataset.duplicated.key";
    public static final String EXCEPTION_MESSAGE_KEY_NULL_KEY = "charts.pie.dataset.null.key";
    protected JRFillPieSeries[] pieSeries;
    private Map<Comparable<?>, Number> values;
    private Map<Comparable<?>, String> labels;
    private Map<Comparable<?>, JRPrintHyperlink> sectionHyperlinks;
    private boolean ignoreDuplicatedKey = false;
    private Comparable<?> otherKey;
    private String otherLabel;
    private JRPrintHyperlink otherSectionHyperlink;

    public JRFillPieDataset(JRPieDataset pieDataset, ChartsFillObjectFactory factory) {
        super(pieDataset, factory.getParent());
        JRPieSeries[] srcPieSeries = pieDataset.getSeries();
        if (srcPieSeries != null && srcPieSeries.length > 0) {
            this.pieSeries = new JRFillPieSeries[srcPieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i] = (JRFillPieSeries)factory.getPieSeries(srcPieSeries[i]);
            }
        }
    }

    @Override
    public Float getMinPercentage() {
        return ((JRPieDataset)this.parent).getMinPercentage();
    }

    @Override
    public void setMinPercentage(Float minPercentage) {
    }

    @Override
    public Integer getMaxCount() {
        return ((JRPieDataset)this.parent).getMaxCount();
    }

    @Override
    public void setMaxCount(Integer maxCount) {
    }

    @Override
    public JRPieSeries[] getSeries() {
        return this.pieSeries;
    }

    @Override
    public JRExpression getOtherKeyExpression() {
        return ((JRPieDataset)this.parent).getOtherKeyExpression();
    }

    @Override
    public JRExpression getOtherLabelExpression() {
        return ((JRPieDataset)this.parent).getOtherLabelExpression();
    }

    @Override
    public JRHyperlink getOtherSectionHyperlink() {
        return ((JRPieDataset)this.parent).getOtherSectionHyperlink();
    }

    protected void customInitialize() {
        this.values = new LinkedHashMap();
        this.labels = new HashMap();
        this.sectionHyperlinks = new HashMap();
        this.ignoreDuplicatedKey = this.getFiller().getPropertiesUtil().getBooleanProperty((JRPropertiesHolder)this.getFillDataset(), "net.sf.jasperreports.chart.pie.ignore.duplicated.key", false);
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.pieSeries != null && this.pieSeries.length > 0) {
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i].evaluate(calculator);
            }
        }
        this.otherKey = (String)calculator.evaluate(this.getOtherKeyExpression());
        this.otherLabel = (String)calculator.evaluate(this.getOtherLabelExpression());
        if (!JRHyperlinkHelper.isEmpty((JRHyperlink)this.getOtherSectionHyperlink())) {
            this.evaluateOtherSectionHyperlink(calculator);
        }
    }

    protected void evaluateOtherSectionHyperlink(JRCalculator calculator) throws JRExpressionEvalException {
        try {
            this.otherSectionHyperlink = JRFillHyperlinkHelper.evaluateHyperlink((JRHyperlink)this.getOtherSectionHyperlink(), (JRFillExpressionEvaluator)calculator, (byte)3);
        }
        catch (JRExpressionEvalException e) {
            throw e;
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected void customIncrement() {
        if (this.pieSeries != null && this.pieSeries.length > 0) {
            for (int i = 0; i < this.pieSeries.length; ++i) {
                JRFillPieSeries crtPieSeries = this.pieSeries[i];
                Comparable<?> key = crtPieSeries.getKey();
                if (key == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NULL_KEY, (Object[])null);
                }
                if (!this.ignoreDuplicatedKey && this.values.containsKey(key)) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DUPLICATED_KEY, new Object[]{key});
                }
                this.values.put(key, crtPieSeries.getValue());
                if (crtPieSeries.getLabelExpression() != null) {
                    this.labels.put(key, crtPieSeries.getLabel());
                }
                if (!crtPieSeries.hasSectionHyperlinks()) continue;
                this.sectionHyperlinks.put(key, crtPieSeries.getPrintSectionHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        double total = 0.0;
        ArrayList<Double> sortedValues = new ArrayList<Double>();
        for (Number nv : this.values.values()) {
            double dvalue = nv.doubleValue();
            total += dvalue;
            sortedValues.add(dvalue);
        }
        Collections.sort(sortedValues);
        Double minValue = null;
        if (this.getMinPercentage() != null && this.getMinPercentage().intValue() >= 0 && this.getMinPercentage().intValue() <= 100) {
            minValue = (double)this.getMinPercentage().floatValue() * total / 100.0;
        }
        if (this.getMaxCount() != null && this.getMaxCount() >= 0 && this.getMaxCount() <= this.values.size()) {
            Double minValue2 = (Double)sortedValues.get(sortedValues.size() - this.getMaxCount());
            minValue = minValue != null && minValue > minValue2 ? minValue : minValue2;
        }
        int otherCount = 0;
        Comparable<?> lastOtherKey = null;
        Number lastOtherValue = null;
        double otherTotal = 0.0;
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Comparable<?> key : this.values.keySet()) {
            Number value = this.values.get(key);
            if (minValue == null || value.doubleValue() >= minValue) {
                dataset.setValue(key, value);
                continue;
            }
            ++otherCount;
            lastOtherKey = key;
            lastOtherValue = value;
            otherTotal += value.doubleValue();
        }
        if (otherCount == 1) {
            dataset.setValue(lastOtherKey, lastOtherValue);
        } else if (otherCount > 1) {
            this.otherKey = this.otherKey == null ? "Other" : this.otherKey;
            dataset.setValue(this.otherKey, otherTotal);
            this.labels.put(this.otherKey, this.otherLabel);
            if (!JRHyperlinkHelper.isEmpty((JRHyperlink)this.getOtherSectionHyperlink())) {
                this.sectionHyperlinks.put(this.otherKey, this.otherSectionHyperlink);
            }
        }
        return dataset;
    }

    @Override
    public byte getDatasetType() {
        return 1;
    }

    @Override
    public Object getLabelGenerator() {
        JRExpression labelExpression = this.pieSeries != null && this.pieSeries.length > 0 ? this.pieSeries[0].getLabelExpression() : null;
        return labelExpression == null ? null : new PieLabelGenerator(this.labels);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    public Map<Comparable<?>, JRPrintHyperlink> getSectionHyperlinks() {
        return this.sectionHyperlinks;
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }
}

