/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignTimePeriodDataset
extends JRDesignChartDataset
implements JRTimePeriodDataset {
    public static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIODS_SERIES = "timePeriodSeries";
    private List<JRTimePeriodSeries> timePeriodSeriesList = new ArrayList<JRTimePeriodSeries>();

    @JsonCreator
    private JRDesignTimePeriodDataset() {
        this(null);
    }

    public JRDesignTimePeriodDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public JRTimePeriodSeries[] getSeries() {
        JRTimePeriodSeries[] timePeriodSeriesArray = new JRTimePeriodSeries[this.timePeriodSeriesList.size()];
        this.timePeriodSeriesList.toArray(timePeriodSeriesArray);
        return timePeriodSeriesArray;
    }

    @JsonIgnore
    public List<JRTimePeriodSeries> getSeriesList() {
        return this.timePeriodSeriesList;
    }

    @JsonSetter
    private void setSeries(List<JRTimePeriodSeries> series) {
        if (series != null) {
            for (JRTimePeriodSeries s : series) {
                this.addTimePeriodSeries(s);
            }
        }
    }

    public void addTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) {
        this.timePeriodSeriesList.add(timePeriodSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_PERIODS_SERIES, (Object)timePeriodSeries, this.timePeriodSeriesList.size() - 1);
    }

    public void addTimePeriodSeries(int index, JRTimePeriodSeries timePeriodSeries) {
        this.timePeriodSeriesList.add(index, timePeriodSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_TIME_PERIODS_SERIES, (Object)timePeriodSeries, index);
    }

    public JRTimePeriodSeries removeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries) {
        int idx;
        if (timePeriodSeries != null && (idx = this.timePeriodSeriesList.indexOf(timePeriodSeries)) >= 0) {
            this.timePeriodSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_TIME_PERIODS_SERIES, (Object)timePeriodSeries, idx);
        }
        return timePeriodSeries;
    }

    @Override
    public byte getDatasetType() {
        return 5;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignTimePeriodDataset clone = (JRDesignTimePeriodDataset)super.clone();
        clone.timePeriodSeriesList = JRCloneUtils.cloneList(this.timePeriodSeriesList);
        return clone;
    }
}

