/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.charts.design.JRDesignChartDataset;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignPieDataset
extends JRDesignChartDataset
implements JRPieDataset {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_PERCENTAGE = "minPercentage";
    public static final String PROPERTY_MAX_COUNT = "maxCount";
    public static final String PROPERTY_PIE_SERIES = "pieSeries";
    public static final String PROPERTY_KEY_EXPRESSION = "keyExpression";
    public static final String PROPERTY_VALUE_EXPRESSION = "valueExpression";
    public static final String PROPERTY_LABEL_EXPRESSION = "labelExpression";
    public static final String PROPERTY_SECTION_HYPERLINK = "sectionHyperlink";
    public static final String PROPERTY_OTHER_KEY_EXPRESSION = "otherKeyExpression";
    public static final String PROPERTY_OTHER_LABEL_EXPRESSION = "otherLabelExpression";
    public static final String PROPERTY_OTHER_SECTION_HYPERLINK = "otherSectionHyperlink";
    private Float minPercentage;
    private Integer maxCount;
    private List<JRPieSeries> pieSeriesList = new ArrayList<JRPieSeries>();
    protected JRExpression otherKeyExpression;
    protected JRExpression otherLabelExpression;
    private JRHyperlink otherSectionHyperlink;

    @JsonCreator
    private JRDesignPieDataset() {
        this(null);
    }

    public JRDesignPieDataset(JRChartDataset dataset) {
        super(dataset);
    }

    @Override
    public Float getMinPercentage() {
        return this.minPercentage;
    }

    @Override
    public void setMinPercentage(Float minPercentage) {
        Float old = this.minPercentage;
        this.minPercentage = minPercentage;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_PERCENTAGE, (Object)old, (Object)this.minPercentage);
    }

    @Override
    public Integer getMaxCount() {
        return this.maxCount;
    }

    @Override
    public void setMaxCount(Integer maxCount) {
        Integer old = this.maxCount;
        this.maxCount = maxCount;
        this.getEventSupport().firePropertyChange(PROPERTY_MAX_COUNT, (Object)old, (Object)this.maxCount);
    }

    @Override
    public JRPieSeries[] getSeries() {
        JRPieSeries[] pieSeriesArray = new JRPieSeries[this.pieSeriesList.size()];
        this.pieSeriesList.toArray(pieSeriesArray);
        return pieSeriesArray;
    }

    @JsonIgnore
    public List<JRPieSeries> getSeriesList() {
        return this.pieSeriesList;
    }

    @JsonSetter
    private void setSeries(List<JRPieSeries> series) {
        if (series != null) {
            for (JRPieSeries s : series) {
                this.addPieSeries(s);
            }
        }
    }

    public void addPieSeries(JRPieSeries pieSeries) {
        this.pieSeriesList.add(pieSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PIE_SERIES, (Object)pieSeries, this.pieSeriesList.size() - 1);
    }

    public void addPieSeries(int index, JRPieSeries pieSeries) {
        this.pieSeriesList.add(index, pieSeries);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PIE_SERIES, (Object)pieSeries, index);
    }

    public JRPieSeries removePieSeries(JRPieSeries pieSeries) {
        int idx;
        if (pieSeries != null && (idx = this.pieSeriesList.indexOf(pieSeries)) >= 0) {
            this.pieSeriesList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PIE_SERIES, (Object)pieSeries, idx);
        }
        return pieSeries;
    }

    public void setKeyExpression(JRExpression keyExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setKeyExpression(keyExpression);
    }

    public void setValueExpression(JRExpression valueExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setValueExpression(valueExpression);
    }

    public void setLabelExpression(JRExpression labelExpression) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setLabelExpression(labelExpression);
    }

    public void setSectionHyperlink(JRHyperlink sectionHyperlink) {
        if (this.pieSeriesList.size() == 0) {
            this.addPieSeries(new JRDesignPieSeries());
        }
        ((JRDesignPieSeries)this.pieSeriesList.get(0)).setSectionHyperlink(sectionHyperlink);
    }

    @Override
    public JRExpression getOtherKeyExpression() {
        return this.otherKeyExpression;
    }

    public void setOtherKeyExpression(JRExpression otherKeyExpression) {
        JRExpression old = this.otherKeyExpression;
        this.otherKeyExpression = otherKeyExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_KEY_EXPRESSION, (Object)old, (Object)this.otherKeyExpression);
    }

    @Override
    public JRExpression getOtherLabelExpression() {
        return this.otherLabelExpression;
    }

    public void setOtherLabelExpression(JRExpression otherLabelExpression) {
        JRExpression old = this.otherLabelExpression;
        this.otherLabelExpression = otherLabelExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_LABEL_EXPRESSION, (Object)old, (Object)this.otherLabelExpression);
    }

    @Override
    public JRHyperlink getOtherSectionHyperlink() {
        return this.otherSectionHyperlink;
    }

    public void setOtherSectionHyperlink(JRHyperlink otherSectionHyperlink) {
        JRHyperlink old = this.otherSectionHyperlink;
        this.otherSectionHyperlink = otherSectionHyperlink;
        this.getEventSupport().firePropertyChange(PROPERTY_OTHER_SECTION_HYPERLINK, (Object)old, (Object)this.otherSectionHyperlink);
    }

    @Override
    public byte getDatasetType() {
        return 1;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRDesignPieDataset clone = (JRDesignPieDataset)super.clone();
        clone.pieSeriesList = JRCloneUtils.cloneList(this.pieSeriesList);
        clone.otherKeyExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.otherKeyExpression);
        clone.otherLabelExpression = (JRExpression)JRCloneUtils.nullSafeClone((JRCloneable)this.otherLabelExpression);
        clone.otherSectionHyperlink = (JRHyperlink)JRCloneUtils.nullSafeClone((JRCloneable)this.otherSectionHyperlink);
        return clone;
    }
}

