/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import net.sf.jasperreports.charts.ChartsExpressionCollector;
import net.sf.jasperreports.charts.JRChartDataset;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.base.JRBaseChartDataset;
import net.sf.jasperreports.charts.design.ChartsVerifier;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;

public class JRBaseGanttDataset
extends JRBaseChartDataset
implements JRGanttDataset {
    private static final long serialVersionUID = 10200L;
    protected JRGanttSeries[] ganttSeries;

    public JRBaseGanttDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBaseGanttDataset(JRGanttDataset dataset, ChartsBaseObjectFactory factory) {
        super(dataset, factory);
        JRGanttSeries[] srcGanttSeries = dataset.getSeries();
        if (srcGanttSeries != null && srcGanttSeries.length > 0) {
            this.ganttSeries = new JRGanttSeries[srcGanttSeries.length];
            for (int i = 0; i < this.ganttSeries.length; ++i) {
                this.ganttSeries[i] = factory.getGanttSeries(srcGanttSeries[i]);
            }
        }
    }

    @Override
    public JRGanttSeries[] getSeries() {
        return this.ganttSeries;
    }

    @Override
    public byte getDatasetType() {
        return 9;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect((JRElementDataset)this);
    }

    @Override
    public void collectExpressions(ChartsExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(ChartsVerifier verifier) {
        verifier.verify(this);
    }
}

