/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.base.ChartsBaseObjectFactory;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.charts.util.ChartsStyleResolver;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_BACKCOLOR = "backcolor";
    public static final String PROPERTY_BACKGROUND_ALPHA = "backgroundAlpha";
    public static final String PROPERTY_FOREGROUND_ALPHA = "foregroundAlpha";
    public static final String PROPERTY_LABEL_ROTATION = "labelRotation";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final String PROPERTY_SERIES_COLORS = "seriesColors";
    protected JRChart chart;
    protected Color backcolor;
    protected PlotOrientationEnum orientation;
    protected Float backgroundAlpha;
    protected Float foregroundAlpha;
    protected Double labelRotation;
    protected SortedSet<JRChartPlot.JRSeriesColor> seriesColors;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseChartPlot(JRChartPlot plot, JRChart chart) {
        this.chart = chart;
        if (plot != null) {
            this.backcolor = plot.getOwnBackcolor();
            this.orientation = plot.getOrientation();
            this.backgroundAlpha = plot.getBackgroundAlpha();
            this.foregroundAlpha = plot.getForegroundAlpha();
            this.labelRotation = plot.getLabelRotation();
            this.seriesColors = new TreeSet<JRChartPlot.JRSeriesColor>(plot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet<JRChartPlot.JRSeriesColor>();
        }
    }

    @JsonIgnore
    private void setType(String type) {
        throw new UnsupportedOperationException();
    }

    protected JRBaseChartPlot(JRChartPlot plot, ChartsBaseObjectFactory factory) {
        JRBaseObjectFactory parentFactory = factory.getParent();
        parentFactory.put((Object)plot, (Object)this);
        this.chart = (JRChart)parentFactory.getVisitResult((JRVisitable)plot.getChart());
        this.backcolor = plot.getOwnBackcolor();
        this.orientation = plot.getOrientation();
        this.backgroundAlpha = plot.getBackgroundAlpha();
        this.foregroundAlpha = plot.getForegroundAlpha();
        this.labelRotation = plot.getLabelRotation();
        this.seriesColors = new TreeSet<JRChartPlot.JRSeriesColor>(plot.getSeriesColors());
    }

    protected ChartsStyleResolver getStyleResolver() {
        return this.getChart().getChartsStyleResolver();
    }

    @Override
    public JRChart getChart() {
        return this.chart;
    }

    @Override
    public Color getBackcolor() {
        return this.getStyleResolver().getBackcolor(this);
    }

    @Override
    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKCOLOR, (Object)old, (Object)this.backcolor);
    }

    @Override
    public PlotOrientationEnum getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(PlotOrientationEnum orientation) {
        PlotOrientationEnum old = this.orientation;
        this.orientation = orientation;
        this.getEventSupport().firePropertyChange(PROPERTY_ORIENTATION, (Object)old, (Object)this.orientation);
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    @Override
    public void setBackgroundAlpha(Float backgroundAlpha) {
        Float old = this.backgroundAlpha;
        this.backgroundAlpha = backgroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_BACKGROUND_ALPHA, (Object)old, (Object)this.backgroundAlpha);
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    @Override
    public void setForegroundAlpha(Float foregroundAlpha) {
        Float old = this.foregroundAlpha;
        this.foregroundAlpha = foregroundAlpha;
        this.getEventSupport().firePropertyChange(PROPERTY_FOREGROUND_ALPHA, (Object)old, (Object)this.foregroundAlpha);
    }

    @Override
    public Double getLabelRotation() {
        return this.labelRotation;
    }

    @Override
    public void setLabelRotation(Double labelRotation) {
        Double old = this.labelRotation;
        this.labelRotation = labelRotation;
        this.getEventSupport().firePropertyChange(PROPERTY_LABEL_ROTATION, (Object)old, (Object)this.labelRotation);
    }

    @Override
    public SortedSet<JRChartPlot.JRSeriesColor> getSeriesColors() {
        return this.seriesColors;
    }

    @Override
    public void clearSeriesColors() {
        this.setSeriesColors(null);
    }

    @Override
    public void addSeriesColor(JRChartPlot.JRSeriesColor seriesColor) {
        this.seriesColors.add(seriesColor);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_SERIES_COLORS, (Object)seriesColor, this.seriesColors.size() - 1);
    }

    @Override
    public void setSeriesColors(Collection<JRChartPlot.JRSeriesColor> colors) {
        TreeSet<JRChartPlot.JRSeriesColor> old = new TreeSet<JRChartPlot.JRSeriesColor>(this.seriesColors);
        this.seriesColors.clear();
        if (colors != null) {
            this.seriesColors.addAll(colors);
        }
        this.getEventSupport().firePropertyChange(PROPERTY_SERIES_COLORS, old, this.seriesColors);
    }

    public Object clone() {
        JRBaseChartPlot clone = null;
        try {
            clone = (JRBaseChartPlot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        if (this.seriesColors != null) {
            clone.seriesColors = new TreeSet<JRChartPlot.JRSeriesColor>();
            Iterator it = this.seriesColors.iterator();
            while (it.hasNext()) {
                clone.seriesColors.add((JRChartPlot.JRSeriesColor)JRCloneUtils.nullSafeClone((JRCloneable)((JRChartPlot.JRSeriesColor)it.next())));
            }
        }
        return clone;
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseChartPlot clone = (JRBaseChartPlot)this.clone();
        clone.chart = parentChart;
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseChartPlot jRBaseChartPlot = this;
        synchronized (jRBaseChartPlot) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable<JRBaseSeriesColor> {
        private static final long serialVersionUID = 10200L;
        protected int seriesOrder = -1;
        protected Color color;

        @JsonCreator
        public JRBaseSeriesColor(@JsonProperty(value="order") int seriesOrder, @JsonProperty(value="color") Color color) {
            this.seriesOrder = seriesOrder;
            this.color = color;
        }

        @Override
        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(JRBaseSeriesColor obj) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            return this.seriesOrder - obj.getSeriesOrder();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
    }
}

