/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TimeZone;
import net.sf.jasperreports.charts.ChartContext;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRChartPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.type.MeterShapeEnum;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.charts.type.ScaleTypeEnum;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.chartthemes.spring.ChartThemesConstants;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.HorizontalAlignment;
import org.jfree.chart.ui.RectangleAnchor;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.ui.VerticalAlignment;
import org.jfree.chart.util.UnitType;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class GenericChartTheme
implements net.sf.jasperreports.charts.ChartTheme {
    protected Map<String, ?> defaultChartPropertiesMap;
    protected Map<String, ?> defaultPlotPropertiesMap;
    protected Map<String, ?> defaultAxisPropertiesMap;
    protected Map<String, ?> defaultChartTypePropertiesMap;
    protected ThreadLocal<ChartContext> threadLocalChartContext = new ThreadLocal();
    protected ThreadLocal<FontUtil> threadLocalFontUtil = new ThreadLocal();

    protected GenericChartTheme() {
    }

    protected ChartContext getChartContext() {
        return this.threadLocalChartContext.get();
    }

    private void setChartContext(ChartContext chartContext) {
        this.threadLocalChartContext.set(chartContext);
        this.threadLocalFontUtil.set(FontUtil.getInstance((JasperReportsContext)chartContext.getJasperReportsContext()));
    }

    private FontUtil getFontUtil() {
        return this.threadLocalFontUtil.get();
    }

    protected JRChart getChart() {
        return this.getChartContext().getChart();
    }

    protected JRChartPlot getPlot() {
        return this.getChart().getPlot();
    }

    protected Dataset getDataset() {
        return this.getChartContext().getDataset();
    }

    protected Object getLabelGenerator() {
        return this.getChartContext().getLabelGenerator();
    }

    protected Locale getLocale() {
        return this.getChartContext().getLocale();
    }

    protected final Object evaluateExpression(JRExpression expression) throws JRException {
        return this.getChartContext().evaluateExpression(expression);
    }

    protected final String evaluateTextExpression(JRExpression expression) throws JRException {
        return this.getChartContext().evaluateTextExpression(expression);
    }

    public JFreeChart createChart(ChartContext chartContext) throws JRException {
        this.setChartContext(chartContext);
        JFreeChart jfreeChart = null;
        switch (this.getChart().getChartType()) {
            case AREA: {
                jfreeChart = this.createAreaChart();
                break;
            }
            case BAR: {
                jfreeChart = this.createBarChart();
                break;
            }
            case BAR3D: {
                jfreeChart = this.createBar3DChart();
                break;
            }
            case BUBBLE: {
                jfreeChart = this.createBubbleChart();
                break;
            }
            case CANDLESTICK: {
                jfreeChart = this.createCandlestickChart();
                break;
            }
            case HIGHLOW: {
                jfreeChart = this.createHighLowChart();
                break;
            }
            case LINE: {
                jfreeChart = this.createLineChart();
                break;
            }
            case METER: {
                jfreeChart = this.createMeterChart();
                break;
            }
            case MULTI_AXIS: {
                break;
            }
            case PIE: {
                jfreeChart = this.createPieChart();
                break;
            }
            case PIE3D: {
                jfreeChart = this.createPie3DChart();
                break;
            }
            case SCATTER: {
                jfreeChart = this.createScatterChart();
                break;
            }
            case STACKEDBAR: {
                jfreeChart = this.createStackedBarChart();
                break;
            }
            case STACKEDBAR3D: {
                jfreeChart = this.createStackedBar3DChart();
                break;
            }
            case THERMOMETER: {
                jfreeChart = this.createThermometerChart();
                break;
            }
            case TIMESERIES: {
                jfreeChart = this.createTimeSeriesChart();
                break;
            }
            case XYAREA: {
                jfreeChart = this.createXyAreaChart();
                break;
            }
            case XYBAR: {
                jfreeChart = this.createXYBarChart();
                break;
            }
            case XYLINE: {
                jfreeChart = this.createXyLineChart();
                break;
            }
            case STACKEDAREA: {
                jfreeChart = this.createStackedAreaChart();
                break;
            }
            case GANTT: {
                jfreeChart = this.createGanttChart();
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + this.getChart().getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot) throws JRException {
        Integer defaultBaseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        this.setChartBackground(jfreeChart);
        this.setChartTitle(jfreeChart, defaultBaseFontSize);
        this.setChartSubtitles(jfreeChart, defaultBaseFontSize);
        this.setChartLegend(jfreeChart, defaultBaseFontSize);
        this.setChartBorder(jfreeChart);
        Boolean isAntiAlias = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "chartAntiAlias");
        if (isAntiAlias != null) {
            jfreeChart.setAntiAlias(isAntiAlias.booleanValue());
        }
        Double padding = (Double)this.getDefaultValue(this.defaultChartPropertiesMap, "chartPadding");
        UnitType unitType = (UnitType)this.getDefaultValue(this.defaultChartPropertiesMap, "unitType");
        if (padding != null && unitType != null) {
            jfreeChart.setPadding(new RectangleInsets(unitType, padding.doubleValue(), padding.doubleValue(), padding.doubleValue(), padding.doubleValue()));
        }
        this.configurePlot(jfreeChart.getPlot(), jrPlot);
    }

    protected void configurePlot(Plot p, JRChartPlot jrPlot) {
        RectangleInsets defaultPlotInsets = (RectangleInsets)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotInsets");
        Paint defaultPlotOutlinePaint = (Paint)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaint");
        Stroke defaultPlotOutlineStroke = (Stroke)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStroke");
        Boolean defaultPlotOutlineVisible = (Boolean)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineVisible");
        if (defaultPlotInsets != null) {
            p.setInsets(defaultPlotInsets);
        }
        if (defaultPlotOutlineVisible != null) {
            if (defaultPlotOutlineVisible.booleanValue()) {
                if (defaultPlotOutlinePaint != null) {
                    p.setOutlinePaint(defaultPlotOutlinePaint);
                }
                if (defaultPlotOutlineStroke != null) {
                    p.setOutlineStroke(defaultPlotOutlineStroke);
                }
                p.setOutlineVisible(true);
            } else {
                p.setOutlineVisible(false);
            }
        }
        this.setPlotBackground(p, jrPlot);
        if (p instanceof CategoryPlot) {
            this.handleCategoryPlotSettings((CategoryPlot)p, jrPlot);
        }
        this.setPlotDrawingDefaults(p, jrPlot);
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Boolean verticalTickLabels, Paint lineColor, boolean isRangeAxis, Comparable<?> axisMinValue, Comparable<?> axisMaxValue) throws JRException {
        Boolean axisVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisVisible");
        if (axisVisible != null && axisVisible.booleanValue()) {
            this.setAxisLine(axis, lineColor);
            Double defaultFixedDimension = (Double)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisFixedDimension");
            if (defaultFixedDimension != null) {
                axis.setFixedDimension(defaultFixedDimension.doubleValue());
            }
            Integer baseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
            this.setAxisLabel(axis, labelFont, labelColor, baseFontSize);
            this.setAxisTickLabels(axis, tickLabelFont, tickLabelColor, tickLabelMask, baseFontSize);
            this.setAxisTickMarks(axis, lineColor);
            String timePeriodUnit = isRangeAxis ? (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTimePeriodUnit") : (String)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTimePeriodUnit");
            this.setAxisBounds(axis, isRangeAxis, timePeriodUnit, axisMinValue, axisMaxValue);
            if (verticalTickLabels != null && axis instanceof ValueAxis) {
                ((ValueAxis)axis).setVerticalTickLabels(verticalTickLabels.booleanValue());
            }
        } else {
            axis.setVisible(false);
        }
    }

    protected JFreeChart createAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        return this.createBarChart();
    }

    protected JFreeChart createBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        Comparable rangeAxisMaxValue = (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), rangeAxisMaxValue);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryRenderer.setDefaultItemLabelsVisible(isShowLabels);
        if (isShowLabels) {
            ValueAxis axis;
            if (rangeAxisMaxValue == null && (axis = categoryPlot.getRangeAxis()) instanceof ValueAxis && !(axis instanceof DateAxis)) {
                float rangeAxisMaxRatio = 1.0f;
                rangeAxisMaxRatio = barPlot.getOrientation() == PlotOrientationEnum.HORIZONTAL ? JRPropertiesUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext()).getFloatProperty((JRPropertiesHolder)this.getChart(), "net.sf.jasperreports.chart.bar.horizontal.range.max.value.ratio", 1.25f) : JRPropertiesUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext()).getFloatProperty((JRPropertiesHolder)this.getChart(), "net.sf.jasperreports.chart.bar.vertical.range.max.value.ratio", 1.1f);
                axis.setUpperBound(axis.getUpperBound() * (double)rangeAxisMaxRatio);
            }
            JRItemLabel itemLabel = barPlot.getItemLabel();
            Integer baseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
            JRFont font = itemLabel != null && itemLabel.getFont() != null ? itemLabel.getFont() : null;
            categoryRenderer.setDefaultItemLabelFont(this.getFont((JRFont)new JRBaseFont((JRStyleContainer)this.getChart(), null), font, baseFontSize));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    categoryRenderer.setDefaultItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    categoryRenderer.setDefaultItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                categoryRenderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                categoryRenderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                categoryRenderer.setDefaultItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression()), (XYZDataset)((XYZDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        ScaleTypeEnum scaleType = bubblePlot.getScaleType() == null ? ScaleTypeEnum.ON_RANGE_AXIS : bubblePlot.getScaleType();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(ChartUtil.getScaleType((ScaleTypeEnum)scaleType).intValue());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisVerticalTickLabels(), bubblePlot.getOwnXAxisLineColor(), false, (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisVerticalTickLabels(), bubblePlot.getOwnYAxisLineColor(), true, (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(bubblePlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateTextExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression()), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        boolean isShowVolume = candlestickPlot.getShowVolume() == null ? true : candlestickPlot.getShowVolume();
        candlestickRenderer.setDrawVolume(isShowVolume);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisVerticalTickLabels(), candlestickPlot.getOwnTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisVerticalTickLabels(), candlestickPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(candlestickPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression()), (String)this.evaluateTextExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression()), (OHLCDataset)((DefaultHighLowDataset)this.getDataset()), (boolean)this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        boolean isShowOpenTicks = highLowPlot.getShowOpenTicks() == null ? false : highLowPlot.getShowOpenTicks();
        boolean isShowCloseTicks = highLowPlot.getShowCloseTicks() == null ? false : highLowPlot.getShowCloseTicks();
        hlRenderer.setDrawOpenTicks(isShowOpenTicks);
        hlRenderer.setDrawCloseTicks(isShowCloseTicks);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisVerticalTickLabels(), highLowPlot.getOwnTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisVerticalTickLabels(), highLowPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(highLowPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createLineChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart freeChart = ChartFactory.createLineChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(freeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)freeChart.getPlot();
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setDefaultShapesVisible(isShowShapes);
        lineRenderer.setDefaultLinesVisible(isShowLines);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        return freeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        return this.createPieChart();
    }

    protected JFreeChart createPieChart() throws JRException {
        boolean isShowLabels;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (PieDataset)((PieDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        JRPiePlot jrPiePlot = (JRPiePlot)this.getPlot();
        boolean isCircular = jrPiePlot.getCircular() == null ? true : jrPiePlot.getCircular();
        piePlot.setCircular(isCircular);
        boolean bl = isShowLabels = jrPiePlot.getShowLabels() == null ? true : jrPiePlot.getShowLabels();
        if (isShowLabels) {
            PieSectionLabelGenerator labelGenerator = (PieSectionLabelGenerator)this.getLabelGenerator();
            JRItemLabel itemLabel = jrPiePlot.getItemLabel();
            if (labelGenerator != null) {
                piePlot.setLabelGenerator(labelGenerator);
            } else if (jrPiePlot.getLabelFormat() != null) {
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPiePlot.getLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
            }
            Integer baseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
            JRFont font = itemLabel != null && itemLabel.getFont() != null ? itemLabel.getFont() : null;
            piePlot.setLabelFont(this.getFont((JRFont)new JRBaseFont((JRStyleContainer)this.getChart(), null), font, baseFontSize));
            if (itemLabel != null && itemLabel.getColor() != null) {
                piePlot.setLabelPaint((Paint)itemLabel.getColor());
            } else {
                piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
            }
            if (itemLabel != null && itemLabel.getBackgroundColor() != null) {
                piePlot.setLabelBackgroundPaint((Paint)itemLabel.getBackgroundColor());
            } else {
                piePlot.setLabelBackgroundPaint((Paint)this.getChart().getBackcolor());
            }
        } else {
            piePlot.setLabelGenerator(null);
        }
        if (jrPiePlot.getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(jrPiePlot.getLegendLabelFormat(), NumberFormat.getNumberInstance(this.getLocale()), NumberFormat.getPercentInstance(this.getLocale())));
        }
        return jfreeChart;
    }

    protected JFreeChart createScatterChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression()), (String)this.evaluateTextExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        boolean isShowLines = scatterPlot.getShowLines() == null ? true : scatterPlot.getShowLines();
        boolean isShowShapes = scatterPlot.getShowShapes() == null ? true : scatterPlot.getShowShapes();
        plotRenderer.setDefaultLinesVisible(isShowLines);
        plotRenderer.setDefaultShapesVisible(isShowShapes);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisVerticalTickLabels(), scatterPlot.getOwnXAxisLineColor(), false, (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisVerticalTickLabels(), scatterPlot.getOwnYAxisLineColor(), true, (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(scatterPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        return this.createStackedBarChart();
    }

    protected JFreeChart createStackedBarChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setDefaultItemLabelsVisible(isShowLabels);
        Comparable rangeAxisMaxValue = (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression());
        if (isShowLabels) {
            ValueAxis axis;
            if (rangeAxisMaxValue == null && (axis = categoryPlot.getRangeAxis()) instanceof ValueAxis && !(axis instanceof DateAxis)) {
                float rangeAxisMaxRatio = 1.0f;
                rangeAxisMaxRatio = barPlot.getOrientation() == PlotOrientationEnum.HORIZONTAL ? JRPropertiesUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext()).getFloatProperty((JRPropertiesHolder)this.getChart(), "net.sf.jasperreports.chart.bar.horizontal.range.max.value.ratio", 1.25f) : JRPropertiesUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext()).getFloatProperty((JRPropertiesHolder)this.getChart(), "net.sf.jasperreports.chart.bar.vertical.range.max.value.ratio", 1.1f);
                axis.setUpperBound(axis.getUpperBound() * (double)rangeAxisMaxRatio);
            }
            JRItemLabel itemLabel = barPlot.getItemLabel();
            categoryRenderer.setDefaultItemLabelFont(this.getFontUtil().getAwtFont(this.getFont(itemLabel == null ? null : itemLabel.getFont()), this.getLocale()));
            if (itemLabel != null) {
                if (itemLabel.getColor() != null) {
                    categoryRenderer.setDefaultItemLabelPaint((Paint)itemLabel.getColor());
                } else {
                    categoryRenderer.setDefaultItemLabelPaint((Paint)this.getChart().getForecolor());
                }
                categoryRenderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
            } else {
                categoryRenderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
                categoryRenderer.setDefaultItemLabelPaint((Paint)this.getChart().getForecolor());
            }
        }
        categoryRenderer.setShadowVisible(false);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), rangeAxisMaxValue);
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (CategoryDataset)((CategoryDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisVerticalTickLabels(), areaPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisVerticalTickLabels(), areaPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(areaPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart() throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset();
        boolean isDate = true;
        if (this.getChart().getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (boolean)isDate, (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (IntervalXYDataset)tmpDataset, (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)this.getPlot().getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYBarRenderer itemRenderer = (XYBarRenderer)xyPlot.getRenderer();
        itemRenderer.setDefaultItemLabelGenerator((XYItemLabelGenerator)this.getLabelGenerator());
        itemRenderer.setShadowVisible(false);
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        itemRenderer.setDefaultItemLabelsVisible(isShowLabels);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(barPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart() throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(linePlot.getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(linePlot.getValueAxisLabelExpression()), (XYDataset)((XYDataset)this.getDataset()), (PlotOrientation)ChartUtil.getPlotOrientation((PlotOrientationEnum)linePlot.getOrientation()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisVerticalTickLabels(), linePlot.getOwnCategoryAxisLineColor(), false, (Comparable)this.evaluateExpression(linePlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisVerticalTickLabels(), linePlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(linePlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(linePlot.getRangeAxisMaxValueExpression()));
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        boolean isShowShapes = linePlot.getShowShapes() == null ? true : linePlot.getShowShapes();
        boolean isShowLines = linePlot.getShowLines() == null ? true : linePlot.getShowLines();
        lineRenderer.setDefaultShapesVisible(isShowShapes);
        lineRenderer.setDefaultLinesVisible(isShowLines);
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart() throws JRException {
        String timeAxisLabel = this.evaluateTextExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression());
        String valueAxisLabel = this.evaluateTextExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression());
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        boolean isShowShapes = timeSeriesPlot.getShowShapes() == null ? true : timeSeriesPlot.getShowShapes();
        boolean isShowLines = timeSeriesPlot.getShowLines() == null ? true : timeSeriesPlot.getShowLines();
        lineRenderer.setDefaultLinesVisible(isShowLines);
        lineRenderer.setDefaultShapesVisible(isShowShapes);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisVerticalTickLabels(), timeSeriesPlot.getOwnTimeAxisLineColor(), false, (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getDomainAxisMaxValueExpression()));
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisVerticalTickLabels(), timeSeriesPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(timeSeriesPlot.getRangeAxisMaxValueExpression()));
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)this.evaluateTextExpression(this.getChart().getTitleExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression()), (String)this.evaluateTextExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression()), (IntervalCategoryDataset)((GanttCategoryDataset)this.getDataset()), (boolean)this.isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot());
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRBarPlot barPlot = (JRBarPlot)this.getPlot();
        boolean isShowTickMarks = barPlot.getShowTickMarks() == null ? true : barPlot.getShowTickMarks();
        boolean isShowTickLabels = barPlot.getShowTickLabels() == null ? true : barPlot.getShowTickLabels();
        boolean isShowLabels = barPlot.getShowLabels() == null ? false : barPlot.getShowLabels();
        categoryPlot.getDomainAxis().setTickMarksVisible(isShowTickMarks);
        categoryPlot.getDomainAxis().setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisVerticalTickLabels(), barPlot.getOwnCategoryAxisLineColor(), false, null, null);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(isShowTickMarks);
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(isShowTickLabels);
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisVerticalTickLabels(), barPlot.getOwnValueAxisLineColor(), true, (Comparable)this.evaluateExpression(barPlot.getRangeAxisMinValueExpression()), (Comparable)this.evaluateExpression(barPlot.getRangeAxisMaxValueExpression()));
        BarRenderer categoryRenderer = (BarRenderer)categoryPlot.getRenderer();
        categoryRenderer.setDefaultItemLabelGenerator((CategoryItemLabelGenerator)this.getLabelGenerator());
        categoryRenderer.setDefaultItemLabelsVisible(isShowLabels);
        categoryRenderer.setShadowVisible(false);
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression());
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression());
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange());
        Color color = interval.getBackgroundColor() != null ? interval.getBackgroundColor() : (Color)ChartThemesConstants.TRANSPARENT_PAINT;
        float[] components = color.getRGBColorComponents(null);
        float alpha = (float)(interval.getAlpha() == null ? 1.0 : interval.getAlpha());
        Color alphaColor = new Color(components[0], components[1], components[2], alpha);
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart() throws JRException {
        List intervals;
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset());
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        MeterShapeEnum shape = jrPlot.getShape() == null ? MeterShapeEnum.PIE : jrPlot.getShape();
        switch (shape) {
            case CHORD: {
                chartPlot.setDialShape(DialShape.CHORD);
                break;
            }
            case CIRCLE: {
                chartPlot.setDialShape(DialShape.CIRCLE);
                break;
            }
            case DIAL: {
                return this.createDialChart();
            }
            default: {
                chartPlot.setDialShape(DialShape.PIE);
            }
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange()));
        int meterAngle = jrPlot.getMeterAngle() == null ? 180 : jrPlot.getMeterAngle();
        chartPlot.setMeterAngle(meterAngle);
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        double tickInterval = jrPlot.getTickInterval() == null ? 10.0 : jrPlot.getTickInterval();
        chartPlot.setTickSize(tickInterval);
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        JRFont tickLabelFont = jrPlot.getTickLabelFont();
        Integer defaultBaseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        Font themeTickLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotTickLabelFont"), tickLabelFont, defaultBaseFontSize);
        chartPlot.setTickLabelFont(themeTickLabelFont);
        chartPlot.setTickLabelFormat(NumberFormat.getInstance(this.getLocale()));
        JRValueDisplay display = jrPlot.getValueDisplay();
        JRFont displayFont = display.getFont();
        Font themeDisplayFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotDisplayFont"), displayFont, defaultBaseFontSize);
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask(), DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(themeDisplayFont);
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            for (JRMeterInterval interval : intervals) {
                if (interval == null) continue;
                chartPlot.addInterval(this.convertInterval(interval));
            }
        }
        JFreeChart jfreeChart = new JFreeChart(this.evaluateTextExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        ChartUtil chartUtil = ChartUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext());
        chartPlot.getRangeAxis().setStandardTickUnits(chartUtil.createIntegerTickUnits(this.getLocale()));
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
            chartPlot.setUseSubrangePaint(false);
        }
        chartPlot.setValueFormat(NumberFormat.getNumberInstance(this.getLocale()));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask(), DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        ValueLocationEnum valueLocation = jrPlot.getValueLocation();
        switch (valueLocation) {
            case NONE: {
                chartPlot.setValueLocation(0);
                break;
            }
            case LEFT: {
                chartPlot.setValueLocation(2);
                break;
            }
            case RIGHT: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart(this.evaluateTextExpression(this.getChart().getTitleExpression()), null, (Plot)chartPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected JFreeChart createDialChart() throws JRException {
        String label;
        JRValueDisplay display;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground((Paint)jrPlot.getBackcolor());
        dialPlot.setBackground((DialLayer)db);
        Range range = this.convertRange(jrPlot.getDataRange());
        int tickCount = jrPlot.getTickCount() != null && jrPlot.getTickCount() > 1 ? jrPlot.getTickCount() : 7;
        StandardDialScale scale = new StandardDialScale(range.getLowerBound(), range.getUpperBound(), 225.0, -270.0, (range.getUpperBound() - range.getLowerBound()) / (double)(tickCount - 1), 15);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        JRFont tickLabelFont = jrPlot.getTickLabelFont();
        Integer defaultBaseFontSize = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "baseFontSize");
        Font themeTickLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotTickLabelFont"), tickLabelFont, defaultBaseFontSize);
        scale.setTickLabelFont(themeTickLabelFont);
        scale.setMajorTickStroke((Stroke)new BasicStroke(1.0f));
        scale.setMinorTickStroke((Stroke)new BasicStroke(0.3f));
        scale.setMajorTickPaint((Paint)jrPlot.getTickColor());
        scale.setMinorTickPaint((Paint)jrPlot.getTickColor());
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        scale.setTickLabelFormatter((NumberFormat)new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(this.getLocale())));
        dialPlot.addScale(0, (DialScale)scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            int colorStep = 0;
            if (size > 0) {
                colorStep = 255 / size;
            }
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange());
                Color color = new Color(255 - colorStep * i, 0 + colorStep * i, 0);
                StandardDialRange dialRange = new StandardDialRange(intervalRange.getLowerBound(), intervalRange.getUpperBound(), (Paint)(interval.getBackgroundColor() == null ? color : interval.getBackgroundColor()));
                dialRange.setInnerRadius(0.41);
                dialRange.setOuterRadius(0.41);
                dialPlot.addLayer((DialLayer)dialRange);
            }
        }
        String string = displayVisibility = (display = jrPlot.getValueDisplay()) != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.value.display.visible") : "false";
        if (Boolean.parseBoolean(displayVisibility)) {
            String pattern;
            DialValueIndicator dvi = new DialValueIndicator(0);
            dvi.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setPaint((Paint)Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat((NumberFormat)new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(this.getLocale())));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            JRFont displayFont = jrPlot.getValueDisplay().getFont();
            Font themeDisplayFont = this.getFont((JRFont)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotDisplayFont"), displayFont, defaultBaseFontSize);
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                dialAnnotation.setFont(themeDisplayFont);
                dialAnnotation.setPaint((Paint)jrPlot.getValueDisplay().getColor());
                dialAnnotation.setRadius(Math.sin(0.7853981633974483) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        DialPointer.Pointer needle = new DialPointer.Pointer();
        needle.setVisible(true);
        needle.setRadius(0.91);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        cap.setOutlinePaint((Paint)Color.GRAY);
        cap.setOutlineStroke((Stroke)new BasicStroke(0.5f));
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart(this.evaluateTextExpression(this.getChart().getTitleExpression()), null, (Plot)dialPlot, this.isShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRChartAxis chartAxis) {
        if (chartAxis.getPosition() != null) {
            switch (chartAxis.getPosition()) {
                case RIGHT_OR_BOTTOM: {
                    return AxisLocation.BOTTOM_OR_RIGHT;
                }
            }
            return AxisLocation.TOP_OR_LEFT;
        }
        return (AxisLocation)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLocation");
    }

    private static RectangleEdge getEdge(EdgeEnum position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case TOP: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case BOTTOM: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case LEFT: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case RIGHT: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }

    protected void populateSeriesColors(Paint[] colors, Paint[] colorSequence) {
        if (colors != null) {
            int size = colorSequence != null ? colorSequence.length : 0;
            System.arraycopy(colorSequence, 0, colors, 0, colorSequence.length);
            System.arraycopy(DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE, 0, colors, size, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length);
        }
    }

    protected void setChartBackground(JFreeChart jfreeChart) {
        Paint defaultBackgroundPaint = (Paint)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundPaint");
        Image defaultBackgroundImage = (Image)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImage");
        Integer defaultBackgroundImageAlignment = (Integer)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImageAlignment");
        Float defaultBackgroundImageAlpha = (Float)this.getDefaultValue(this.defaultChartPropertiesMap, "backgroundImageAlpha");
        if (this.getChart().getOwnMode() != null) {
            if (this.getChart().getOwnMode() == ModeEnum.OPAQUE) {
                if (this.getChart().getOwnBackcolor() == null && defaultBackgroundPaint != null) {
                    jfreeChart.setBackgroundPaint(defaultBackgroundPaint);
                } else {
                    jfreeChart.setBackgroundPaint((Paint)this.getChart().getBackcolor());
                }
                this.setChartBackgroundImage(jfreeChart, defaultBackgroundImage, defaultBackgroundImageAlignment, defaultBackgroundImageAlpha);
            } else {
                jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
                this.setChartBackgroundImage(jfreeChart, defaultBackgroundImage, defaultBackgroundImageAlignment, Float.valueOf(0.0f));
            }
        } else if (defaultBackgroundPaint != null) {
            jfreeChart.setBackgroundPaint(defaultBackgroundPaint);
        }
    }

    protected void setChartBackgroundImage(JFreeChart jfreeChart, Image defaultBackgroundImage, Integer defaultBackgroundImageAlignment, Float defaultBackgroundImageAlpha) {
        if (defaultBackgroundImage != null) {
            jfreeChart.setBackgroundImage(defaultBackgroundImage);
            if (defaultBackgroundImageAlignment != null) {
                jfreeChart.setBackgroundImageAlignment(defaultBackgroundImageAlignment.intValue());
            }
            if (defaultBackgroundImageAlpha != null) {
                jfreeChart.setBackgroundImageAlpha(defaultBackgroundImageAlpha.floatValue());
            }
        }
    }

    protected void setChartTitle(JFreeChart jfreeChart, Integer baseFontSize) {
        Boolean titleVisibility = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "titleVisible");
        if (titleVisibility != null && titleVisibility.booleanValue()) {
            TextTitle title = jfreeChart.getTitle();
            RectangleEdge titleEdge = null;
            if (title != null) {
                Color titleBackcolor;
                Color titleForecolor;
                RectangleInsets titlePadding;
                VerticalAlignment defaultTitleVAlignment;
                JRFont titleFont = this.getChart().getTitleFont();
                Font themeTitleFont = this.getFont((JRFont)this.getDefaultValue(this.defaultChartPropertiesMap, "titleFont"), titleFont, baseFontSize);
                title.setFont(themeTitleFont);
                HorizontalAlignment defaultTitleHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "titleHorizontalAlignment");
                if (defaultTitleHAlignment != null) {
                    title.setHorizontalAlignment(defaultTitleHAlignment);
                }
                if ((defaultTitleVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "titleVerticalAlignment")) != null) {
                    title.setVerticalAlignment(defaultTitleVAlignment);
                }
                RectangleInsets defaultTitlePadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "titlePadding");
                RectangleInsets rectangleInsets = titlePadding = title.getPadding() != null ? title.getPadding() : defaultTitlePadding;
                if (titlePadding != null) {
                    title.setPadding(titlePadding);
                }
                Color color = this.getChart().getOwnTitleColor() != null ? this.getChart().getOwnTitleColor() : (titleForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "titleForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "titleForecolor") : this.getChart().getTitleColor());
                if (titleForecolor != null) {
                    title.setPaint((Paint)titleForecolor);
                }
                if ((titleBackcolor = (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "titleBackcolor")) != null) {
                    title.setBackgroundPaint((Paint)titleBackcolor);
                }
                RectangleEdge defaultTitlePosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "titlePosition");
                titleEdge = GenericChartTheme.getEdge(this.getChart().getTitlePosition(), defaultTitlePosition);
                if (titleEdge != null) {
                    title.setPosition(titleEdge);
                }
            }
        } else {
            TextTitle title = null;
            jfreeChart.setTitle(title);
        }
    }

    protected void setChartSubtitles(JFreeChart jfreeChart, Integer baseFontSize) throws JRException {
        String subtitleText;
        Boolean subtitleVisibility = (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleVisible");
        if (subtitleVisibility != null && subtitleVisibility.booleanValue() && (subtitleText = this.evaluateTextExpression(this.getChart().getSubtitleExpression())) != null) {
            Color subtitleBackcolor;
            Color subtitleForecolor;
            RectangleInsets subtitlePadding;
            VerticalAlignment defaultSubtitleVAlignment;
            TextTitle subtitle = new TextTitle(subtitleText);
            Font themeSubtitleFont = this.getFont((JRFont)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleFont"), this.getChart().getSubtitleFont(), baseFontSize);
            subtitle.setFont(themeSubtitleFont);
            HorizontalAlignment defaultSubtitleHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleHorizontalAlignment");
            if (defaultSubtitleHAlignment != null) {
                subtitle.setHorizontalAlignment(defaultSubtitleHAlignment);
            }
            if ((defaultSubtitleVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleVerticalAlignment")) != null) {
                subtitle.setVerticalAlignment(defaultSubtitleVAlignment);
            }
            RectangleInsets defaultSubtitlePadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitlePadding");
            RectangleInsets rectangleInsets = subtitlePadding = subtitle.getPadding() != null ? subtitle.getPadding() : defaultSubtitlePadding;
            if (subtitlePadding != null) {
                subtitle.setPadding(subtitlePadding);
            }
            Color color = this.getChart().getOwnSubtitleColor() != null ? this.getChart().getOwnSubtitleColor() : (subtitleForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleForecolor") : this.getChart().getSubtitleColor());
            if (subtitleForecolor != null) {
                subtitle.setPaint((Paint)subtitleForecolor);
            }
            Color color2 = subtitleBackcolor = this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBackcolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitleBackcolor") : null;
            if (subtitleBackcolor != null) {
                subtitle.setBackgroundPaint((Paint)subtitleBackcolor);
            }
            RectangleEdge defaultSubtitlePosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "subtitlePosition");
            RectangleEdge subtitleEdge = null;
            subtitleEdge = defaultSubtitlePosition == null ? jfreeChart.getTitle().getPosition() : defaultSubtitlePosition;
            if (subtitleEdge != null) {
                subtitle.setPosition(subtitleEdge);
            }
            jfreeChart.addSubtitle((Title)subtitle);
        }
    }

    protected void setChartLegend(JFreeChart jfreeChart, Integer baseFontSize) {
        LegendTitle legend = jfreeChart.getLegend();
        if (legend != null) {
            RectangleInsets legendPadding;
            VerticalAlignment defaultLegendVAlignment;
            HorizontalAlignment defaultLegendHAlignment;
            BlockFrame frame;
            Color legendBackcolor;
            Color legendForecolor;
            Font themeLegendFont = this.getFont((JRFont)this.getDefaultValue(this.defaultChartPropertiesMap, "legendFont"), this.getChart().getLegendFont(), baseFontSize);
            legend.setItemFont(themeLegendFont);
            Color color = this.getChart().getOwnLegendColor() != null ? this.getChart().getOwnLegendColor() : (legendForecolor = this.getDefaultValue(this.defaultChartPropertiesMap, "legendForecolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "legendForecolor") : this.getChart().getLegendColor());
            if (legendForecolor != null) {
                legend.setItemPaint((Paint)legendForecolor);
            }
            Color color2 = this.getChart().getOwnLegendBackgroundColor() != null ? this.getChart().getOwnLegendBackgroundColor() : (legendBackcolor = this.getDefaultValue(this.defaultChartPropertiesMap, "legendBackcolor") != null ? (Color)this.getDefaultValue(this.defaultChartPropertiesMap, "legendBackcolor") : this.getChart().getLegendBackgroundColor());
            if (legendBackcolor != null) {
                legend.setBackgroundPaint((Paint)legendBackcolor);
            }
            if ((frame = (BlockFrame)this.getDefaultValue(this.defaultChartPropertiesMap, "legendFrame")) != null) {
                legend.setFrame(frame);
            }
            if ((defaultLegendHAlignment = (HorizontalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "legendHorizontalAlignment")) != null) {
                legend.setHorizontalAlignment(defaultLegendHAlignment);
            }
            if ((defaultLegendVAlignment = (VerticalAlignment)this.getDefaultValue(this.defaultChartPropertiesMap, "legendVerticalAlignment")) != null) {
                legend.setVerticalAlignment(defaultLegendVAlignment);
            }
            RectangleInsets defaultLegendPadding = (RectangleInsets)this.getDefaultValue(this.defaultChartPropertiesMap, "legendPadding");
            RectangleInsets rectangleInsets = legendPadding = legend.getPadding() != null ? legend.getPadding() : defaultLegendPadding;
            if (legendPadding != null) {
                legend.setPadding(legendPadding);
            }
            RectangleEdge defaultLegendPosition = (RectangleEdge)this.getDefaultValue(this.defaultChartPropertiesMap, "legendPosition");
            if (GenericChartTheme.getEdge(this.getChart().getLegendPosition(), defaultLegendPosition) != null) {
                legend.setPosition(GenericChartTheme.getEdge(this.getChart().getLegendPosition(), defaultLegendPosition));
            }
        }
    }

    protected void setChartBorder(JFreeChart jfreeChart) {
        JRLineBox lineBox = this.getChart().getLineBox();
        if (lineBox.getLeftPen().getLineWidth().floatValue() == 0.0f && lineBox.getBottomPen().getLineWidth().floatValue() == 0.0f && lineBox.getRightPen().getLineWidth().floatValue() == 0.0f && lineBox.getTopPen().getLineWidth().floatValue() == 0.0f) {
            boolean isVisible;
            boolean bl = isVisible = this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderVisible") == null ? false : (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderVisible");
            if (isVisible) {
                Paint paint;
                BasicStroke stroke = (BasicStroke)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderStroke");
                if (stroke != null) {
                    jfreeChart.setBorderStroke((Stroke)stroke);
                }
                if ((paint = (Paint)this.getDefaultValue(this.defaultChartPropertiesMap, "chartBorderPaint")) != null) {
                    jfreeChart.setBorderPaint(paint);
                }
            }
            jfreeChart.setBorderVisible(isVisible);
        }
    }

    protected void setPlotBackground(Plot p, JRChartPlot jrPlot) {
        Float foregroundAlpha;
        Float backgroundAlpha;
        Paint backgroundPaint;
        Paint defaultBackgroundPaint = (Paint)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundPaint");
        Float defaultBackgroundAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundAlpha");
        Float defaultForegroundAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotForegroundAlpha");
        Image defaultBackgroundImage = (Image)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImage");
        Integer defaultBackgroundImageAlignment = (Integer)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImageAlignment");
        Float defaultBackgroundImageAlpha = (Float)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotBackgroundImageAlpha");
        Paint paint = backgroundPaint = jrPlot.getOwnBackcolor() != null ? jrPlot.getOwnBackcolor() : defaultBackgroundPaint;
        if (backgroundPaint != null) {
            p.setBackgroundPaint(backgroundPaint);
        }
        Float f = backgroundAlpha = jrPlot.getBackgroundAlpha() != null ? jrPlot.getBackgroundAlpha() : defaultBackgroundAlpha;
        if (backgroundAlpha != null) {
            p.setBackgroundAlpha(backgroundAlpha.floatValue());
        }
        Float f2 = foregroundAlpha = jrPlot.getForegroundAlpha() != null ? jrPlot.getForegroundAlpha() : defaultForegroundAlpha;
        if (foregroundAlpha != null) {
            p.setForegroundAlpha(foregroundAlpha.floatValue());
        }
        if (defaultBackgroundImage != null) {
            p.setBackgroundImage(defaultBackgroundImage);
            if (defaultBackgroundImageAlignment != null) {
                p.setBackgroundImageAlignment(defaultBackgroundImageAlignment.intValue());
            }
            if (defaultBackgroundImageAlpha != null) {
                p.setBackgroundImageAlpha(defaultBackgroundImageAlpha.floatValue());
            }
        }
    }

    protected void handleCategoryPlotSettings(CategoryPlot p, JRChartPlot jrPlot) {
        boolean hasRotation;
        Double defaultPlotLabelRotation = (Double)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotLabelRotation");
        PlotOrientation defaultPlotOrientation = (PlotOrientation)this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOrientation");
        CategoryAxis axis = p.getDomainAxis();
        boolean bl = hasRotation = jrPlot.getLabelRotation() != null || defaultPlotLabelRotation != null;
        if (hasRotation) {
            double labelRotation = jrPlot.getLabelRotation() != null ? jrPlot.getLabelRotation() : defaultPlotLabelRotation;
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if (defaultPlotOrientation != null) {
            p.setOrientation(defaultPlotOrientation);
        }
    }

    protected void setPlotDrawingDefaults(Plot p, JRChartPlot jrPlot) {
        List defaultSeriesColors = (List)this.getDefaultValue(this.defaultChartPropertiesMap, "seriesColors");
        Paint[] defaultPlotOutlinePaintSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaintSequence") != null ? (Paint[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlinePaintSequence") : DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE;
        Stroke[] defaultPlotStrokeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotStrokeSequence") != null ? (Stroke[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotStrokeSequence") : DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE;
        Stroke[] defaultPlotOutlineStrokeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStrokeSequence") != null ? (Stroke[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotOutlineStrokeSequence") : DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE;
        Shape[] defaultPlotShapeSequence = this.getDefaultValue(this.defaultPlotPropertiesMap, "plotShapeSequence") != null ? (Shape[])this.getDefaultValue(this.defaultPlotPropertiesMap, "plotShapeSequence") : DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE;
        Paint[] colors = null;
        SortedSet seriesColors = jrPlot.getSeriesColors();
        Paint[] colorSequence = null;
        if (seriesColors != null && seriesColors.size() > 0) {
            int seriesColorsSize = seriesColors.size();
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + seriesColorsSize];
            JRChartPlot.JRSeriesColor[] jrColorSequence = new JRChartPlot.JRSeriesColor[seriesColorsSize];
            seriesColors.toArray(jrColorSequence);
            colorSequence = new Paint[seriesColorsSize];
            for (int i = 0; i < seriesColorsSize; ++i) {
                colorSequence[i] = jrColorSequence[i].getColor();
            }
            this.populateSeriesColors(colors, colorSequence);
        } else if (defaultSeriesColors != null && defaultSeriesColors.size() > 0) {
            colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + defaultSeriesColors.size()];
            colorSequence = new Paint[defaultSeriesColors.size()];
            defaultSeriesColors.toArray(colorSequence);
            this.populateSeriesColors(colors, colorSequence);
        } else {
            colors = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE;
        }
        p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, defaultPlotOutlinePaintSequence, defaultPlotStrokeSequence, defaultPlotOutlineStrokeSequence, defaultPlotShapeSequence));
    }

    protected void setAxisLine(Axis axis, Paint lineColor) {
        Boolean defaultAxisLineVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLineVisible");
        if (defaultAxisLineVisible != null && defaultAxisLineVisible.booleanValue()) {
            Stroke defaultAxisLineStroke;
            Paint linePaint;
            Paint paint = linePaint = lineColor != null ? lineColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLinePaint");
            if (linePaint != null) {
                axis.setAxisLinePaint(linePaint);
            }
            if ((defaultAxisLineStroke = (Stroke)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLineStroke")) != null) {
                axis.setAxisLineStroke(defaultAxisLineStroke);
            }
        }
    }

    protected void setAxisLabel(Axis axis, JRFont labelFont, Paint labelColor, Integer baseFontSize) {
        Boolean defaultAxisLabelVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelVisible");
        if (defaultAxisLabelVisible != null && defaultAxisLabelVisible.booleanValue()) {
            Paint labelPaint;
            Double defaultLabelAngle;
            if (axis.getLabel() == null) {
                axis.setLabel((String)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabel"));
            }
            if ((defaultLabelAngle = (Double)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelAngle")) != null) {
                axis.setLabelAngle(defaultLabelAngle.doubleValue());
            }
            Font themeLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelFont"), labelFont, baseFontSize);
            axis.setLabelFont(themeLabelFont);
            RectangleInsets defaultLabelInsets = (RectangleInsets)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelInsets");
            if (defaultLabelInsets != null) {
                axis.setLabelInsets(defaultLabelInsets);
            }
            Paint paint = labelPaint = labelColor != null ? labelColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisLabelPaint");
            if (labelPaint != null) {
                axis.setLabelPaint(labelPaint);
            }
        }
    }

    protected void setAxisTickLabels(Axis axis, JRFont tickLabelFont, Paint tickLabelColor, String tickLabelMask, Integer baseFontSize) {
        Boolean defaultAxisTickLabelsVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelsVisible");
        if (defaultAxisTickLabelsVisible != null && defaultAxisTickLabelsVisible.booleanValue()) {
            Paint tickLabelPaint;
            Font themeTickLabelFont = this.getFont((JRFont)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelFont"), tickLabelFont, baseFontSize);
            axis.setTickLabelFont(themeTickLabelFont);
            RectangleInsets defaultTickLabelInsets = (RectangleInsets)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelInsets");
            if (defaultTickLabelInsets != null) {
                axis.setTickLabelInsets(defaultTickLabelInsets);
            }
            Paint paint = tickLabelPaint = tickLabelColor != null ? tickLabelColor : (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickLabelPaint");
            if (tickLabelPaint != null) {
                axis.setTickLabelPaint(tickLabelPaint);
            }
            TimeZone timeZone = this.getChartContext().getTimeZone();
            if (axis instanceof DateAxis && timeZone != null) {
                ((DateAxis)axis).setTimeZone(timeZone);
            }
            if (tickLabelMask != null) {
                if (axis instanceof NumberAxis) {
                    NumberFormat fmt = NumberFormat.getInstance(this.getLocale());
                    if (fmt instanceof DecimalFormat) {
                        ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                    }
                    ((NumberAxis)axis).setNumberFormatOverride(fmt);
                } else if (axis instanceof DateAxis) {
                    DateFormat fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3, this.getLocale()) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2, this.getLocale()) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1, this.getLocale()) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0, this.getLocale()) : new SimpleDateFormat(tickLabelMask, this.getLocale()))));
                    if (fmt != null) {
                        if (timeZone != null) {
                            fmt.setTimeZone(timeZone);
                        }
                        ((DateAxis)axis).setDateFormatOverride(fmt);
                    } else {
                        ((DateAxis)axis).setDateFormatOverride(DateFormat.getDateTimeInstance(3, 3, this.getLocale()));
                    }
                }
            }
        }
    }

    protected void setAxisTickMarks(Axis axis, Paint lineColor) {
        Boolean defaultAxisTickMarksVisible = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksVisible");
        if (defaultAxisTickMarksVisible != null && defaultAxisTickMarksVisible.booleanValue()) {
            Stroke defaultTickMarkStroke;
            Paint tickMarkPaint;
            Float defaultAxisTickMarksOutsideLength;
            Float defaultAxisTickMarksInsideLength = (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksInsideLength");
            if (defaultAxisTickMarksInsideLength != null) {
                axis.setTickMarkInsideLength(defaultAxisTickMarksInsideLength.floatValue());
            }
            if ((defaultAxisTickMarksOutsideLength = (Float)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksOutsideLength")) != null) {
                axis.setTickMarkInsideLength(defaultAxisTickMarksOutsideLength.floatValue());
            }
            Paint paint = tickMarkPaint = this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksPaint") != null ? (Paint)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksPaint") : lineColor;
            if (tickMarkPaint != null) {
                axis.setTickMarkPaint(tickMarkPaint);
            }
            if ((defaultTickMarkStroke = (Stroke)this.getDefaultValue(this.defaultAxisPropertiesMap, "axisTickMarksStroke")) != null) {
                axis.setTickMarkStroke(defaultTickMarkStroke);
            }
        }
    }

    protected void setAxisBounds(Axis axis, boolean isRangeAxis, String timePeriodUnit, Comparable<?> minValue, Comparable<?> maxValue) throws JRException {
        if (axis instanceof ValueAxis) {
            if (axis instanceof DateAxis) {
                if (minValue != null) {
                    ((DateAxis)axis).setMinimumDate((Date)minValue);
                }
                if (maxValue != null) {
                    ((DateAxis)axis).setMaximumDate((Date)maxValue);
                }
            } else {
                if (minValue != null) {
                    ((ValueAxis)axis).setLowerBound(((Number)((Object)minValue)).doubleValue());
                }
                if (maxValue != null) {
                    ((ValueAxis)axis).setUpperBound(((Number)((Object)maxValue)).doubleValue());
                }
            }
            this.calculateTickUnits(axis, isRangeAxis, timePeriodUnit);
        }
    }

    protected void calculateTickUnits(Axis axis, boolean isRangeAxis, String timePeriodUnit) {
        Integer tickCount = null;
        Number tickInterval = null;
        boolean axisIntegerUnit = false;
        if (this.getChart().hasProperties()) {
            String tickCountProperty = null;
            String tickIntervalProperty = null;
            String axisIntegerUnitProperty = null;
            if (isRangeAxis) {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tick.count");
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.tick.interval");
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.range.axis.integer.unit");
            } else {
                tickCountProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tick.count");
                tickIntervalProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.tick.interval");
                axisIntegerUnitProperty = this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.domain.axis.integer.unit");
            }
            if (tickCountProperty != null && tickCountProperty.trim().length() > 0) {
                tickCount = Integer.valueOf(tickCountProperty);
            }
            if (tickIntervalProperty != null && tickIntervalProperty.trim().length() > 0) {
                tickInterval = Double.valueOf(tickIntervalProperty);
            }
            if (axisIntegerUnitProperty != null && axisIntegerUnitProperty.trim().length() > 0) {
                axisIntegerUnit = Boolean.valueOf(axisIntegerUnitProperty);
            }
        } else if (isRangeAxis) {
            tickCount = (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTickCount");
            tickInterval = (Number)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisTickInterval");
            if (this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisIntegerUnit") != null) {
                axisIntegerUnit = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "rangeAxisIntegerUnit");
            }
        } else {
            tickCount = (Integer)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTickCount");
            tickInterval = (Number)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisTickInterval");
            if (this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisIntegerUnit") != null) {
                axisIntegerUnit = (Boolean)this.getDefaultValue(this.defaultAxisPropertiesMap, "domainAxisIntegerUnit");
            }
        }
        if (axis instanceof NumberAxis) {
            ChartUtil chartUtil;
            NumberAxis numberAxis = (NumberAxis)axis;
            int axisRange = (int)numberAxis.getRange().getLength();
            if (axisIntegerUnit) {
                chartUtil = ChartUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext());
                numberAxis.setStandardTickUnits(chartUtil.createIntegerTickUnits(this.getLocale()));
                chartUtil.setAutoTickUnit(numberAxis);
            } else if (axisRange > 0) {
                if (tickInterval != null) {
                    if (numberAxis.getNumberFormatOverride() != null) {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), numberAxis.getNumberFormatOverride()));
                    } else {
                        numberAxis.setTickUnit(new NumberTickUnit(tickInterval.doubleValue(), NumberFormat.getNumberInstance(this.getLocale())));
                    }
                } else if (tickCount != null) {
                    int newTickUnitSize = axisRange / tickCount;
                    if ((double)newTickUnitSize > numberAxis.getTickUnit().getSize()) {
                        int tickUnitSize = newTickUnitSize;
                        int i = 1;
                        while (tickUnitSize > 9) {
                            tickUnitSize /= 10;
                            i *= 10;
                        }
                        newTickUnitSize = (tickUnitSize *= i) + i / 2;
                        if (newTickUnitSize > 0 && axisRange / newTickUnitSize > tickCount) {
                            newTickUnitSize += i / 2;
                        }
                        if (numberAxis.getNumberFormatOverride() != null) {
                            numberAxis.setTickUnit(new NumberTickUnit((double)newTickUnitSize, numberAxis.getNumberFormatOverride()));
                        } else {
                            numberAxis.setTickUnit(new NumberTickUnit((double)newTickUnitSize, NumberFormat.getNumberInstance(this.getLocale())));
                        }
                    }
                } else {
                    chartUtil = ChartUtil.getInstance((JasperReportsContext)this.getChartContext().getJasperReportsContext());
                    numberAxis.setStandardTickUnits(chartUtil.createStandardTickUnits(this.getLocale()));
                    chartUtil.setAutoTickUnit(numberAxis);
                }
            }
        }
    }

    protected boolean isShowLegend() {
        Boolean legendVisibility = this.getChart().getShowLegend() == null ? (Boolean)this.getDefaultValue(this.defaultChartPropertiesMap, "legendVisible") : this.getChart().getShowLegend();
        return legendVisibility == null ? false : legendVisibility;
    }

    protected DateTickUnitType getTimePeriodUnit(String timePeriodUnit) {
        if (timePeriodUnit == null) {
            return DateTickUnitType.DAY;
        }
        return timePeriodUnit.equals("Year") ? DateTickUnitType.YEAR : (timePeriodUnit.equals("Month") ? DateTickUnitType.MONTH : (timePeriodUnit.equals("Hour") ? DateTickUnitType.HOUR : (timePeriodUnit.equals("Minute") ? DateTickUnitType.MINUTE : (timePeriodUnit.equals("Second") ? DateTickUnitType.SECOND : (timePeriodUnit.equals("Millisecond") ? DateTickUnitType.MILLISECOND : DateTickUnitType.DAY)))));
    }

    protected Object getDefaultValue(Map<String, ?> map, Object key) {
        return map == null ? null : map.get(key);
    }

    protected Font getFont(JRFont themeFont, JRFont ownFont, Integer baseFontSize) {
        JRBaseFont font = new JRBaseFont();
        if (themeFont != null && themeFont.getFontSize() <= 0.0f && baseFontSize != null && baseFontSize > 0) {
            themeFont.setFontSize(Float.valueOf(baseFontSize.intValue()));
        }
        FontUtil.copyNonNullOwnProperties((JRFont)themeFont, (JRFont)font);
        FontUtil.copyNonNullOwnProperties((JRFont)ownFont, (JRFont)font);
        font = new JRBaseFont((JRStyleContainer)this.getChart(), (JRFont)font);
        return this.getFontUtil().getAwtFont((JRFont)font, this.getLocale());
    }

    protected JRFont getFont(JRFont font) {
        if (font == null) {
            return new JRBaseFont((JRStyleContainer)this.getChart());
        }
        return font;
    }

    public Map<String, ?> getDefaultChartPropertiesMap() {
        return this.defaultChartPropertiesMap;
    }

    public void setDefaultChartPropertiesMap(Map<String, ?> defaultChartPropertiesMap) {
        this.defaultChartPropertiesMap = defaultChartPropertiesMap;
    }

    public Map<String, ?> getDefaultPlotPropertiesMap() {
        return this.defaultPlotPropertiesMap;
    }

    public void setDefaultPlotPropertiesMap(Map<String, ?> defaultPlotPropertiesMap) {
        this.defaultPlotPropertiesMap = defaultPlotPropertiesMap;
    }

    public Map<String, ?> getDefaultAxisPropertiesMap() {
        return this.defaultAxisPropertiesMap;
    }

    public void setDefaultAxisPropertiesMap(Map<String, ?> defaultAxisPropertiesMap) {
        this.defaultAxisPropertiesMap = defaultAxisPropertiesMap;
    }

    public Map<String, ?> getDefaultChartTypePropertiesMap() {
        return this.defaultChartTypePropertiesMap;
    }

    public void setDefaultChartTypePropertiesMap(Map<String, ?> defaultChartTypePropertiesMap) {
        this.defaultChartTypePropertiesMap = defaultChartTypePropertiesMap;
    }
}

