/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple.handlers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseFont;

public class JRFontDeserializer
extends StdDeserializer<JRFont> {
    private static final long serialVersionUID = 1L;

    public JRFontDeserializer() {
        this(null);
    }

    public JRFontDeserializer(Class<?> vc) {
        super(vc);
    }

    public JRFont deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode strikeThroughNode;
        JsonNode underlineNode;
        JsonNode italicNode;
        JsonNode boldNode;
        JsonNode fontSizeNode;
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        JRBaseFont font = new JRBaseFont();
        JsonNode fontNameNode = node.get("font-name");
        if (fontNameNode != null) {
            font.setFontName(fontNameNode.asText());
        }
        if ((fontSizeNode = node.get("font-size")) != null) {
            font.setFontSize(Float.valueOf((float)fontSizeNode.asDouble()));
        }
        if ((boldNode = node.get("bold")) != null) {
            font.setBold(Boolean.valueOf(boldNode.asBoolean()));
        }
        if ((italicNode = node.get("italic")) != null) {
            font.setItalic(Boolean.valueOf(italicNode.asBoolean()));
        }
        if ((underlineNode = node.get("underline")) != null) {
            font.setUnderline(Boolean.valueOf(underlineNode.asBoolean()));
        }
        if ((strikeThroughNode = node.get("strike-through")) != null) {
            font.setStrikeThrough(Boolean.valueOf(strikeThroughNode.asBoolean()));
        }
        return font;
    }
}

