/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers;

import net.sf.jasperreports.charts.JRAbstractChartCustomizer;
import net.sf.jasperreports.charts.JRChart;
import net.sf.jasperreports.customizers.util.CategoryCounter;
import net.sf.jasperreports.customizers.util.CategorySeriesNameProvider;
import net.sf.jasperreports.customizers.util.CustomizerUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LevelRenderer;

public class LevelRenderCustomizer
extends JRAbstractChartCustomizer {
    public static final String PROPERTY_ITEM_MARIGN = "itemMargin";
    public static final String PROPERTY_MAX_ITEM_WIDTH = "maxItemWidth";

    public void customize(JFreeChart jfc, JRChart jrc) {
        CategoryPlot plot;
        CategoryCounter itemsCounter;
        Integer seriesIndex;
        if (jfc.getPlot() instanceof CategoryPlot && (seriesIndex = CustomizerUtil.resolveIndex(this, itemsCounter = new CategoryCounter(plot = (CategoryPlot)jfc.getPlot()), new CategorySeriesNameProvider(plot))) != null) {
            Double maxItemWidth;
            LevelRenderer levelRenderer = new LevelRenderer();
            Double itemMargin = this.getDoubleProperty(PROPERTY_ITEM_MARIGN);
            if (itemMargin != null) {
                levelRenderer.setItemMargin(itemMargin.doubleValue());
            }
            if ((maxItemWidth = this.getDoubleProperty(PROPERTY_MAX_ITEM_WIDTH)) != null) {
                levelRenderer.setMaximumItemWidth(maxItemWidth.doubleValue());
            }
            if (seriesIndex == -1) {
                for (int i = 0; i < itemsCounter.getCount(); ++i) {
                    plot.setRenderer(i, (CategoryItemRenderer)levelRenderer);
                }
            } else {
                plot.setRenderer(seriesIndex.intValue(), (CategoryItemRenderer)levelRenderer);
            }
        }
    }
}

