/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package phat.mobile.adm;

import java.util.Properties;

/**
 *
 * @author pablo
 */
public class TelephonyRegistryChecker {

    static final String PROPERTY_CALL_STATE = "mCallState";
    static final String PROPERTY_CALL_INCOMING_NUMBER = "mCallIncomingNumber";
    private long minTimeToCheck = 100; // 100 ms;

    public enum CALL_STATES {
        IDLE, RINGING, OFFHOOK
    }
    private String avdSerialNumber; // p.e. "emulator-5554"
    private long lastCheck = 0L;
    private Properties telephoyProperties = new Properties();

    public TelephonyRegistryChecker(String avdSerialNumber) {
        this.avdSerialNumber = avdSerialNumber;
    }

    private void checkTelephyRegistryStatus() {
        long cTime = System.currentTimeMillis();

        if (cTime - lastCheck > minTimeToCheck) {
            telephoyProperties.clear();
            AndroidCommandTools.telephonyCallState(avdSerialNumber, telephoyProperties);
            lastCheck = cTime;
        }
    }

    public CALL_STATES getCallState() {
        checkTelephyRegistryStatus();

        String value = telephoyProperties.getProperty(PROPERTY_CALL_STATE);

        /*if (value.equals("0")) {
         return CALL_STATES.IDLE;
         } else*/
        if (value.equals("1")) {
            return CALL_STATES.RINGING;
        } else if (value.equals("2")) {
            return CALL_STATES.OFFHOOK;
        }
        return CALL_STATES.IDLE;
    }

    public String getIncomingPhoneNumber() {
        checkTelephyRegistryStatus();

        return telephoyProperties.getProperty(PROPERTY_CALL_INCOMING_NUMBER);
    }

    public long getMinTimeToCheck() {
        return minTimeToCheck;
    }

    public void setMinTimeToCheck(long minTimeToCheck) {
        this.minTimeToCheck = minTimeToCheck;
    }
}
