/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package phat.mobile.adm;

import com.android.chimpchat.ChimpChat;
import com.android.chimpchat.core.IChimpDevice;
import com.android.chimpchat.core.IChimpImage;
import com.android.chimpchat.core.PhysicalButton;
import com.android.chimpchat.core.TouchPressType;
import com.android.chimpchat.hierarchyviewer.HierarchyViewer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author pablo
 */
public class AVDProxy {

    private static final Logger LOGGER = Logger.getLogger(AVDProxy.class.getName());
    private static final long WAITING_TIME = 300 * 1000;
    private static final int ATTEMPT_NUMBER = 3;

    private static AVDProxy avdProxy;
    private static ChimpChat mChimpchat;
    private static final String ADB = "/platform-tools/adb";

    private final Map<String, IChimpDevice> devices = new HashMap<>();

    public static AVDProxy getInstance() {
        if (avdProxy == null) {
            avdProxy = new AVDProxy();
        }
        return avdProxy;
    }

    private ChimpChat getChimpChat() {
        System.out.println("AVDProxy: getChimpChat...");
        if (mChimpchat == null) {
            // Get value of ANDROID_HOME env variable
            Map<String, String> env = System.getenv();
            String androidHomeLoc = env.get("ANDROID_HOME");
            System.out.println("ANDROID_HOME = " + androidHomeLoc);

            //mChimpchat = ChimpChat.getInstance();
            TreeMap<String, String> options = new TreeMap<String, String>();
            options.put("backend", "adb");
            options.put("adbLocation", androidHomeLoc + ADB);
            mChimpchat = ChimpChat.getInstance(options);
        }
        System.out.println("AVDProxy: ...getChimpChat(" + mChimpchat + ")");
        return mChimpchat;
    }

    public synchronized boolean createDevice(AndroidVirtualDevice avd) {
        System.out.println("AVDProxy: createDevice(" + avd.getAvdName() + "," + avd.getSerialNumber()
                + "," + avd.getSimulatedName() + ")...");
        AndroidCommandTools.launchAVD(avd.getAvdName(), avd.getSerialNumber(), avd.getSimulatedName());
        System.out.println(avd.getSerialNumber() + ": AVD Launched!");

        boolean result = connect(avd);
        System.out.println("AVDProxy: ...createDevice(" + result + ")");
        return result;
    }

    interface RetryFunction {

        public Object run();
    }

    public Object run(RetryFunction rf, int attemptNumber) {
        int count = 0;
        do {
            try {
                return rf.run();
            } catch (RuntimeException re) {
                continue;
            }
        } while (count < attemptNumber);
        return null;
    }

    public synchronized Float getDisplayHeight(final AndroidVirtualDevice avd) {
        return (Float) run(new RetryFunction() {
            @Override
            public Object run() {
                System.out.println("AVDProxy: getDisplayHeight(" + avd.getAvdName() + ")...");
                String height = devices.get(avd.getAvdName()).getProperty("display.height");
                Float result = null;
                if (height != null) {
                    result = Float.parseFloat(height);
                }
                System.out.println("AVDProxy: ...getDisplayHeight(" + result + ")");
                return result;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized Float getDisplayWidth(final AndroidVirtualDevice avd) {
        return (Float) run(new RetryFunction() {
            @Override
            public Object run() {
                System.out.println("AVDProxy: getDisplayWidth(" + avd.getAvdName() + ")...");
                String height = devices.get(avd.getAvdName()).getProperty("display.width");
                Float result = null;
                if (height != null) {
                    result = Float.parseFloat(height);
                }
                System.out.println("AVDProxy: ...getDisplayWidth(" + result + ")");
                return result;
            }
        }, ATTEMPT_NUMBER);
    }

    private boolean connect(AndroidVirtualDevice avd) {
        System.out.println("AVDProxy: connect(" + avd.getAvdName() + ")...");
        mChimpchat = getChimpChat();
        System.out.println("mChimpchat = " + mChimpchat);
        if (mChimpchat == null) {
            return false;
        }
        for (int i = 0; i < 10; i++) {
            System.out.println("AVDProxy: waitForConnection(" + WAITING_TIME + ")...");
            IChimpDevice device = null;
            try {
                device = mChimpchat.waitForConnection(WAITING_TIME, avd.getSerialNumber());
            } catch (RuntimeException scue) {
                System.out.println("ADVProxy: " + scue.getClass().getName());
                System.out.println("ADVProxy: Trying again!");
                continue;
            }
            System.out.println("AVDProxy: ...waitForConnection(" + device + ")");
            if (device != null) {
                devices.put(avd.getAvdName(), device);
                System.out.println("AVDProxy: ...connect(true)");
                return true;
            }
        }
        System.out.println("AVDProxy: ...connect(false)");
        return false;
    }

    public static void shutdown() {
        System.out.println("AVDProxy: shutdown...");
        if (mChimpchat != null) {
            mChimpchat.shutdown();
        }
        System.out.println("AVDProxy: ...shutdown");
    }

    public synchronized void sendConfigFileForService(final AndroidVirtualDevice avd, final String ip, final int port) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                System.out.println("AVDProxy: sendConfigFileForService(" + avd.getAvdName() + "," + ip + "," + port + ")...");
                AndroidCommandTools.createAndPushConfigFile(avd, ip, port);
                System.out.println("AVDProxy: ...sendConfigFileForService()...");
                return null;
            }
        }, ATTEMPT_NUMBER);

    }

    public synchronized void install(final AndroidVirtualDevice avd, final String apkFile) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                System.out.println("AVDProxy: install(" + avd.getAvdName() + "," + apkFile + ")...");
                devices.get(avd.getAvdName()).installPackage(apkFile);
                System.out.println("AVDProxy: ...install()");
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void disconnect(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                devices.get(avd.getAvdName()).dispose();
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void pressBackPhysicalButton(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                devices.get(avd.getAvdName()).press(PhysicalButton.BACK, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized String getFocusedWindowName(final AndroidVirtualDevice avd) {
        HierarchyViewer hv = devices.get(avd.getAvdName()).getHierarchyViewer();
        if (hv != null) {
            return hv.getFocusedWindowName();
        }
        return null;
    }

    public synchronized void pressHomePhysicalButton(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                devices.get(avd.getAvdName()).press(PhysicalButton.HOME, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void pressMenuPhysicalButton(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                devices.get(avd.getAvdName()).press(PhysicalButton.MENU, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void tap(final AndroidVirtualDevice avd, final int x, final int y) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                try {
                    devices.get(avd.getAvdName()).getManager().tap(x, y);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void touch(final AndroidVirtualDevice avd, final int x, final int y) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                try {
                    devices.get(avd.getAvdName()).getManager().touch(x, y);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void touchDown(final AndroidVirtualDevice avd, final int x, final int y) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                try {
                    devices.get(avd.getAvdName()).getManager().touchDown(x, y);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void touchUp(final AndroidVirtualDevice avd, final int x, final int y) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                try {
                    devices.get(avd.getAvdName()).getManager().touchUp(x, y);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void touchMove(final AndroidVirtualDevice avd, final int x, final int y) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                try {
                    devices.get(avd.getAvdName()).getManager().touchMove(x, y);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    /*
     * Despierta al dispositivo
     */
    public synchronized void wake(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                devices.get(avd.getAvdName()).wake();
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    /**
     * Takes a snapshot of the virtual android device
     *
     * @param avd
     * @return
     */
    public synchronized BufferedImage takeSnapshot(final AndroidVirtualDevice avd) {
        return (BufferedImage) run(new RetryFunction() {
            @Override
            public Object run() {
                IChimpImage image = devices.get(avd.getAvdName()).takeSnapshot();
                return image.getBufferedImage();
            }
        }, ATTEMPT_NUMBER);
    }

    /**
     * Desbloquea el dispositivo
     *
     * @param avd
     */
    public synchronized void unlock(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                /**
                 * Perform a drag from one one location to another
                 *
                 * @param startx the x coordinate of the drag's starting point
                 * @param starty the y coordinate of the drag's starting point
                 * @param endx the x coordinate of the drag's end point
                 * @param endy the y coordinate of the drag's end point
                 * @param steps the number of steps to take when interpolating
                 * points
                 * @param ms the duration of the drag
                 */
                devices.get(avd.getAvdName()).drag(240, 650, 450, 650, 10, 500);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    /**
     * Escribe el texto pasado como parámetro en el campo de texto previamente
     * señalado.
     *
     * @param avd
     * @param string
     * @throws IOException
     */
    public synchronized void writeText(final AndroidVirtualDevice avd, final String string) throws IOException {
        run(new RetryFunction() {
            @Override
            public Object run() {
                char[] charSequence = string.toCharArray();
                for (char s : charSequence) {
                    switch (s) {
                        case ' ': {
                            try {
                                devices.get(avd.getAvdName()).getManager().keyDown("KEYCODE_SPACE");
                            } catch (IOException ex) {
                                Logger.getLogger(AVDProxy.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                        break;
                        default:
                            devices.get(avd.getAvdName()).type(String.valueOf(s));
                            break;
                    }
                }
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    /**
     * Realiza el gesto de arrastrar el dedo de izquierda a derecha
     *
     * @param avd
     */
    public synchronized void dragLeftToRight(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                /**
                 * Perform a drag from one one location to another
                 *
                 * @param startx the x coordinate of the drag's starting point
                 * @param starty the y coordinate of the drag's starting point
                 * @param endx the x coordinate of the drag's end point
                 * @param endy the y coordinate of the drag's end point
                 * @param steps the number of steps to take when interpolating
                 * points
                 * @param ms the duration of the drag
                 */
                devices.get(avd.getAvdName()).drag(150, 520, 450, 500, 10, 0);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }
    
    public synchronized void dragRightToLeft(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                /**
                 * Perform a drag from one one location to another
                 *
                 * @param startx the x coordinate of the drag's starting point
                 * @param starty the y coordinate of the drag's starting point
                 * @param endx the x coordinate of the drag's end point
                 * @param endy the y coordinate of the drag's end point
                 * @param steps the number of steps to take when interpolating
                 * points
                 * @param ms the duration of the drag
                 */
                devices.get(avd.getAvdName()).drag(450, 520, 150, 500, 10, 0);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    /**
     * Realiza el gesto de arrastrar el dedo de derecha a izquierda
     *
     * @param avd
     */
    public synchronized void drag(final AndroidVirtualDevice avd, 
            final int startx, final int starty, final int endx, final int endy, 
            final int steps, final int ms) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                /**
                 * Perform a drag from one one location to another
                 *
                 * @param startx the x coordinate of the drag's starting point
                 * @param starty the y coordinate of the drag's starting point
                 * @param endx the x coordinate of the drag's end point
                 * @param endy the y coordinate of the drag's end point
                 * @param steps the number of steps to take when interpolating
                 * points
                 * @param ms the duration of the drag
                 */
                devices.get(avd.getAvdName()).drag(startx, starty, endx, endy, steps, ms);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void startActivity(final AndroidVirtualDevice avd, final String pkg, final String activity) {
        run(new RetryFunction() {
            @Override
            public Object run() {
                System.out.println("AVDProxy: startActivity(" + avd.getAvdName() + "," + pkg + "," + activity + ")...");
                String uri = null;
                String action = "android.intent.action.MAIN";
                String data = null;
                String mimeType = null;
                Collection categories = new ArrayList();
                Map extras = new HashMap();
                //String pkg = "es.um.diic.parkinson";
                //String activity = "ParkinsonActivity";
                String component = pkg + "/." + activity;
                int flags = 0;

                devices.get(avd.getAvdName()).startActivity(uri, action, data, mimeType, categories, extras,
                        component, flags);
                System.out.println("AVDProxy: ...startActivity()");
                return null;
            }
        }, ATTEMPT_NUMBER);
    }

    public synchronized void listProperties(final AndroidVirtualDevice avd) {
        run(new RetryFunction() {
            @Override
            public Object run() {

                String result = "";
                for (String prop : devices.get(avd.getAvdName()).getPropertyList()) {
                    result += prop + ": " + devices.get(avd.getAvdName()).getProperty(prop) + "\n";
                }
                System.out.println(result);
                return null;
            }
        }, ATTEMPT_NUMBER);
    }
}
