/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.adm;

import java.util.Properties;
import phat.mobile.adm.AndroidCommandTools;

public class TelephonyRegistryChecker {
    static final String PROPERTY_CALL_STATE = "mCallState";
    static final String PROPERTY_CALL_INCOMING_NUMBER = "mCallIncomingNumber";
    private long minTimeToCheck = 100L;
    private String avdSerialNumber;
    private long lastCheck = 0L;
    private Properties telephoyProperties = new Properties();

    public TelephonyRegistryChecker(String avdSerialNumber) {
        this.avdSerialNumber = avdSerialNumber;
    }

    private void checkTelephyRegistryStatus() {
        long cTime = System.currentTimeMillis();
        if (cTime - this.lastCheck > this.minTimeToCheck) {
            this.telephoyProperties.clear();
            AndroidCommandTools.telephonyCallState(this.avdSerialNumber, this.telephoyProperties);
            this.lastCheck = cTime;
        }
    }

    public CALL_STATES getCallState() {
        this.checkTelephyRegistryStatus();
        String value = this.telephoyProperties.getProperty(PROPERTY_CALL_STATE);
        if (value.equals("1")) {
            return CALL_STATES.RINGING;
        }
        if (value.equals("2")) {
            return CALL_STATES.OFFHOOK;
        }
        return CALL_STATES.IDLE;
    }

    public String getIncomingPhoneNumber() {
        this.checkTelephyRegistryStatus();
        return this.telephoyProperties.getProperty(PROPERTY_CALL_INCOMING_NUMBER);
    }

    public long getMinTimeToCheck() {
        return this.minTimeToCheck;
    }

    public void setMinTimeToCheck(long minTimeToCheck) {
        this.minTimeToCheck = minTimeToCheck;
    }

    public static enum CALL_STATES {
        IDLE,
        RINGING,
        OFFHOOK;

    }
}

