/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.adm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import phat.mobile.adm.AVDProxy;
import phat.mobile.adm.TelephonyRegistryChecker;

public class AndroidVirtualDevice {
    private String simulatedName;
    private String avdName;
    private String serialNumber;
    private float displayHeight;
    private float displayWidth;
    private String emuOptions = "-dpi-device 240 -scale 0.5 -no-snapshot";
    private TelephonyRegistryChecker telephoyRegistryChecker;

    public static void shutdown() {
        AVDProxy.shutdown();
    }

    public AndroidVirtualDevice(String avdName, String serialNumber, String simulatedName) {
        this.simulatedName = simulatedName;
        this.serialNumber = serialNumber;
        this.avdName = avdName;
        this.telephoyRegistryChecker = new TelephonyRegistryChecker(serialNumber);
        this.createDevice();
    }

    private void createDevice() {
        if (AVDProxy.getInstance().createDevice(this)) {
            this.displayHeight = AVDProxy.getInstance().getDisplayHeight(this).floatValue();
            this.displayWidth = AVDProxy.getInstance().getDisplayWidth(this).floatValue();
        }
    }

    public void sendConfigFileForService(String ip, int port) {
        AVDProxy.getInstance().sendConfigFileForService(this, ip, port);
    }

    public static void main(String[] args) {
        AndroidVirtualDevice smartphone1 = new AndroidVirtualDevice("Nexus_4_API_23", "emulator-5554", "Nexus_4_API_23");
        long t1 = System.currentTimeMillis();
        TelephonyRegistryChecker.CALL_STATES callState = smartphone1.getTelephoyRegistryChecker().getCallState();
        String incomingNumber = smartphone1.getTelephoyRegistryChecker().getIncomingPhoneNumber();
        long t2 = System.currentTimeMillis();
        System.out.println("Time = " + (t2 - t1));
        System.out.println("Call state = " + callState.name());
        System.out.println("Incoming Number = " + incomingNumber);
        smartphone1.disconnect();
        System.exit(0);
    }

    public String getEmuOptions() {
        return this.emuOptions;
    }

    public void setEmuOptions(String emuOptions) {
        this.emuOptions = emuOptions;
    }

    private static void showProperties(AndroidVirtualDevice avd) {
        System.out.println("\n\n\n" + avd.getAvdName() + "::::::::::::::::::::::::::::::::::::::");
        System.out.println("width = " + avd.getDisplayWidth() + ", height = " + avd.getDisplayHeight());
        avd.listProperties();
    }

    public void listProperties() {
        AVDProxy.getInstance().listProperties(this);
    }

    public float getDisplayHeight() {
        return this.displayHeight;
    }

    public float getDisplayWidth() {
        return this.displayWidth;
    }

    public void install(String apkFile) {
        AVDProxy.getInstance().install(this, apkFile);
    }

    public void disconnect() {
        AVDProxy.getInstance().disconnect(this);
    }

    public void pressBackPhysicalButton() {
        AVDProxy.getInstance().pressBackPhysicalButton(this);
    }

    public String getFocusedWindowName() {
        return AVDProxy.getInstance().getFocusedWindowName(this);
    }

    public void pressHomePhysicalButton() {
        AVDProxy.getInstance().pressHomePhysicalButton(this);
    }

    public void pressMenuPhysicalButton() {
        AVDProxy.getInstance().pressMenuPhysicalButton(this);
    }

    public void tap(int x, int y) {
        AVDProxy.getInstance().tap(this, x, y);
    }

    public void touch(int x, int y) {
        AVDProxy.getInstance().touch(this, x, y);
    }

    public void touchDown(int x, int y) {
        AVDProxy.getInstance().touchDown(this, x, y);
    }

    public void touchUp(int x, int y) {
        AVDProxy.getInstance().touchUp(this, x, y);
    }

    public void touchMove(int x, int y) {
        AVDProxy.getInstance().touchMove(this, x, y);
    }

    public void wake() {
        AVDProxy.getInstance().wake(this);
    }

    public BufferedImage takeSnapshot() {
        return AVDProxy.getInstance().takeSnapshot(this);
    }

    public void unlock() {
        AVDProxy.getInstance().unlock(this);
    }

    public void writeText(String string) throws IOException {
        AVDProxy.getInstance().writeText(this, string);
    }

    public void drag(int startx, int starty, int endx, int endy, int steps, int ms) {
        AVDProxy.getInstance().drag(this, startx, starty, endx, endy, steps, ms);
    }

    public void dragLeftToRight() {
        AVDProxy.getInstance().dragLeftToRight(this);
    }

    public void dragRightToLeft() {
        AVDProxy.getInstance().dragRightToLeft(this);
    }

    public void startActivity(String pkg, String activity) {
        AVDProxy.getInstance().startActivity(this, pkg, activity);
    }

    public String getSimulatedName() {
        return this.simulatedName;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public TelephonyRegistryChecker getTelephoyRegistryChecker() {
        return this.telephoyRegistryChecker;
    }
}

