/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.adm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import phat.mobile.adm.AndroidVirtualDevice;

public class AndroidCommandTools {
    private static final int _BOOTING_SECONDS_TIMEOUT = 120;

    public static void createAndPushConfigFile(AndroidVirtualDevice avd, String ip, int port) {
        File file = new File("vapi.props");
        try {
            file.createNewFile();
            PrintWriter writer = new PrintWriter(file);
            writer.println("sms_ip=" + ip);
            writer.println("sms_port=" + port);
            writer.println("deviceName=" + avd.getSimulatedName());
            writer.close();
            AndroidCommandTools.pushFile(avd.getSerialNumber(), file.getAbsolutePath(), "/sdcard/vapi.props");
        }
        catch (IOException e) {
            System.out.println("__________________________________________________________________________________________________________________________________");
            e.printStackTrace();
        }
    }

    public static void pushFile(String avdSerialNumber, String localAbsolutePath, String remoteAbsolutePath) {
        try {
            String so = System.getProperty("os.name");
            String[] command = new String[]{"adb", "-s", avdSerialNumber, "push", localAbsolutePath, remoteAbsolutePath};
            System.out.println();
            System.out.println("adb  -s " + avdSerialNumber + " push " + localAbsolutePath + " " + remoteAbsolutePath);
            System.out.println("OS = " + so);
            Process p = Runtime.getRuntime().exec(command);
            System.out.println(p);
            try {
                p.waitFor();
                int exitValue = p.exitValue();
                System.out.println("WaitFor = " + exitValue);
                BufferedReader reader = exitValue != 0 ? new BufferedReader(new InputStreamReader(p.getErrorStream())) : new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    System.out.println(line);
                    line = reader.readLine();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void telephonyCallState(String avdSerialNumber, Properties store) {
        try {
            String so = System.getProperty("os.name");
            String[] command = new String[]{"adb", "-s", avdSerialNumber, "shell", "dumpsys", "telephony.registry"};
            Process p = Runtime.getRuntime().exec(command);
            try {
                p.waitFor();
                int exitValue = p.exitValue();
                BufferedReader reader = exitValue != 0 ? new BufferedReader(new InputStreamReader(p.getErrorStream())) : new BufferedReader(new InputStreamReader(p.getInputStream()));
                store.load(reader);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static List<String> getAVDSerialNumber() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String so = System.getProperty("os.name");
            String command = "adb devices";
            Process p = null;
            p = so.contains("Windows") ? Runtime.getRuntime().exec("cmd /c " + command) : Runtime.getRuntime().exec(command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                for (String word : line.split("[ |\\t]")) {
                    if (!word.contains("emulator")) continue;
                    result.add(word);
                    break;
                }
                line = reader.readLine();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return result;
    }

    public static void launchAVD(String avdName, String avdSerialNumber) {
        AndroidCommandTools.launchAVD(avdName, avdSerialNumber, "-dpi-device 240 -scale 0.5 -no-snapshot");
    }

    public static void launchAVD(String avdName, String avdSerialNumber, String options) {
        if (AndroidCommandTools.getAVDSerialNumber().contains(avdSerialNumber)) {
            System.out.println("AVD " + avdSerialNumber + " has already launched!");
            return;
        }
        try {
            String port = avdSerialNumber.substring(avdSerialNumber.lastIndexOf("-") + 1);
            String so = System.getProperty("os.name");
            String command = "emulator -port " + port + " " + options + " -avd " + avdName;
            System.out.println(command);
            Process p = null;
            if (so.contains("Windows")) {
                System.out.println("Launching " + avdSerialNumber + " on Windows!");
                p = Runtime.getRuntime().exec("cmd /c " + command);
            } else {
                System.out.println("Launching " + avdSerialNumber + " on Linux!");
                p = Runtime.getRuntime().exec(command + "   -qemu -m 512 -enable-kvm ");
            }
            InputStream istr = p.getInputStream();
            final BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            final BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String s = "";
                    try {
                        while ((s = br.readLine()) != null) {
                            System.out.println(s);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String s = "";
                    try {
                        while ((s = bre.readLine()) != null) {
                            System.err.println(s);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            AndroidCommandTools.waitForDeviceBooting(avdSerialNumber);
            AndroidCommandTools.unlockScreenOfDevice(avdSerialNumber);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static void unlockScreenOfDevice(String avdSerialNumber) {
        try {
            String so = System.getProperty("os.name");
            String command = "adb -s " + avdSerialNumber + "  shell input keyevent 82";
            Process p = null;
            if (so.contains("Windows")) {
                System.out.println("Launching " + avdSerialNumber + " on Windows!");
                p = Runtime.getRuntime().exec("cmd /c " + command);
            } else {
                System.out.println("Launching " + avdSerialNumber + " on Linux!");
                p = Runtime.getRuntime().exec(command);
            }
            InputStream istr = p.getInputStream();
            final BufferedReader br = new BufferedReader(new InputStreamReader(istr));
            final BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String s = "";
                    try {
                        while ((s = br.readLine()) != null) {
                            System.out.println(s);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String s = "";
                    try {
                        while ((s = bre.readLine()) != null) {
                            System.err.println(s);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            p.waitFor();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void waitForDeviceBooting(String serial) {
        try {
            String so = System.getProperty("os.name");
            String command = "adb -s " + serial + " shell getprop init.svc.bootanim ";
            try {
                Process p = null;
                Date initDate = new Date();
                boolean finishedBooting = false;
                do {
                    p = so.contains("Windows") ? Runtime.getRuntime().exec("cmd /c " + command) : Runtime.getRuntime().exec(command);
                    InputStream istr = p.getInputStream();
                    final BufferedReader br = new BufferedReader(new InputStreamReader(istr));
                    final BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    final StringBuffer stdout = new StringBuffer();
                    final StringBuffer stderr = new StringBuffer();
                    Thread t2 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String s = "";
                            try {
                                while ((s = br.readLine()) != null) {
                                    stdout.append(s + "\n");
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    t2.start();
                    Thread t1 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String s = "";
                            try {
                                while ((s = bre.readLine()) != null) {
                                    stderr.append(s + "\n");
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    t1.start();
                    p.waitFor();
                    t2.join();
                    t1.join();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    if (stderr.toString().equalsIgnoreCase("stopped\n")) return;
                    if (stdout.toString().equalsIgnoreCase("stopped\n")) {
                        return;
                    }
                    boolean bl = false;
                    finishedBooting = bl;
                    if (finishedBooting) return;
                } while ((new Date().getTime() - initDate.getTime()) / 1000L < 120L);
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

