/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.adm;

import com.android.chimpchat.ChimpChat;
import com.android.chimpchat.core.IChimpDevice;
import com.android.chimpchat.core.IChimpImage;
import com.android.chimpchat.core.PhysicalButton;
import com.android.chimpchat.core.TouchPressType;
import com.android.chimpchat.hierarchyviewer.HierarchyViewer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import phat.mobile.adm.AndroidCommandTools;
import phat.mobile.adm.AndroidVirtualDevice;

public class AVDProxy {
    private static final Logger LOGGER = Logger.getLogger(AVDProxy.class.getName());
    private static final long WAITING_TIME = 300000L;
    private static final int ATTEMPT_NUMBER = 3;
    private static AVDProxy avdProxy;
    private static ChimpChat mChimpchat;
    private static final String ADB = "/platform-tools/adb";
    private final Map<String, IChimpDevice> devices = new HashMap<String, IChimpDevice>();

    public static AVDProxy getInstance() {
        if (avdProxy == null) {
            avdProxy = new AVDProxy();
        }
        return avdProxy;
    }

    private ChimpChat getChimpChat() {
        System.out.println("AVDProxy: getChimpChat...");
        if (mChimpchat == null) {
            Map<String, String> env = System.getenv();
            String androidHomeLoc = env.get("ANDROID_HOME");
            System.out.println("ANDROID_HOME = " + androidHomeLoc);
            TreeMap<String, String> options = new TreeMap<String, String>();
            options.put("backend", "adb");
            options.put("adbLocation", androidHomeLoc + ADB);
            mChimpchat = ChimpChat.getInstance(options);
        }
        System.out.println("AVDProxy: ...getChimpChat(" + mChimpchat + ")");
        return mChimpchat;
    }

    public synchronized boolean createDevice(AndroidVirtualDevice avd) {
        System.out.println("AVDProxy: createDevice(" + avd.getAvdName() + "," + avd.getSerialNumber() + "," + avd.getSimulatedName() + ")...");
        AndroidCommandTools.launchAVD(avd.getAvdName(), avd.getSerialNumber(), avd.getSimulatedName());
        System.out.println(avd.getSerialNumber() + ": AVD Launched!");
        boolean result = this.connect(avd);
        System.out.println("AVDProxy: ...createDevice(" + result + ")");
        return result;
    }

    public Object run(RetryFunction rf, int attemptNumber) {
        int count = 0;
        while (true) {
            try {
                return rf.run();
            }
            catch (RuntimeException re) {
                if (count < attemptNumber) continue;
                return null;
            }
            break;
        }
    }

    public synchronized Float getDisplayHeight(final AndroidVirtualDevice avd) {
        return (Float)this.run(new RetryFunction(){

            @Override
            public Object run() {
                System.out.println("AVDProxy: getDisplayHeight(" + avd.getAvdName() + ")...");
                String height = ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getProperty("display.height");
                Float result = null;
                if (height != null) {
                    result = Float.valueOf(Float.parseFloat(height));
                }
                System.out.println("AVDProxy: ...getDisplayHeight(" + result + ")");
                return result;
            }
        }, 3);
    }

    public synchronized Float getDisplayWidth(final AndroidVirtualDevice avd) {
        return (Float)this.run(new RetryFunction(){

            @Override
            public Object run() {
                System.out.println("AVDProxy: getDisplayWidth(" + avd.getAvdName() + ")...");
                String height = ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getProperty("display.width");
                Float result = null;
                if (height != null) {
                    result = Float.valueOf(Float.parseFloat(height));
                }
                System.out.println("AVDProxy: ...getDisplayWidth(" + result + ")");
                return result;
            }
        }, 3);
    }

    private boolean connect(AndroidVirtualDevice avd) {
        System.out.println("AVDProxy: connect(" + avd.getAvdName() + ")...");
        mChimpchat = this.getChimpChat();
        System.out.println("mChimpchat = " + mChimpchat);
        if (mChimpchat == null) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            System.out.println("AVDProxy: waitForConnection(300000)...");
            IChimpDevice device = null;
            try {
                device = mChimpchat.waitForConnection(300000L, avd.getSerialNumber());
            }
            catch (RuntimeException scue) {
                System.out.println("ADVProxy: " + scue.getClass().getName());
                System.out.println("ADVProxy: Trying again!");
                continue;
            }
            System.out.println("AVDProxy: ...waitForConnection(" + device + ")");
            if (device == null) continue;
            this.devices.put(avd.getAvdName(), device);
            System.out.println("AVDProxy: ...connect(true)");
            return true;
        }
        System.out.println("AVDProxy: ...connect(false)");
        return false;
    }

    public static void shutdown() {
        System.out.println("AVDProxy: shutdown...");
        if (mChimpchat != null) {
            mChimpchat.shutdown();
        }
        System.out.println("AVDProxy: ...shutdown");
    }

    public synchronized void sendConfigFileForService(final AndroidVirtualDevice avd, final String ip, final int port) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                System.out.println("AVDProxy: sendConfigFileForService(" + avd.getAvdName() + "," + ip + "," + port + ")...");
                AndroidCommandTools.createAndPushConfigFile(avd, ip, port);
                System.out.println("AVDProxy: ...sendConfigFileForService()...");
                return null;
            }
        }, 3);
    }

    public synchronized void install(final AndroidVirtualDevice avd, final String apkFile) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                System.out.println("AVDProxy: install(" + avd.getAvdName() + "," + apkFile + ")...");
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).installPackage(apkFile);
                System.out.println("AVDProxy: ...install()");
                return null;
            }
        }, 3);
    }

    public synchronized void disconnect(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).dispose();
                return null;
            }
        }, 3);
    }

    public synchronized void pressBackPhysicalButton(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).press(PhysicalButton.BACK, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, 3);
    }

    public synchronized String getFocusedWindowName(AndroidVirtualDevice avd) {
        HierarchyViewer hv = this.devices.get(avd.getAvdName()).getHierarchyViewer();
        if (hv != null) {
            return hv.getFocusedWindowName();
        }
        return null;
    }

    public synchronized void pressHomePhysicalButton(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).press(PhysicalButton.HOME, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, 3);
    }

    public synchronized void pressMenuPhysicalButton(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).press(PhysicalButton.MENU, TouchPressType.DOWN_AND_UP);
                return null;
            }
        }, 3);
    }

    public synchronized void tap(final AndroidVirtualDevice avd, final int x, final int y) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                try {
                    ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().tap(x, y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, 3);
    }

    public synchronized void touch(final AndroidVirtualDevice avd, final int x, final int y) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                try {
                    ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().touch(x, y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, 3);
    }

    public synchronized void touchDown(final AndroidVirtualDevice avd, final int x, final int y) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                try {
                    ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().touchDown(x, y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, 3);
    }

    public synchronized void touchUp(final AndroidVirtualDevice avd, final int x, final int y) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                try {
                    ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().touchUp(x, y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, 3);
    }

    public synchronized void touchMove(final AndroidVirtualDevice avd, final int x, final int y) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                try {
                    ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().touchMove(x, y);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }, 3);
    }

    public synchronized void wake(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).wake();
                return null;
            }
        }, 3);
    }

    public synchronized BufferedImage takeSnapshot(final AndroidVirtualDevice avd) {
        return (BufferedImage)this.run(new RetryFunction(){

            @Override
            public Object run() {
                IChimpImage image = ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).takeSnapshot();
                return image.getBufferedImage();
            }
        }, 3);
    }

    public synchronized void unlock(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).drag(240, 650, 450, 650, 10, 500L);
                return null;
            }
        }, 3);
    }

    public synchronized void writeText(final AndroidVirtualDevice avd, final String string) throws IOException {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                char[] charSequence;
                block5: for (char s : charSequence = string.toCharArray()) {
                    switch (s) {
                        case ' ': {
                            try {
                                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getManager().keyDown("KEYCODE_SPACE");
                            }
                            catch (IOException ex) {
                                Logger.getLogger(AVDProxy.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            continue block5;
                        }
                        default: {
                            ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).type(String.valueOf(s));
                        }
                    }
                }
                return null;
            }
        }, 3);
    }

    public synchronized void dragLeftToRight(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).drag(150, 520, 450, 500, 10, 0L);
                return null;
            }
        }, 3);
    }

    public synchronized void dragRightToLeft(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).drag(450, 520, 150, 500, 10, 0L);
                return null;
            }
        }, 3);
    }

    public synchronized void drag(final AndroidVirtualDevice avd, final int startx, final int starty, final int endx, final int endy, final int steps, final int ms) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).drag(startx, starty, endx, endy, steps, (long)ms);
                return null;
            }
        }, 3);
    }

    public synchronized void startActivity(final AndroidVirtualDevice avd, final String pkg, final String activity) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                System.out.println("AVDProxy: startActivity(" + avd.getAvdName() + "," + pkg + "," + activity + ")...");
                String uri = null;
                String action = "android.intent.action.MAIN";
                String data = null;
                String mimeType = null;
                ArrayList categories = new ArrayList();
                HashMap extras = new HashMap();
                String component = pkg + "/." + activity;
                int flags = 0;
                ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).startActivity(uri, action, data, mimeType, categories, extras, component, flags);
                System.out.println("AVDProxy: ...startActivity()");
                return null;
            }
        }, 3);
    }

    public synchronized void listProperties(final AndroidVirtualDevice avd) {
        this.run(new RetryFunction(){

            @Override
            public Object run() {
                String result = "";
                for (String prop : ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getPropertyList()) {
                    result = result + prop + ": " + ((IChimpDevice)AVDProxy.this.devices.get(avd.getAvdName())).getProperty(prop) + "\n";
                }
                System.out.println(result);
                return null;
            }
        }, 3);
    }

    static interface RetryFunction {
        public Object run();
    }
}

