package phat.mobile.adm;

import java.awt.image.BufferedImage;
import java.io.IOException;

public class AndroidVirtualDevice {

    private String simulatedName;
    private String avdName;
    private String serialNumber;
    private float displayHeight;
    private float displayWidth;
    private String emuOptions = "-dpi-device 240 -scale 0.5 -no-snapshot";

    private TelephonyRegistryChecker telephoyRegistryChecker;

    public static void shutdown() {
        AVDProxy.shutdown();
    }

    /**
     * Adaptador para comunicarse con un emulador o dispositivo Android
     *
     * @param avdName	Nombre del dispositivo virtual android que se le da al
     * crearlo
     * @param serialNumber	Nombre identificativo de la instancia del emulador.
     * Es de la forma
     * @param simulatedName Nombre simbólico de la simulación que se usa para
     * obtener los servicios del ServiceManager (serviceSetId).
     */
    public AndroidVirtualDevice(String avdName, String serialNumber, String simulatedName) {
        this.simulatedName = simulatedName;
        this.serialNumber = serialNumber;
        this.avdName = avdName;
        this.telephoyRegistryChecker = new TelephonyRegistryChecker(serialNumber);
        
        createDevice();
    }

    private void createDevice() {
        if(AVDProxy.getInstance().createDevice(this)) {
            displayHeight = AVDProxy.getInstance().getDisplayHeight(this);
            displayWidth = AVDProxy.getInstance().getDisplayWidth(this);
        }
    }
    
    public void sendConfigFileForService(String ip, int port) {
        AVDProxy.getInstance().sendConfigFileForService(this, ip, port);
    }

    public static void main(String[] args) {
        AndroidVirtualDevice smartphone1 = new AndroidVirtualDevice("Nexus_4_API_23", "emulator-5554", "Nexus_4_API_23");
        
        long t1 = System.currentTimeMillis();
        TelephonyRegistryChecker.CALL_STATES callState = smartphone1.getTelephoyRegistryChecker().getCallState();
        String incomingNumber = smartphone1.getTelephoyRegistryChecker().getIncomingPhoneNumber();
        long t2 = System.currentTimeMillis();
        System.out.println("Time = "+(t2-t1));
        System.out.println("Call state = "+callState.name());
        System.out.println("Incoming Number = "+incomingNumber);
        
        smartphone1.disconnect();
        /*for(String name: p.stringPropertyNames()) {
            System.out.println(name+"="+p.getProperty(name));
        }*/
        /*AndroidVirtualDevice smartphone1 = new AndroidVirtualDevice("Smartphone1", "emulator-5554", "Smartphone1");
        AndroidVirtualDevice smartphone2 = new AndroidVirtualDevice("Smartphone2", "emulator-5558", "Smartphone2");
        AndroidVirtualDevice smartphone3 = new AndroidVirtualDevice("Smartphone3", "emulator-5560", "Smartphone3");
        AndroidVirtualDevice smartwatch = new AndroidVirtualDevice("SmartWatch1", "emulator-5556", "SmartWatch1");

        showProperties(smartphone1);
        showProperties(smartphone2);
        showProperties(smartphone3);
        showProperties(smartwatch);

        smartwatch.disconnect();
        System.out.println("Disconnect smartwatch!");

        smartphone1.disconnect();
        System.out.println("Disconnect smartphone1!");

        smartphone2.disconnect();
        System.out.println("Disconnect smartphone2!");

        smartphone3.disconnect();
        System.out.println("Disconnect smartphone3!");
        */
        System.exit(0);
    }

    public String getEmuOptions() {
        return emuOptions;
    }

    public void setEmuOptions(String emuOptions) {
        this.emuOptions = emuOptions;
    }

    private static void showProperties(AndroidVirtualDevice avd) {
        System.out.println("\n\n\n" + avd.getAvdName() + "::::::::::::::::::::::::::::::::::::::");
        System.out.println("width = " + avd.getDisplayWidth() + ", height = " + avd.getDisplayHeight());
        avd.listProperties();
    }

    /**
     * List all properties.
     */
    public void listProperties() {
        AVDProxy.getInstance().listProperties(this);
    }

    public float getDisplayHeight() {
        return displayHeight;
    }

    public float getDisplayWidth() {
        return displayWidth;
    }

    public void install(String apkFile) {
        AVDProxy.getInstance().install(this, apkFile);
    }

    public void disconnect() {
        AVDProxy.getInstance().disconnect(this);
    }

    public void pressBackPhysicalButton() {
        AVDProxy.getInstance().pressBackPhysicalButton(this);
    }

    public String getFocusedWindowName() {
        return  AVDProxy.getInstance().getFocusedWindowName(this);
    }

    public void pressHomePhysicalButton() {
         AVDProxy.getInstance().pressHomePhysicalButton(this);
    }

    public void pressMenuPhysicalButton() {
        AVDProxy.getInstance().pressMenuPhysicalButton(this);
    }

    public void tap(int x, int y) {
         AVDProxy.getInstance().tap(this, x, y);
    }

    public void touch(int x, int y) {
        AVDProxy.getInstance().touch(this, x, y);
    }

    public void touchDown(int x, int y) {
        AVDProxy.getInstance().touchDown(this, x, y);
    }

    public void touchUp(int x, int y) {
        AVDProxy.getInstance().touchUp(this, x, y);
    }

    public void touchMove(int x, int y) {
        AVDProxy.getInstance().touchMove(this, x, y);
    }

    /*
     * Despierta al dispositivo
     */
    public void wake() {
        AVDProxy.getInstance().wake(this);
    }

    /**
     * Takes a snapshot of the virtual android device
     *
     * @return
     */
    public BufferedImage takeSnapshot() {
        return AVDProxy.getInstance().takeSnapshot(this);
    }

    /**
     * Desbloquea el dispositivo
     */
    public void unlock() {
        AVDProxy.getInstance().unlock(this);
    }

    /**
     * Escribe el texto pasado como parámetro en el campo de texto previamente
     * señalado.
     *
     * @param string
     * @throws IOException
     */
    public void writeText(String string) throws IOException {
        AVDProxy.getInstance().writeText(this, string);
    }

    public void drag(final int startx, final int starty, final int endx, final int endy, 
            final int steps, final int ms) {
        AVDProxy.getInstance().drag(this, startx, starty, endx, endy, steps, ms);
    }
    /**
     * Realiza el gesto de arrastrar el dedo de izquierda a derecha
     */
    public void dragLeftToRight() {
        /**
         * Perform a drag from one one location to another
         *
         * @param startx the x coordinate of the drag's starting point
         * @param starty the y coordinate of the drag's starting point
         * @param endx the x coordinate of the drag's end point
         * @param endy the y coordinate of the drag's end point
         * @param steps the number of steps to take when interpolating points
         * @param ms the duration of the drag
         */
        AVDProxy.getInstance().dragLeftToRight(this);
    }

    /**
     * Realiza el gesto de arrastrar el dedo de derecha a izquierda
     */
    public void dragRightToLeft() {
        AVDProxy.getInstance().dragRightToLeft(this);
    }

    public void startActivity(String pkg, String activity) {
        AVDProxy.getInstance().startActivity(this, pkg, activity);
    }

    public String getSimulatedName() {
        return simulatedName;
    }

    public String getAvdName() {
        return avdName;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public TelephonyRegistryChecker getTelephoyRegistryChecker() {
        return telephoyRegistryChecker;
    }
}
