/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.adm;

import com.android.chimpchat.ChimpChat;
import com.android.chimpchat.core.IChimpDevice;
import com.android.chimpchat.core.IChimpImage;
import com.android.chimpchat.core.PhysicalButton;
import com.android.chimpchat.core.TouchPressType;
import com.android.chimpchat.hierarchyviewer.HierarchyViewer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import phat.mobile.adm.AndroidCommandTools;

public class AndroidVirtualDevice {
    private static ChimpChat mChimpchat;
    private IChimpDevice device;
    private String simulatedName;
    private String avdName;
    private String serialNumber;
    private float displayHeight;
    private float displayWidth;
    private static final String ADB = "/platform-tools/adb";

    private static ChimpChat getChimpChat() {
        if (mChimpchat == null) {
            Map<String, String> env = System.getenv();
            String androidHomeLoc = env.get("ANDROID_HOME");
            System.out.println("ANDROID_HOME = " + androidHomeLoc);
            TreeMap<String, String> options = new TreeMap<String, String>();
            options.put("backend", "adb");
            options.put("adbLocation", androidHomeLoc + ADB);
            mChimpchat = ChimpChat.getInstance(options);
        }
        return mChimpchat;
    }

    public AndroidVirtualDevice(String avdName, String serialNumber, String simulatedName) {
        this.simulatedName = simulatedName;
        this.serialNumber = serialNumber;
        this.avdName = avdName;
        System.out.println("AndroidVirtualDevice(" + avdName + "," + serialNumber + "," + simulatedName + ")");
        AndroidCommandTools.launchAVD(avdName, serialNumber);
        System.out.println(serialNumber + ": AVD Launched!");
        System.out.print(serialNumber + ": Connect...");
        boolean connected = this.connect();
        if (connected) {
            String height = this.device.getProperty("display.height");
            System.out.println("display.heiht:" + height);
            if (height != null) {
                this.displayHeight = Float.parseFloat(height);
            }
            String width = this.device.getProperty("display.width");
            System.out.println("display.width:" + width);
            if (width != null) {
                this.displayWidth = Float.parseFloat(width);
            }
        }
        System.out.println(" Done! " + connected);
    }

    public void sendConfigFileForService(String ip, int port) {
        System.out.print(this.serialNumber + ": Sending " + "vapi.props" + " file...");
        AndroidCommandTools.createAndPushConfigFile(this, ip, port);
        System.out.println("Done!");
    }

    public static void main(String[] args) {
        AndroidVirtualDevice smartphone1 = new AndroidVirtualDevice("Smartphone1", "emulator-5554", "Smartphone1");
        AndroidVirtualDevice smartphone2 = new AndroidVirtualDevice("Smartphone2", "emulator-5558", "Smartphone2");
        AndroidVirtualDevice smartphone3 = new AndroidVirtualDevice("Smartphone3", "emulator-5560", "Smartphone3");
        AndroidVirtualDevice smartwatch = new AndroidVirtualDevice("SmartWatch1", "emulator-5556", "SmartWatch1");
        AndroidVirtualDevice.showProperties(smartphone1);
        AndroidVirtualDevice.showProperties(smartphone2);
        AndroidVirtualDevice.showProperties(smartphone3);
        AndroidVirtualDevice.showProperties(smartwatch);
        smartwatch.disconnect();
        System.out.println("Disconnect smartwatch!");
        smartphone1.disconnect();
        System.out.println("Disconnect smartphone1!");
        smartphone2.disconnect();
        System.out.println("Disconnect smartphone2!");
        smartphone3.disconnect();
        System.out.println("Disconnect smartphone3!");
        System.exit(0);
    }

    private static void showProperties(AndroidVirtualDevice avd) {
        System.out.println("\n\n\n" + avd.getAvdName() + "::::::::::::::::::::::::::::::::::::::");
        System.out.println("width = " + avd.getDisplayWidth() + ", height = " + avd.getDisplayHeight());
        avd.listProperties();
    }

    public void listProperties() {
        if (this.device == null) {
            throw new IllegalStateException("init() must be called first.");
        }
        String result = "";
        for (String prop : this.device.getPropertyList()) {
            result = result + prop + ": " + this.device.getProperty(prop) + "\n";
        }
        System.out.println(result);
    }

    public float getDisplayHeight() {
        return this.displayHeight;
    }

    public float getDisplayWidth() {
        return this.displayWidth;
    }

    public boolean connect() {
        System.out.println("connect()");
        mChimpchat = AndroidVirtualDevice.getChimpChat();
        System.out.println("mChimpchat = " + mChimpchat);
        if (mChimpchat == null) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            this.device = mChimpchat.waitForConnection(30000L, this.serialNumber);
            if (this.device == null) continue;
            return true;
        }
        return false;
    }

    public void install(String apkFile) {
        this.device.installPackage(apkFile);
    }

    public void disconnect() {
        this.device.dispose();
    }

    public void pressBackPhysicalButton() {
        this.device.press(PhysicalButton.BACK, TouchPressType.DOWN_AND_UP);
    }

    public String getFocusedWindowName() {
        HierarchyViewer hv = this.device.getHierarchyViewer();
        if (hv != null) {
            return hv.getFocusedWindowName();
        }
        return null;
    }

    public void pressHomePhysicalButton() {
        this.device.press(PhysicalButton.HOME, TouchPressType.DOWN_AND_UP);
    }

    public void pressMenuPhysicalButton() {
        this.device.press(PhysicalButton.MENU, TouchPressType.DOWN_AND_UP);
    }

    public void tap(int x, int y) {
        try {
            this.device.getManager().tap(x, y);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void touch(int x, int y) {
        try {
            this.device.getManager().touch(x, y);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void touchDown(int x, int y) {
        try {
            this.device.getManager().touchDown(x, y);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void touchUp(int x, int y) {
        try {
            this.device.getManager().touchUp(x, y);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void touchMove(int x, int y) {
        try {
            this.device.getManager().touchMove(x, y);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void wake() {
        this.device.wake();
    }

    public BufferedImage takeSnapshot() {
        IChimpImage image = this.device.takeSnapshot();
        return image.getBufferedImage();
    }

    public void unlock() {
        this.device.drag(240, 650, 450, 650, 10, 500L);
    }

    public void writeText(String string) throws IOException {
        char[] charSequence;
        block3: for (char s : charSequence = string.toCharArray()) {
            switch (s) {
                case ' ': {
                    this.device.getManager().keyDown("KEYCODE_SPACE");
                    continue block3;
                }
                default: {
                    this.device.type(String.valueOf(s));
                }
            }
        }
    }

    public void dragLeftToRight() {
        this.device.drag(150, 520, 450, 500, 10, 0L);
    }

    public void dragRightToLeft() {
        this.device.drag(450, 520, 150, 500, 10, 0L);
    }

    public void startActivity(String pkg, String activity) {
        String uri = null;
        String action = "android.intent.action.MAIN";
        String data = null;
        String mimeType = null;
        ArrayList categories = new ArrayList();
        HashMap extras = new HashMap();
        String component = pkg + "/." + activity;
        int flags = 0;
        this.device.startActivity(uri, action, data, mimeType, categories, extras, component, flags);
    }

    public String getSimulatedName() {
        return this.simulatedName;
    }

    public String getAvdName() {
        return this.avdName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }
}

