/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.renderer;

import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import net.sf.ghost4j.AbstractRemoteComponent;
import net.sf.ghost4j.display.PageRaster;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import net.sf.ghost4j.renderer.RemoteRenderer;
import net.sf.ghost4j.renderer.RendererException;
import net.sf.ghost4j.util.ImageUtil;
import net.sf.ghost4j.util.JavaFork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteRenderer
extends AbstractRemoteComponent
implements RemoteRenderer {
    protected abstract List<PageRaster> run(Document var1, int var2, int var3) throws IOException, RendererException, DocumentException;

    protected static void startRemoteRenderer(RemoteRenderer remoteRenderer) throws RendererException {
        try {
            if (System.getenv("cajo.port") == null) {
                throw new RendererException("No Cajo port defined for remote renderer");
            }
            int cajoPort = Integer.parseInt(System.getenv("cajo.port"));
            RemoteRenderer rendererCopy = (RemoteRenderer)remoteRenderer.getClass().newInstance();
            rendererCopy.setMaxProcessCount(0);
            Remote.config(null, cajoPort, null, 0);
            ItemServer.bind(rendererCopy, RemoteRenderer.class.getCanonicalName());
        }
        catch (Exception e) {
            throw new RendererException(e);
        }
    }

    @Override
    public List<PageRaster> remoteRender(Document document, int begin, int end) throws IOException, RendererException, DocumentException {
        return this.run(document, begin, end);
    }

    @Override
    public List<Image> render(Document document) throws IOException, RendererException, DocumentException {
        return this.render(document, 0, document.getPageCount() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Image> render(Document document, int begin, int end) throws IOException, RendererException, DocumentException {
        if (begin > end) throw new RendererException("Invalid page range");
        if (end > document.getPageCount()) throw new RendererException("Invalid page range");
        if (begin < 0) throw new RendererException("Invalid page range");
        if (end < 0) {
            throw new RendererException("Invalid page range");
        }
        if (this.maxProcessCount == 0) {
            return ImageUtil.convertPageRastersToImages(this.run(document, begin, end));
        }
        this.waitForFreeProcess();
        ++this.processCount;
        if (!this.isStandAloneModeSupported()) {
            throw new RendererException("Standalone mode is not supported by this renderer: no 'main' method found");
        }
        JavaFork fork = this.buildJavaFork();
        int documentMbSize = document.getSize() / 1024 / 1024 + 1;
        int xmxValue = 64 + documentMbSize;
        fork.setXmx(xmxValue + "m");
        int cajoPort = 0;
        try {
            try {
                cajoPort = this.startRemoteServer(fork);
                Object remote = this.getRemoteComponent(cajoPort, RemoteRenderer.class);
                Remote.invoke(remote, "copySettings", this.extractSettings());
                Object[] args = new Object[]{document, begin, end};
                List<Image> list = ImageUtil.convertPageRastersToImages((List)Remote.invoke(remote, "remoteRender", args));
                Object var12_13 = null;
                --this.processCount;
                fork.stop();
                return list;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RendererException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            --this.processCount;
            fork.stop();
            throw throwable;
        }
    }
}

