/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.invoke;

import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.MarshalledObject;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JFrame;

final class Loader
extends Frame
implements WindowListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "cajo Proxy Viewer - ";
    private static Button load;
    private static TextField host;
    private static TextField port;
    private static TextField item;
    private static TextField status;
    private final LinkedList proxies = new LinkedList();
    private boolean main;
    private Graphics gbuffer;
    private Image ibuffer;

    private Loader(String title) {
        super(title);
    }

    Loader() {
        super("Load cajo proxy");
        this.addWindowListener(this);
        this.main = true;
        this.setLayout(null);
        int WIDTH = 250;
        int HEIGHT = 200;
        int ROW1 = 33;
        int ROW2 = 66;
        int ROW3 = 99;
        int ROW4 = 132;
        this.setSize(250, 200);
        Label label = new Label("Host:");
        this.add(label);
        label.setBounds(20, 33, 35, 20);
        host = new TextField();
        this.add(host);
        host.setBounds(62, 33, 166, 20);
        label = new Label("Port:");
        this.add(label);
        label.setBounds(20, 66, 35, 20);
        port = new TextField("1198");
        this.add(port);
        port.setBounds(145, 66, 83, 20);
        label = new Label("Item:");
        this.add(label);
        label.setBounds(20, 99, 35, 20);
        item = new TextField("main");
        this.add(item);
        item.setBounds(62, 99, 166, 20);
        load = new Button("Load");
        this.add(load);
        load.setBounds(83, 132, 83, 25);
        load.addActionListener(this);
        status = new TextField("ready to load proxy");
        this.add(status);
        status.setBounds(1, 179, 248, 20);
        status.setEditable(false);
        status.setBackground(this.getBackground());
        this.setResizable(false);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String url = "//" + host.getText().trim() + ':' + port.getText().trim() + '/' + item.getText().trim();
            status.setText("requesting proxy " + url);
            Object proxy = Remote.getItem(url);
            proxy = Remote.invoke(proxy, "getProxy", null);
            if (proxy instanceof MarshalledObject) {
                proxy = ((MarshalledObject)proxy).get();
            }
            if (!(proxy instanceof RemoteInvoke)) {
                proxy = Remote.invoke(proxy, "init", new Remote(proxy));
            }
            url = "cajo proxy - " + url;
            if (proxy instanceof JComponent) {
                JFrame frame = new JFrame(TITLE + url);
                if (proxy instanceof WindowListener) {
                    frame.addWindowListener((WindowListener)proxy);
                }
                frame.setDefaultCloseOperation(2);
                frame.getContentPane().add((JComponent)proxy);
                frame.pack();
                frame.setVisible(true);
            } else if (proxy instanceof Component) {
                Loader frame = new Loader(TITLE + url);
                frame.add((Component)proxy);
                if (proxy instanceof WindowListener) {
                    frame.addWindowListener((WindowListener)proxy);
                }
                frame.addWindowListener(frame);
                frame.pack();
                frame.setVisible(true);
            } else {
                this.proxies.add(proxy);
            }
            status.setText("proxy loaded");
        }
        catch (Exception x) {
            status.setText(x.toString());
            Toolkit.getDefaultToolkit().beep();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void update(Graphics g) {
        int tempW = this.getWidth();
        int tempH = this.getHeight();
        if (this.ibuffer == null || this.ibuffer.getWidth(null) != tempW || this.ibuffer.getHeight(null) != tempH) {
            if (this.ibuffer != null) {
                this.ibuffer.flush();
            }
            this.ibuffer = this.createImage(tempW, tempH);
            if (this.gbuffer != null) {
                this.gbuffer.dispose();
            }
            this.gbuffer = this.ibuffer.getGraphics();
        }
        this.gbuffer.clearRect(0, 0, tempW, tempH);
        this.paint(this.gbuffer);
        g.drawImage(this.ibuffer, 0, 0, null);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
        if (this.main) {
            System.exit(0);
        }
    }
}

