/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.resource.CacheManagerEntityV2;
import net.sf.ehcache.management.service.CacheManagerServiceV2;
import net.sf.ehcache.management.service.EntityResourceFactoryV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.ResponseEntityV2;
import org.terracotta.management.resource.exceptions.ResourceRuntimeException;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/v2/agents/cacheManagers")
public final class CacheManagersResourceServiceImplV2 {
    public static final String ATTR_QUERY_KEY = "show";
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagersResourceServiceImplV2.class);
    private final EntityResourceFactoryV2 entityResourceFactory = (EntityResourceFactoryV2)ServiceLocator.locate(EntityResourceFactoryV2.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);
    private final CacheManagerServiceV2 cacheMgrSvc = (CacheManagerServiceV2)ServiceLocator.locate(CacheManagerServiceV2.class);

    @GET
    @Produces(value={"application/json"})
    public ResponseEntityV2 getCacheManagers(@Context UriInfo info) {
        LOG.debug(String.format("Invoking getCacheManagers: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String names = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = names == null ? null : new HashSet<String>(Arrays.asList(names.split(",")));
        MultivaluedMap qParams = info.getQueryParameters();
        List attrs = (List)qParams.get((Object)ATTR_QUERY_KEY);
        HashSet<String> cmAttrs = attrs == null || attrs.isEmpty() ? null : new HashSet<String>(attrs);
        try {
            return this.entityResourceFactory.createCacheManagerEntities(cmNames, cmAttrs);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to get cache managers", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateCacheManager(@Context UriInfo info, CacheManagerEntityV2 resource) {
        LOG.debug(String.format("Invoking updateCacheManager: %s", info.getRequestUri()));
        this.validator.validate(info);
        String cacheManagerName = (String)((PathSegment)info.getPathSegments().get(2)).getMatrixParameters().getFirst((Object)"names");
        try {
            this.cacheMgrSvc.updateCacheManager(cacheManagerName, resource);
        }
        catch (ServiceExecutionException e) {
            throw new ResourceRuntimeException("Failed to update cache manager", (Throwable)e, Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

