/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.service.EntityResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.services.AgentsResourceService;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.Utils;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents")
public final class AgentsResourceServiceImpl
implements AgentsResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(AgentsResourceServiceImpl.class);
    private static final Set<String> DFLT_ATTRS = new HashSet<String>(Arrays.asList("Name"));
    private final EntityResourceFactory entityResourceFactory = (EntityResourceFactory)ServiceLocator.locate(EntityResourceFactory.class);
    private final RequestValidator validator = (RequestValidator)ServiceLocator.locate(RequestValidator.class);
    private final ManagementRESTServiceConfiguration mgmtRESTSvcConfig = (ManagementRESTServiceConfiguration)ServiceLocator.locate(ManagementRESTServiceConfiguration.class);

    public Collection<AgentEntity> getAgents(UriInfo info) {
        LOG.info(String.format("Invoking AgentsResourceServiceImpl.getAgents: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        return this.buildAgent();
    }

    public Collection<AgentMetadataEntity> getAgentsMetadata(UriInfo info) {
        LOG.info(String.format("Invoking AgentsResourceServiceImpl.getAgentsMetadata: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        AgentMetadataEntity ame = new AgentMetadataEntity();
        ame.setAgentId("embedded");
        ame.setAgencyOf("Ehcache");
        ame.setVersion(this.getClass().getPackage().getImplementationVersion());
        ame.setAvailable(true);
        ame.setSecured(Utils.trimToNull((String)this.mgmtRESTSvcConfig.getSecurityServiceLocation()) != null);
        ame.setLicensed(((LicenseService)ServiceLocator.locate(LicenseService.class)).isLicensed());
        ame.setNeedClientAuth(this.mgmtRESTSvcConfig.isNeedClientAuth());
        ame.setSampleHistorySize(this.mgmtRESTSvcConfig.getSampleHistorySize());
        ame.setSampleIntervalSeconds(this.mgmtRESTSvcConfig.getSampleIntervalSeconds());
        return Collections.singleton(ame);
    }

    private Collection<AgentEntity> buildAgent() {
        AgentEntity e = new AgentEntity();
        e.setAgentId("embedded");
        HashSet<CacheManagerEntity> reps = new HashSet<CacheManagerEntity>();
        reps.addAll(this.entityResourceFactory.createCacheManagerEntities(null, DFLT_ATTRS));
        e.setRootRepresentables(reps);
        return Collections.singleton(e);
    }
}

