/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.ManagementServer;
import net.sf.ehcache.management.resource.services.validator.impl.EmbeddedEhcacheRequestValidator;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryService;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.embedded.StandaloneServer;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.LicenseServiceImpl;
import org.terracotta.management.resource.services.validator.RequestValidator;

public final class ManagementServerImpl
implements ManagementServer {
    private final StandaloneServer standaloneServer;
    private final SamplerRepositoryService samplerRepoSvc;

    public ManagementServerImpl(ManagementRESTServiceConfiguration configuration) {
        configuration.setNeedClientAuth(false);
        configuration.setSecurityServiceLocation(null);
        configuration.setSslEnabled(false);
        configuration.setSecurityServiceTimeout(0);
        String basePackage = "net.sf.ehcache.management";
        String host = configuration.getHost();
        int port = configuration.getPort();
        this.loadEmbeddedAgentServiceLocator(configuration);
        this.samplerRepoSvc = (SamplerRepositoryService)ServiceLocator.locate(SamplerRepositoryService.class);
        this.standaloneServer = new StandaloneServer(null, null, basePackage, host, port, null, false);
    }

    public void start() {
        try {
            this.standaloneServer.start();
        }
        catch (Exception e) {
            throw new CacheException("error starting management server", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.standaloneServer.stop();
        }
        catch (Exception e) {
            throw new CacheException("error stopping management server", (Throwable)e);
        }
    }

    public void register(CacheManager managedResource) {
        this.samplerRepoSvc.register(managedResource);
    }

    public void unregister(CacheManager managedResource) {
        this.samplerRepoSvc.unregister(managedResource);
        ServiceLocator.unload();
    }

    public boolean hasRegistered() {
        return this.samplerRepoSvc.hasRegistered();
    }

    private void loadEmbeddedAgentServiceLocator(ManagementRESTServiceConfiguration configuration) {
        DfltSamplerRepositoryService samplerRepoSvc = new DfltSamplerRepositoryService();
        LicenseServiceImpl licenseService = new LicenseServiceImpl(false);
        ServiceLocator locator = new ServiceLocator().loadService(LicenseService.class, (Object)licenseService).loadService(RequestValidator.class, (Object)new EmbeddedEhcacheRequestValidator()).loadService(CacheManagerService.class, (Object)samplerRepoSvc).loadService(CacheService.class, (Object)samplerRepoSvc).loadService(EntityResourceFactory.class, (Object)samplerRepoSvc).loadService(SamplerRepositoryService.class, (Object)samplerRepoSvc).loadService(ManagementRESTServiceConfiguration.class, (Object)configuration);
        ServiceLocator.load((ServiceLocator)locator);
    }
}

